/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage2;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompilerIndexPlannerHelper;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompilerIndexPlannerHint;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.epl.expression.core.ExprContextPropertyNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterOptimizableNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterSpecLookupableForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeDeployTimeConst;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprBetweenNode;
import com.espertech.esper.common.internal.epl.pattern.core.MatchedEventConvertorForge;
import com.espertech.esper.common.internal.filterspec.FilterForEvalConstantDoubleForge;
import com.espertech.esper.common.internal.filterspec.FilterForEvalConstantStringForge;
import com.espertech.esper.common.internal.filterspec.FilterForEvalContextPropDoubleForge;
import com.espertech.esper.common.internal.filterspec.FilterForEvalContextPropStringForge;
import com.espertech.esper.common.internal.filterspec.FilterForEvalDeployTimeConstDoubleForge;
import com.espertech.esper.common.internal.filterspec.FilterForEvalDeployTimeConstStringForge;
import com.espertech.esper.common.internal.filterspec.FilterForEvalLimitedExprForge;
import com.espertech.esper.common.internal.filterspec.FilterOperator;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamFilterForEvalForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamRangeForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SimpleNumberCoercer;
import com.espertech.esper.common.internal.util.SimpleNumberCoercerFactory;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;

public class FilterSpecCompilerIndexPlannerRange {
    public static FilterSpecParamForge handleRangeNode(ExprBetweenNode betweenNode, LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, LinkedHashSet<String> allTagNamesOrdered, String statementName, StatementRawInfo raw, StatementCompileTimeServices services) throws ExprValidationException {
        ExprNode left = betweenNode.getChildNodes()[0];
        ExprFilterSpecLookupableForge lookupable = null;
        if (left instanceof ExprFilterOptimizableNode) {
            ExprFilterOptimizableNode filterOptimizableNode = (ExprFilterOptimizableNode)((Object)left);
            lookupable = filterOptimizableNode.getFilterLookupable();
        } else if (FilterSpecCompilerIndexPlannerHelper.hasLevelOrHint(FilterSpecCompilerIndexPlannerHint.LKUPCOMPOSITE, raw, services) && FilterSpecCompilerIndexPlannerHelper.isLimitedLookupableExpression(left)) {
            lookupable = FilterSpecCompilerIndexPlannerHelper.makeLimitedLookupableForgeMayNull(left, raw, services);
        }
        if (lookupable == null) {
            return null;
        }
        FilterOperator op = FilterOperator.parseRangeOperator(betweenNode.isLowEndpointIncluded(), betweenNode.isHighEndpointIncluded(), betweenNode.isNotBetween());
        FilterSpecParamFilterForEvalForge low = FilterSpecCompilerIndexPlannerRange.handleRangeNodeEndpoint(betweenNode.getChildNodes()[1], taggedEventTypes, arrayEventTypes, allTagNamesOrdered, statementName, raw, services);
        FilterSpecParamFilterForEvalForge high = FilterSpecCompilerIndexPlannerRange.handleRangeNodeEndpoint(betweenNode.getChildNodes()[2], taggedEventTypes, arrayEventTypes, allTagNamesOrdered, statementName, raw, services);
        return low == null || high == null ? null : new FilterSpecParamRangeForge(lookupable, op, low, high);
    }

    private static FilterSpecParamFilterForEvalForge handleRangeNodeEndpoint(ExprNode endpoint, LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, LinkedHashSet<String> allTagNamesOrdered, String statementName, StatementRawInfo raw, StatementCompileTimeServices services) throws ExprValidationException {
        if (endpoint.getForge().getForgeConstantType().isCompileTimeConstant()) {
            Object value = endpoint.getForge().getExprEvaluator().evaluate(null, true, null);
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                return new FilterForEvalConstantStringForge((String)value);
            }
            return new FilterForEvalConstantDoubleForge(((Number)value).doubleValue());
        }
        if (endpoint instanceof ExprContextPropertyNode) {
            ExprContextPropertyNode node = (ExprContextPropertyNode)((Object)endpoint);
            if (JavaClassHelper.isImplementsCharSequence(node.getType())) {
                return new FilterForEvalContextPropStringForge(node.getGetter(), node.getPropertyName());
            }
            return new FilterForEvalContextPropDoubleForge(node.getGetter(), node.getPropertyName());
        }
        if (endpoint.getForge().getForgeConstantType().isDeployTimeTimeConstant() && endpoint instanceof ExprNodeDeployTimeConst) {
            ExprNodeDeployTimeConst node = (ExprNodeDeployTimeConst)((Object)endpoint);
            if (JavaClassHelper.isImplementsCharSequence(endpoint.getForge().getEvaluationType())) {
                return new FilterForEvalDeployTimeConstStringForge(node);
            }
            return new FilterForEvalDeployTimeConstDoubleForge(node);
        }
        if (endpoint instanceof ExprIdentNode) {
            return FilterSpecCompilerIndexPlannerHelper.getIdentNodeDoubleEval((ExprIdentNode)endpoint, arrayEventTypes, statementName);
        }
        if (FilterSpecCompilerIndexPlannerHelper.hasLevelOrHint(FilterSpecCompilerIndexPlannerHint.VALUECOMPOSITE, raw, services) && FilterSpecCompilerIndexPlannerHelper.isLimitedValueExpression(endpoint)) {
            Class returnType = endpoint.getForge().getEvaluationType();
            MatchedEventConvertorForge convertor = FilterSpecCompilerIndexPlannerHelper.getMatchEventConvertor(endpoint, taggedEventTypes, arrayEventTypes, allTagNamesOrdered);
            if (JavaClassHelper.isImplementsCharSequence(returnType)) {
                return new FilterForEvalLimitedExprForge(endpoint, convertor, null);
            }
            SimpleNumberCoercer coercer = SimpleNumberCoercerFactory.getCoercer(returnType, Double.class);
            return new FilterForEvalLimitedExprForge(endpoint, convertor, coercer);
        }
        return null;
    }
}

