/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage2;

import com.espertech.esper.common.internal.collection.CombinationEnumeration;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompilerArgs;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompilerConsolidateUtil;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompilerIndexPlannerHelper;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecParaForgeMap;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlanForge;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlanPathForge;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlanPathTripletForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprOrNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FilterSpecCompilerIndexPlannerWidthBasic {
    protected static FilterSpecPlanForge planRemainingNodesBasic(FilterSpecParaForgeMap overallExpressions, FilterSpecCompilerArgs args, int filterServiceMaxFilterWidth) throws ExprValidationException {
        List<ExprNode> unassigned = overallExpressions.getUnassignedExpressions();
        ArrayList<ExprOrNode> orNodes = new ArrayList<ExprOrNode>(unassigned.size());
        for (ExprNode node : unassigned) {
            if (!(node instanceof ExprOrNode)) continue;
            orNodes.add((ExprOrNode)node);
        }
        FilterSpecParaForgeMap expressionsWithoutOr = new FilterSpecParaForgeMap();
        expressionsWithoutOr.add(overallExpressions);
        FilterSpecParaForgeMap[][] orNodesMaps = new FilterSpecParaForgeMap[orNodes.size()][];
        int countOr = 0;
        int sizeFactorized = 1;
        int[] sizePerOr = new int[orNodes.size()];
        for (ExprOrNode orNode : orNodes) {
            expressionsWithoutOr.removeNode(orNode);
            orNodesMaps[countOr] = new FilterSpecParaForgeMap[orNode.getChildNodes().length];
            int len = orNode.getChildNodes().length;
            for (int i = 0; i < len; ++i) {
                FilterSpecParaForgeMap map;
                orNodesMaps[countOr][i] = map = new FilterSpecParaForgeMap();
                List<ExprNode> nodes = Collections.singletonList(orNode.getChildNodes()[i]);
                FilterSpecCompilerIndexPlannerHelper.decomposePopulateConsolidate(map, false, nodes, args);
            }
            sizePerOr[countOr] = len;
            sizeFactorized *= len;
            ++countOr;
        }
        if (sizeFactorized > filterServiceMaxFilterWidth) {
            return null;
        }
        FilterSpecPlanPathForge[] result = new FilterSpecPlanPathForge[sizeFactorized];
        CombinationEnumeration permutations = CombinationEnumeration.fromZeroBasedRanges(sizePerOr);
        int count = 0;
        while (permutations.hasMoreElements()) {
            Object[] permutation = permutations.nextElement();
            result[count] = FilterSpecCompilerIndexPlannerWidthBasic.computePermutation(expressionsWithoutOr, permutation, orNodesMaps, args);
            ++count;
        }
        return new FilterSpecPlanForge(result, null, null, null);
    }

    private static FilterSpecPlanPathForge computePermutation(FilterSpecParaForgeMap filterParamExprMap, Object[] permutation, FilterSpecParaForgeMap[][] orNodesMaps, FilterSpecCompilerArgs args) throws ExprValidationException {
        FilterSpecParaForgeMap mapAll = new FilterSpecParaForgeMap();
        mapAll.add(filterParamExprMap);
        for (int orNodeNum = 0; orNodeNum < permutation.length; ++orNodeNum) {
            int orChildNodeNum = (Integer)permutation[orNodeNum];
            FilterSpecParaForgeMap mapOrSub = orNodesMaps[orNodeNum][orChildNodeNum];
            mapAll.add(mapOrSub);
        }
        FilterSpecCompilerConsolidateUtil.consolidate(mapAll, args.statementRawInfo.getStatementName());
        ArrayList<FilterSpecPlanPathTripletForge> filterParams = new ArrayList<FilterSpecPlanPathTripletForge>(mapAll.getTriplets());
        int countUnassigned = mapAll.countUnassignedExpressions();
        if (countUnassigned != 0) {
            FilterSpecPlanPathTripletForge node = FilterSpecCompilerIndexPlannerHelper.makeRemainingNode(mapAll.getUnassignedExpressions(), args);
            filterParams.add(node);
        }
        FilterSpecPlanPathTripletForge[] triplets = filterParams.toArray(new FilterSpecPlanPathTripletForge[0]);
        return new FilterSpecPlanPathForge(triplets, null);
    }
}

