/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage2;

import com.espertech.esper.common.internal.collection.CombinationEnumeration;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompilerArgs;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompilerConsolidateUtil;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompilerIndexPlannerHelper;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecExprNodeVisitorValueLimitedExpr;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecParaForgeMap;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlanForge;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlanPathForge;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlanPathTripletForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCompare;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityMake;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprNotNode;
import com.espertech.esper.common.internal.epl.expression.ops.ExprOrNode;
import com.espertech.esper.common.internal.epl.pattern.core.MatchedEventConvertorForge;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class FilterSpecCompilerIndexPlannerWidthWithConditions {
    protected static FilterSpecPlanForge planRemainingNodesWithConditions(FilterSpecParaForgeMap overallExpressions, FilterSpecCompilerArgs args, int filterServiceMaxFilterWidth, ExprNode topLevelNegator) throws ExprValidationException {
        List<ExprNode> unassigned = overallExpressions.getUnassignedExpressions();
        ArrayList<ExprOrNode> orNodes = new ArrayList<ExprOrNode>(unassigned.size());
        for (ExprNode node : unassigned) {
            if (!(node instanceof ExprOrNode)) continue;
            orNodes.add((ExprOrNode)node);
        }
        FilterSpecParaForgeMap expressionsWithoutOr = new FilterSpecParaForgeMap();
        expressionsWithoutOr.add(overallExpressions);
        int countOr = 0;
        int sizeFactorized = 1;
        int[] sizePerOr = new int[orNodes.size()];
        OrChildNode[][] orChildNodes = new OrChildNode[orNodes.size()][];
        boolean hasControl = false;
        for (ExprOrNode orNode : orNodes) {
            expressionsWithoutOr.removeNode(orNode);
            List<ExprNode> nonValueNodes = FilterSpecCompilerIndexPlannerWidthWithConditions.getNonValueChildNodes(orNode);
            ArrayList<ExprNode> valueNodes = new ArrayList<ExprNode>(Arrays.asList(orNode.getChildNodes()));
            valueNodes.removeAll(nonValueNodes);
            ExprNode singleValueNode = ExprNodeUtilityMake.connectExpressionsByLogicalOrWhenNeeded(valueNodes);
            ArrayList<ExprNode> allChildNodes = new ArrayList<ExprNode>(nonValueNodes);
            if (singleValueNode != null) {
                allChildNodes.add(singleValueNode);
            }
            int len = allChildNodes.size();
            orChildNodes[countOr] = new OrChildNode[len];
            for (int i = 0; i < len; ++i) {
                ExprNode child = (ExprNode)allChildNodes.get(i);
                if (child == singleValueNode) {
                    hasControl = true;
                    orChildNodes[countOr][i] = new OrChildNodeV(singleValueNode);
                    continue;
                }
                FilterSpecParaForgeMap map = new FilterSpecParaForgeMap();
                List<ExprNode> nodes = Collections.singletonList(child);
                ExprNode confirm = FilterSpecCompilerIndexPlannerHelper.decomposePopulateConsolidate(map, true, nodes, args);
                if (confirm == null) {
                    orChildNodes[countOr][i] = new OrChildNodeNV(child, map);
                    continue;
                }
                hasControl = true;
                orChildNodes[countOr][i] = new OrChildNodeNVNegated(child, map, confirm);
            }
            sizePerOr[countOr] = len;
            sizeFactorized *= len;
            ++countOr;
        }
        CombPermutationTriplets[] permutations = new CombPermutationTriplets[sizeFactorized];
        CombinationEnumeration combinationEnumeration = CombinationEnumeration.fromZeroBasedRanges(sizePerOr);
        int count = 0;
        while (combinationEnumeration.hasMoreElements()) {
            Object[] permutation = combinationEnumeration.nextElement();
            permutations[count] = FilterSpecCompilerIndexPlannerWidthWithConditions.computePermutation(expressionsWithoutOr, permutation, orChildNodes, hasControl, args);
            ++count;
        }
        ArrayList<FilterSpecPlanPathForge> result = new ArrayList<FilterSpecPlanPathForge>(sizeFactorized);
        ArrayList<ExprNode> pathControlConfirm = new ArrayList<ExprNode>();
        for (CombPermutationTriplets permutation : permutations) {
            if (permutation.getTriplets().length > 0) {
                result.add(new FilterSpecPlanPathForge(permutation.getTriplets(), permutation.getNegateCondition()));
                continue;
            }
            pathControlConfirm.add(permutation.getNegateCondition());
        }
        if (result.size() > filterServiceMaxFilterWidth) {
            return null;
        }
        FilterSpecPlanPathForge[] pathArray = result.toArray(new FilterSpecPlanPathForge[0]);
        ExprNode topLevelConfirmer = ExprNodeUtilityMake.connectExpressionsByLogicalOrWhenNeeded(pathControlConfirm);
        if (topLevelConfirmer != null) {
            ExprNotNode not = new ExprNotNode();
            not.addChildNode(topLevelConfirmer);
            for (FilterSpecPlanPathForge path : pathArray) {
                if (!ExprNodeUtilityCompare.deepEquals(not, path.getPathNegate(), true)) continue;
                path.setPathNegate(null);
            }
        }
        MatchedEventConvertorForge convertor = new MatchedEventConvertorForge(args.taggedEventTypes, args.arrayEventTypes, args.allTagNamesOrdered, null, true);
        return new FilterSpecPlanForge(pathArray, topLevelConfirmer, topLevelNegator, convertor);
    }

    private static List<ExprNode> getNonValueChildNodes(ExprOrNode orNode) {
        ArrayList<ExprNode> childNodes = new ArrayList<ExprNode>(orNode.getChildNodes().length);
        for (ExprNode node : orNode.getChildNodes()) {
            FilterSpecExprNodeVisitorValueLimitedExpr visitor = new FilterSpecExprNodeVisitorValueLimitedExpr();
            node.accept(visitor);
            if (visitor.isLimited()) continue;
            childNodes.add(node);
        }
        return childNodes;
    }

    private static CombPermutationTriplets computePermutation(FilterSpecParaForgeMap filterParamExprMap, Object[] permutation, OrChildNode[][] orChildNodes, boolean hasControl, FilterSpecCompilerArgs args) throws ExprValidationException {
        FilterSpecParaForgeMap mapAll = new FilterSpecParaForgeMap();
        mapAll.add(filterParamExprMap);
        ArrayList<ExprNode> nvPerOr = new ArrayList<ExprNode>(permutation.length);
        ArrayList<ExprNode> negatingPath = new ArrayList<ExprNode>(permutation.length);
        for (int orNodeNum = 0; orNodeNum < permutation.length; ++orNodeNum) {
            OrChildNode[] orChildNodesForCurrent;
            int orChildNodeNum = (Integer)permutation[orNodeNum];
            OrChildNode current = orChildNodes[orNodeNum][orChildNodeNum];
            if (current instanceof OrChildNodeNV) {
                OrChildNodeNV nv = (OrChildNodeNV)current;
                mapAll.add(nv.getMap());
                if (current instanceof OrChildNodeNVNegated) {
                    negatingPath.add(((OrChildNodeNVNegated)current).getControl());
                }
            } else {
                OrChildNodeV v = (OrChildNodeV)current;
                negatingPath.add(v.getNode());
            }
            for (OrChildNode other : orChildNodesForCurrent = orChildNodes[orNodeNum]) {
                if (current == other || !(other instanceof OrChildNodeV)) continue;
                OrChildNodeV v = (OrChildNodeV)other;
                ExprNotNode not = new ExprNotNode();
                not.addChildNode(v.getNode());
                nvPerOr.add(not);
            }
        }
        FilterSpecCompilerConsolidateUtil.consolidate(mapAll, args.statementRawInfo.getStatementName());
        ArrayList<FilterSpecPlanPathTripletForge> triplets = new ArrayList<FilterSpecPlanPathTripletForge>(mapAll.getTriplets());
        int countUnassigned = mapAll.countUnassignedExpressions();
        if (countUnassigned != 0) {
            FilterSpecPlanPathTripletForge triplet = FilterSpecCompilerIndexPlannerHelper.makeRemainingNode(mapAll.getUnassignedExpressions(), args);
            triplets.add(triplet);
        }
        FilterSpecPlanPathTripletForge[] tripletsArray = triplets.toArray(new FilterSpecPlanPathTripletForge[0]);
        if (!hasControl) {
            return new CombPermutationTriplets(tripletsArray, null);
        }
        ExprNode negatingNode = ExprNodeUtilityMake.connectExpressionsByLogicalAndWhenNeeded(negatingPath);
        ExprNode excluded = ExprNodeUtilityMake.connectExpressionsByLogicalAndWhenNeeded(nvPerOr);
        ExprNode merged = ExprNodeUtilityMake.connectExpressionsByLogicalAndWhenNeeded(negatingNode, excluded);
        return new CombPermutationTriplets(tripletsArray, merged);
    }

    private static class OrChildNodeNVNegated
    extends OrChildNodeNV {
        private final ExprNode control;

        public OrChildNodeNVNegated(ExprNode node, FilterSpecParaForgeMap map, ExprNode control) {
            super(node, map);
            this.control = control;
        }

        public ExprNode getControl() {
            return this.control;
        }
    }

    private static class OrChildNodeNV
    implements OrChildNode {
        private final ExprNode node;
        private final FilterSpecParaForgeMap map;

        public OrChildNodeNV(ExprNode node, FilterSpecParaForgeMap map) {
            this.node = node;
            this.map = map;
        }

        public ExprNode getNode() {
            return this.node;
        }

        public FilterSpecParaForgeMap getMap() {
            return this.map;
        }
    }

    private static class OrChildNodeV
    implements OrChildNode {
        private final ExprNode node;

        public OrChildNodeV(ExprNode node) {
            this.node = node;
        }

        public ExprNode getNode() {
            return this.node;
        }
    }

    private static interface OrChildNode {
    }

    private static class CombPermutationTriplets {
        private final FilterSpecPlanPathTripletForge[] triplets;
        private final ExprNode negateCondition;

        public CombPermutationTriplets(FilterSpecPlanPathTripletForge[] triplets, ExprNode negateCondition) {
            this.triplets = triplets;
            this.negateCondition = negateCondition;
        }

        public FilterSpecPlanPathTripletForge[] getTriplets() {
            return this.triplets;
        }

        public ExprNode getNegateCondition() {
            return this.negateCondition;
        }
    }
}

