/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage2;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.internal.compile.stage2.EvalNodeUtil;
import com.espertech.esper.common.internal.compile.stage2.StreamSpecCompiler;
import com.espertech.esper.common.internal.epl.pattern.core.EvalForgeNode;
import com.espertech.esper.common.internal.epl.pattern.filter.EvalFilterForgeNode;
import java.util.LinkedHashSet;
import java.util.Set;

public class FilterSpecCompilerTagUtil {
    public static LinkedHashSet<String> getAllTagNamesOrdered(Set<String> priorAllTags, EvalForgeNode evalForgeNode) {
        LinkedHashSet<String> allTagNamesOrdered = new LinkedHashSet<String>();
        Set<EvalForgeNode> filterFactoryNodes = EvalNodeUtil.recursiveGetChildNodes(evalForgeNode, StreamSpecCompiler.FilterForFilterFactoryNodes.INSTANCE);
        if (priorAllTags != null) {
            allTagNamesOrdered.addAll(priorAllTags);
        }
        for (EvalForgeNode filterNode : filterFactoryNodes) {
            int tagNumber;
            EvalFilterForgeNode forge = (EvalFilterForgeNode)filterNode;
            if (forge.getEventAsName() == null) continue;
            if (!allTagNamesOrdered.contains(forge.getEventAsName())) {
                allTagNamesOrdered.add(forge.getEventAsName());
                tagNumber = allTagNamesOrdered.size() - 1;
            } else {
                tagNumber = FilterSpecCompilerTagUtil.findTagNumber(forge.getEventAsName(), allTagNamesOrdered);
            }
            forge.setEventAsTagNumber(tagNumber);
        }
        return allTagNamesOrdered;
    }

    public static int findTagNumber(String findTag, LinkedHashSet<String> allTagNamesOrdered) {
        int index = 0;
        for (String tag : allTagNamesOrdered) {
            if (findTag.equals(tag)) {
                return index;
            }
            ++index;
        }
        throw new EPException("Failed to find tag '" + findTag + "' among known tags");
    }
}

