/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage2;

import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerPlugInSingleRowFunction;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprLambdaGoesNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprContextPropertyNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeWithChainSpec;
import com.espertech.esper.common.internal.epl.expression.core.ExprStreamRefNode;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNode;
import com.espertech.esper.common.internal.epl.expression.funcs.ExprPlugInSingleRowNode;
import com.espertech.esper.common.internal.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.common.internal.epl.expression.table.ExprTableAccessNode;
import com.espertech.esper.common.internal.epl.expression.variable.ExprVariableNode;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVisitor;
import com.espertech.esper.common.internal.epl.script.core.ExprNodeScript;

public class FilterSpecExprNodeVisitorLookupableLimitedExpr
implements ExprNodeVisitor {
    private boolean limited = true;
    private boolean hasStreamZeroReference = false;

    @Override
    public boolean isVisit(ExprNode exprNode) {
        return this.limited;
    }

    @Override
    public void visit(ExprNode exprNode) {
        Object node;
        if (exprNode instanceof ExprStreamRefNode) {
            ExprIdentNode identNode;
            ExprStreamRefNode streamRefNode = (ExprStreamRefNode)exprNode;
            Integer stream = streamRefNode.getStreamReferencedIfAny();
            if (stream != null) {
                if (stream == 0) {
                    this.hasStreamZeroReference = true;
                } else {
                    this.limited = false;
                }
            }
            if (exprNode instanceof ExprIdentNode && (identNode = (ExprIdentNode)exprNode).getExprEvaluatorIdent().isContextEvaluated()) {
                this.limited = false;
            }
        }
        if (exprNode instanceof ExprNodeWithChainSpec && !((ExprNodeWithChainSpec)((Object)exprNode)).getChainSpec().isEmpty()) {
            this.limited = false;
        }
        if (exprNode instanceof ExprVariableNode) {
            node = (ExprVariableNode)((Object)exprNode);
            if (!node.getVariableMetadata().isConstant()) {
                this.limited = false;
            }
        } else if (exprNode instanceof ExprTableAccessNode || exprNode instanceof ExprSubselectNode || exprNode instanceof ExprLambdaGoesNode || exprNode instanceof ExprContextPropertyNode || exprNode instanceof ExprNodeScript) {
            this.limited = false;
        } else if (exprNode instanceof ExprPlugInSingleRowNode) {
            ExprPlugInSingleRowNode plugIn = (ExprPlugInSingleRowNode)exprNode;
            if (plugIn.getConfig() != null && plugIn.getConfig().getFilterOptimizable() == ConfigurationCompilerPlugInSingleRowFunction.FilterOptimizable.DISABLED) {
                this.limited = false;
            }
            if (plugIn.isLocalInlinedClass()) {
                this.limited = false;
            }
        } else if (exprNode instanceof ExprDotNode && (node = (ExprDotNode)exprNode).isLocalInlinedClass()) {
            this.limited = false;
        }
    }

    public boolean isLimited() {
        return this.limited;
    }

    public boolean isHasStreamZeroReference() {
        return this.hasStreamZeroReference;
    }
}

