/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage2;

import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlan;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlanCompute;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlanComputeConditionalPath;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlanComputeConditionalTopOnly;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlanComputeConditionalTriplets;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlanComputeUnconditional;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlanPath;

public class FilterSpecPlanComputeFactory {
    public static FilterSpecPlanCompute make(FilterSpecPlan plan) {
        boolean hasTopControl = plan.filterConfirm != null || plan.filterNegate != null;
        boolean hasPathControl = false;
        boolean hasTripletControl = false;
        for (FilterSpecPlanPath path : plan.paths) {
            hasPathControl |= path.getPathNegate() != null;
            hasTripletControl |= path.hasTripletControl();
        }
        if (hasTripletControl) {
            return FilterSpecPlanComputeConditionalTriplets.INSTANCE;
        }
        if (hasPathControl) {
            return FilterSpecPlanComputeConditionalPath.INSTANCE;
        }
        if (hasTopControl) {
            return FilterSpecPlanComputeConditionalTopOnly.INSTANCE;
        }
        return FilterSpecPlanComputeUnconditional.INSTANCE;
    }
}

