/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage2;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompiler;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompilerArgs;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlan;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlanPath;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlanPathForge;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlanPathTripletForge;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbolWEventType;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCodegen;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCompare;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.pattern.core.MatchedEventConvertorForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamForge;
import java.util.Collection;

public class FilterSpecPlanForge {
    public static final FilterSpecPlanForge EMPTY = new FilterSpecPlanForge(new FilterSpecPlanPathForge[0], null, null, null);
    private final FilterSpecPlanPathForge[] paths;
    private ExprNode filterConfirm;
    private ExprNode filterNegate;
    private MatchedEventConvertorForge convertorForge;

    public FilterSpecPlanForge(FilterSpecPlanPathForge[] paths, ExprNode filterConfirm, ExprNode filterNegate, MatchedEventConvertorForge convertorForge) {
        this.paths = paths;
        this.filterConfirm = filterConfirm;
        this.filterNegate = filterNegate;
        this.convertorForge = convertorForge;
    }

    public FilterSpecPlanPathForge[] getPaths() {
        return this.paths;
    }

    public ExprNode getFilterConfirm() {
        return this.filterConfirm;
    }

    public void setFilterConfirm(ExprNode filterConfirm) {
        this.filterConfirm = filterConfirm;
    }

    public ExprNode getFilterNegate() {
        return this.filterNegate;
    }

    public boolean equalsFilter(FilterSpecPlanForge other) {
        if (this.paths.length != other.getPaths().length) {
            return false;
        }
        for (int i = 0; i < this.paths.length; ++i) {
            FilterSpecPlanPathForge myPath = this.paths[i];
            FilterSpecPlanPathForge otherPath = other.paths[i];
            if (myPath.equalsFilter(otherPath)) continue;
            return false;
        }
        if (!ExprNodeUtilityCompare.deepEqualsNullChecked(this.filterConfirm, other.filterConfirm, true)) {
            return false;
        }
        return ExprNodeUtilityCompare.deepEqualsNullChecked(this.filterNegate, other.filterNegate, true);
    }

    public CodegenMethod codegenWithEventType(CodegenMethodScope parent, CodegenClassScope classScope) {
        SAIFFInitializeSymbolWEventType symbolsWithType = new SAIFFInitializeSymbolWEventType();
        CodegenMethod method = parent.makeChildWithScope(FilterSpecPlan.class, FilterSpecParamForge.class, symbolsWithType, classScope).addParam(EventType.class, SAIFFInitializeSymbolWEventType.REF_EVENTTYPE.getRef()).addParam(EPStatementInitServices.class, SAIFFInitializeSymbolWEventType.REF_STMTINITSVC.getRef());
        if (this.paths.length == 0) {
            method.getBlock().methodReturn(CodegenExpressionBuilder.publicConstValue(FilterSpecPlan.class, "EMPTY_PLAN"));
            return method;
        }
        method.getBlock().declareVar(FilterSpecPlanPath[].class, "paths", CodegenExpressionBuilder.newArrayByLength(FilterSpecPlanPath.class, CodegenExpressionBuilder.constant(this.paths.length)));
        for (int i = 0; i < this.paths.length; ++i) {
            method.getBlock().assignArrayElement("paths", CodegenExpressionBuilder.constant(i), (CodegenExpression)CodegenExpressionBuilder.localMethod(this.paths[i].codegen(method, symbolsWithType, classScope), new CodegenExpression[0]));
        }
        method.getBlock().declareVar(FilterSpecPlan.class, "plan", CodegenExpressionBuilder.newInstance(FilterSpecPlan.class, new CodegenExpression[0])).exprDotMethod(CodegenExpressionBuilder.ref("plan"), "setPaths", CodegenExpressionBuilder.ref("paths")).exprDotMethod(CodegenExpressionBuilder.ref("plan"), "setFilterConfirm", FilterSpecPlanForge.optionalEvaluator(this.filterConfirm, method, classScope)).exprDotMethod(CodegenExpressionBuilder.ref("plan"), "setFilterNegate", FilterSpecPlanForge.optionalEvaluator(this.filterNegate, method, classScope)).exprDotMethod(CodegenExpressionBuilder.ref("plan"), "setConvertor", this.convertorForge == null ? CodegenExpressionBuilder.constantNull() : this.convertorForge.makeAnonymous(method, classScope)).exprDotMethod(CodegenExpressionBuilder.ref("plan"), "initialize", new CodegenExpression[0]).methodReturn(CodegenExpressionBuilder.ref("plan"));
        return method;
    }

    protected static CodegenExpression optionalEvaluator(ExprNode node, CodegenMethod method, CodegenClassScope classScope) {
        return node == null ? CodegenExpressionBuilder.constantNull() : ExprNodeUtilityCodegen.codegenEvaluator(node.getForge(), method, FilterSpecPlanForge.class, classScope);
    }

    public static FilterSpecPlanPathForge makePathFromTriplets(Collection<FilterSpecPlanPathTripletForge> tripletsColl, ExprNode control) {
        FilterSpecPlanPathTripletForge[] triplets = tripletsColl.toArray(new FilterSpecPlanPathTripletForge[0]);
        return new FilterSpecPlanPathForge(triplets, control);
    }

    public static FilterSpecPlanForge makePlanFromTriplets(Collection<FilterSpecPlanPathTripletForge> triplets, ExprNode topLevelNegation, FilterSpecCompilerArgs args) {
        FilterSpecPlanPathForge path = FilterSpecPlanForge.makePathFromTriplets(triplets, null);
        MatchedEventConvertorForge convertor = new MatchedEventConvertorForge(args.taggedEventTypes, args.arrayEventTypes, args.allTagNamesOrdered, null, true);
        return new FilterSpecPlanForge(new FilterSpecPlanPathForge[]{path}, null, topLevelNegation, convertor);
    }

    public MatchedEventConvertorForge getConvertorForge() {
        return this.convertorForge;
    }

    public void appendPlan(StringBuilder buf) {
        if (this.filterNegate != null) {
            FilterSpecPlanForge.logFilterPlanExpr(buf, "filter-negate-expression", this.filterNegate);
        }
        if (this.filterConfirm != null) {
            FilterSpecPlanForge.logFilterPlanExpr(buf, "filter-confirm-expression", this.filterConfirm);
        }
        for (int i = 0; i < this.paths.length; ++i) {
            this.paths[i].appendFilterPlanPath(i, buf);
        }
    }

    private static void logFilterPlanExpr(StringBuilder buf, String name, ExprNode exprNode) {
        buf.append("  -").append(name).append(": ").append(ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(exprNode)).append(FilterSpecCompiler.NEWLINE);
    }
}

