/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage3;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenPackageScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProvider;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProviderEmpty;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassMethods;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassType;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenCtor;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenInnerClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenInstanceAux;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenTypedParam;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionMember;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenStackGenerator;
import com.espertech.esper.common.internal.collection.UniformPair;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeable;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableType;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.agg.core.AggregationClassNames;
import com.espertech.esper.common.internal.epl.agg.core.AggregationService;
import com.espertech.esper.common.internal.epl.agg.core.AggregationServiceFactory;
import com.espertech.esper.common.internal.epl.agg.core.AggregationServiceFactoryCompiler;
import com.espertech.esper.common.internal.epl.agg.core.AggregationServiceFactoryMakeResult;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenNames;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.resultset.codegen.ResultSetProcessorCodegenNames;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessor;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessorDesc;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessorFactory;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessorFactoryForge;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessorFactoryProvider;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessorOutputConditionType;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessorOutputHelperVisitor;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessorType;
import com.espertech.esper.common.internal.epl.resultset.order.OrderByProcessor;
import com.espertech.esper.common.internal.epl.resultset.order.OrderByProcessorCompiler;
import com.espertech.esper.common.internal.epl.resultset.order.OrderByProcessorFactory;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectExprProcessor;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectExprProcessorCodegenSymbol;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectExprProcessorForge;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationCode;
import com.espertech.esper.common.internal.view.core.Viewable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class StmtClassForgeableRSPFactoryProvider
implements StmtClassForgeable {
    private static final String CLASSNAME_RESULTSETPROCESSORFACTORY = "RSPFactory";
    private static final String CLASSNAME_RESULTSETPROCESSOR = "RSP";
    private static final String MEMBERNAME_RESULTSETPROCESSORFACTORY = "rspFactory";
    private static final String MEMBERNAME_AGGREGATIONSVCFACTORY = "aggFactory";
    private static final String MEMBERNAME_ORDERBYFACTORY = "orderByFactory";
    private static final String MEMBERNAME_RESULTEVENTTYPE = "resultEventType";
    private static final CodegenExpressionMember MEMBER_EVENTBEANFACTORY = CodegenExpressionBuilder.member("ebfactory");
    private final String className;
    private final ResultSetProcessorDesc spec;
    private final CodegenPackageScope packageScope;
    private final StatementRawInfo statementRawInfo;

    public StmtClassForgeableRSPFactoryProvider(String className, ResultSetProcessorDesc spec, CodegenPackageScope packageScope, StatementRawInfo statementRawInfo) {
        this.className = className;
        this.spec = spec;
        this.packageScope = packageScope;
        this.statementRawInfo = statementRawInfo;
    }

    @Override
    public CodegenClass forge(boolean includeDebugSymbols, boolean fireAndForget) {
        Supplier<String> debugInformationProvider = new Supplier<String>(){

            @Override
            public String get() {
                StringWriter writer = new StringWriter();
                StmtClassForgeableRSPFactoryProvider.this.statementRawInfo.appendCodeDebugInfo(writer);
                writer.append(" result-set-processor ").append(StmtClassForgeableRSPFactoryProvider.this.spec.getResultSetProcessorFactoryForge().getClass().getName());
                return writer.toString();
            }
        };
        try {
            ArrayList<CodegenInnerClass> innerClasses = new ArrayList<CodegenInnerClass>();
            ArrayList<CodegenTypedParam> ctorParms = new ArrayList<CodegenTypedParam>();
            ctorParms.add(new CodegenTypedParam(EPStatementInitServices.class, EPStatementInitServices.REF.getRef(), false));
            CodegenCtor providerCtor = new CodegenCtor(StmtClassForgeableRSPFactoryProvider.class, includeDebugSymbols, ctorParms);
            CodegenClassScope classScope = new CodegenClassScope(includeDebugSymbols, this.packageScope, this.className);
            ArrayList<CodegenTypedParam> providerExplicitMembers = new ArrayList<CodegenTypedParam>(2);
            providerExplicitMembers.add(new CodegenTypedParam(EventType.class, MEMBERNAME_RESULTEVENTTYPE));
            providerCtor.getBlock().assignMember(MEMBERNAME_RESULTEVENTTYPE, EventTypeUtility.resolveTypeCodegen(this.spec.getResultEventType(), EPStatementInitServices.REF));
            StmtClassForgeableRSPFactoryProvider.makeResultSetProcessorFactory(classScope, innerClasses, providerExplicitMembers, providerCtor, this.className);
            StmtClassForgeableRSPFactoryProvider.makeResultSetProcessor(classScope, innerClasses, providerExplicitMembers, providerCtor, this.className, this.spec);
            OrderByProcessorCompiler.makeOrderByProcessors(this.spec.getOrderByProcessorFactoryForge(), classScope, innerClasses, providerExplicitMembers, providerCtor, this.className, MEMBERNAME_ORDERBYFACTORY);
            providerExplicitMembers.add(new CodegenTypedParam(AggregationServiceFactory.class, MEMBERNAME_AGGREGATIONSVCFACTORY));
            AggregationClassNames aggregationClassNames = new AggregationClassNames();
            AggregationServiceFactoryMakeResult aggResult = AggregationServiceFactoryCompiler.makeInnerClassesAndInit(this.spec.isJoin(), this.spec.getAggregationServiceForgeDesc().getAggregationServiceFactoryForge(), providerCtor, classScope, this.className, aggregationClassNames);
            providerCtor.getBlock().assignMember(MEMBERNAME_AGGREGATIONSVCFACTORY, CodegenExpressionBuilder.localMethod(aggResult.getInitMethod(), EPStatementInitServices.REF));
            innerClasses.addAll(aggResult.getInnerClasses());
            StmtClassForgeableRSPFactoryProvider.makeSelectExprProcessors(classScope, innerClasses, providerExplicitMembers, providerCtor, this.className, this.spec.isRollup(), this.spec.getSelectExprProcessorForges());
            CodegenMethod getResultSetProcessorFactoryMethod = CodegenMethod.makeParentNode(ResultSetProcessorFactory.class, this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope);
            getResultSetProcessorFactoryMethod.getBlock().methodReturn(CodegenExpressionBuilder.ref(MEMBERNAME_RESULTSETPROCESSORFACTORY));
            CodegenMethod getAggregationServiceFactoryMethod = CodegenMethod.makeParentNode(AggregationServiceFactory.class, this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope);
            getAggregationServiceFactoryMethod.getBlock().methodReturn(CodegenExpressionBuilder.ref(MEMBERNAME_AGGREGATIONSVCFACTORY));
            CodegenMethod getOrderByProcessorFactoryMethod = CodegenMethod.makeParentNode(OrderByProcessorFactory.class, this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope);
            getOrderByProcessorFactoryMethod.getBlock().methodReturn(CodegenExpressionBuilder.ref(MEMBERNAME_ORDERBYFACTORY));
            CodegenMethod getResultSetProcessorTypeMethod = CodegenMethod.makeParentNode(ResultSetProcessorType.class, this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope);
            getResultSetProcessorTypeMethod.getBlock().methodReturn(CodegenExpressionBuilder.enumValue(ResultSetProcessorType.class, this.spec.getResultSetProcessorType().name()));
            CodegenMethod getResultEventTypeMethod = CodegenMethod.makeParentNode(EventType.class, this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope);
            getResultEventTypeMethod.getBlock().methodReturn(CodegenExpressionBuilder.ref(MEMBERNAME_RESULTEVENTTYPE));
            CodegenClassMethods methods = new CodegenClassMethods();
            CodegenStackGenerator.recursiveBuildStack(providerCtor, "ctor", methods);
            CodegenStackGenerator.recursiveBuildStack(getResultSetProcessorFactoryMethod, "getResultSetProcessorFactory", methods);
            CodegenStackGenerator.recursiveBuildStack(getAggregationServiceFactoryMethod, "getAggregationServiceFactory", methods);
            CodegenStackGenerator.recursiveBuildStack(getOrderByProcessorFactoryMethod, "getOrderByProcessorFactory", methods);
            CodegenStackGenerator.recursiveBuildStack(getResultSetProcessorTypeMethod, "getResultSetProcessorType", methods);
            CodegenStackGenerator.recursiveBuildStack(getResultEventTypeMethod, "getResultEventType", methods);
            return new CodegenClass(CodegenClassType.RESULTSETPROCESSORFACTORYPROVIDER, ResultSetProcessorFactoryProvider.class, this.className, classScope, providerExplicitMembers, providerCtor, methods, innerClasses);
        }
        catch (Throwable t) {
            throw new EPException("Fatal exception during code-generation for " + (String)debugInformationProvider.get() + " : " + t.getMessage(), t);
        }
    }

    private static void makeResultSetProcessorFactory(CodegenClassScope classScope, List<CodegenInnerClass> innerClasses, List<CodegenTypedParam> providerExplicitMembers, CodegenCtor providerCtor, String providerClassName) {
        CodegenMethod instantiateMethod = CodegenMethod.makeParentNode(ResultSetProcessor.class, StmtClassForgeableRSPFactoryProvider.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(OrderByProcessor.class, "orderByProcessor").addParam(AggregationService.class, "aggregationService").addParam(AgentInstanceContext.class, "agentInstanceContext");
        instantiateMethod.getBlock().methodReturn(CodegenExpressionBuilder.newInstance(CLASSNAME_RESULTSETPROCESSOR, CodegenExpressionBuilder.ref("o"), ResultSetProcessorCodegenNames.MEMBER_ORDERBYPROCESSOR, ResultSetProcessorCodegenNames.MEMBER_AGGREGATIONSVC, ResultSetProcessorCodegenNames.MEMBER_AGENTINSTANCECONTEXT));
        CodegenClassMethods methods = new CodegenClassMethods();
        CodegenStackGenerator.recursiveBuildStack(instantiateMethod, "instantiate", methods);
        List<CodegenTypedParam> ctorParams = Collections.singletonList(new CodegenTypedParam(providerClassName, "o"));
        CodegenCtor ctor = new CodegenCtor(StmtClassForgeableRSPFactoryProvider.class, classScope, ctorParams);
        CodegenInnerClass innerClass = new CodegenInnerClass(CLASSNAME_RESULTSETPROCESSORFACTORY, ResultSetProcessorFactory.class, ctor, Collections.emptyList(), methods);
        innerClasses.add(innerClass);
        providerExplicitMembers.add(new CodegenTypedParam(ResultSetProcessorFactory.class, MEMBERNAME_RESULTSETPROCESSORFACTORY));
        providerCtor.getBlock().assignMember(MEMBERNAME_RESULTSETPROCESSORFACTORY, CodegenExpressionBuilder.newInstance(CLASSNAME_RESULTSETPROCESSORFACTORY, CodegenExpressionBuilder.ref("this")));
    }

    private static void makeResultSetProcessor(CodegenClassScope classScope, List<CodegenInnerClass> innerClasses, List<CodegenTypedParam> factoryExplicitMembers, CodegenCtor factoryCtor, String classNameParent, ResultSetProcessorDesc spec) {
        ArrayList<CodegenTypedParam> ctorParams = new ArrayList<CodegenTypedParam>();
        ctorParams.add(new CodegenTypedParam(classNameParent, "o"));
        ctorParams.add(new CodegenTypedParam(OrderByProcessor.class, "orderByProcessor"));
        ctorParams.add(new CodegenTypedParam(AggregationService.class, "aggregationService"));
        ctorParams.add(new CodegenTypedParam(AgentInstanceContext.class, "agentInstanceContext"));
        CodegenCtor serviceCtor = new CodegenCtor(StmtClassForgeableRSPFactoryProvider.class, classScope, ctorParams);
        ResultSetProcessorFactoryForge forge = spec.getResultSetProcessorFactoryForge();
        CodegenMethod getResultEventTypeMethod = CodegenMethod.makeParentNode(EventType.class, forge.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope);
        getResultEventTypeMethod.getBlock().methodReturn(CodegenExpressionBuilder.member("o.resultEventType"));
        CodegenInstanceAux instance = new CodegenInstanceAux(serviceCtor);
        forge.instanceCodegen(instance, classScope, factoryCtor, factoryExplicitMembers);
        CodegenMethod processViewResultMethod = CodegenMethod.makeParentNode(UniformPair.class, forge.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(EventBean[].class, "newData").addParam(EventBean[].class, "oldData").addParam(Boolean.TYPE, "isSynthesize");
        if (!spec.isJoin()) {
            StmtClassForgeableRSPFactoryProvider.generateInstrumentedProcessView(forge, classScope, processViewResultMethod, instance);
        } else {
            processViewResultMethod.getBlock().methodThrowUnsupported();
        }
        CodegenMethod processJoinResultMethod = CodegenMethod.makeParentNode(UniformPair.class, forge.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(Set.class, "newData").addParam(Set.class, "oldData").addParam(Boolean.TYPE, "isSynthesize");
        if (!spec.isJoin()) {
            processJoinResultMethod.getBlock().methodThrowUnsupported();
        } else {
            StmtClassForgeableRSPFactoryProvider.generateInstrumentedProcessJoin(forge, classScope, processJoinResultMethod, instance);
        }
        CodegenMethod clearMethod = CodegenMethod.makeParentNode(Void.TYPE, forge.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope);
        forge.clearMethodCodegen(classScope, clearMethod);
        CodegenMethod getIteratorMethodView = CodegenMethod.makeParentNode(Iterator.class, forge.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(Viewable.class, "viewable");
        if (!spec.isJoin()) {
            forge.getIteratorViewCodegen(classScope, getIteratorMethodView, instance);
        } else {
            getIteratorMethodView.getBlock().methodThrowUnsupported();
        }
        CodegenMethod getIteratorMethodJoin = CodegenMethod.makeParentNode(Iterator.class, forge.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(Set.class, "joinset");
        if (!spec.isJoin()) {
            getIteratorMethodJoin.getBlock().methodThrowUnsupported();
        } else {
            forge.getIteratorJoinCodegen(classScope, getIteratorMethodJoin, instance);
        }
        CodegenMethod processOutputLimitedViewMethod = CodegenMethod.makeParentNode(UniformPair.class, forge.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(List.class, "viewEventsList").addParam(Boolean.TYPE, "isSynthesize");
        if (!spec.isJoin() && spec.isHasOutputLimit() && !spec.isHasOutputLimitSnapshot()) {
            forge.processOutputLimitedViewCodegen(classScope, processOutputLimitedViewMethod, instance);
        } else {
            processOutputLimitedViewMethod.getBlock().methodThrowUnsupported();
        }
        CodegenMethod processOutputLimitedJoinMethod = CodegenMethod.makeParentNode(UniformPair.class, forge.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(List.class, "joinEventsSet").addParam(Boolean.TYPE, "isSynthesize");
        if (!spec.isJoin() || !spec.isHasOutputLimit() || spec.isHasOutputLimitSnapshot()) {
            processOutputLimitedJoinMethod.getBlock().methodThrowUnsupported();
        } else {
            forge.processOutputLimitedJoinCodegen(classScope, processOutputLimitedJoinMethod, instance);
        }
        CodegenMethod setAgentInstanceContextMethod = CodegenMethod.makeParentNode(Void.TYPE, forge.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(AgentInstanceContext.class, "context");
        setAgentInstanceContextMethod.getBlock().assignRef("agentInstanceContext", (CodegenExpression)CodegenExpressionBuilder.ref("context"));
        CodegenMethod applyViewResultMethod = CodegenMethod.makeParentNode(Void.TYPE, forge.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(EventBean[].class, "newData").addParam(EventBean[].class, "oldData");
        if (!spec.isJoin() && spec.isHasOutputLimit() && spec.isHasOutputLimitSnapshot()) {
            forge.applyViewResultCodegen(classScope, applyViewResultMethod, instance);
        } else {
            applyViewResultMethod.getBlock().methodThrowUnsupported();
        }
        CodegenMethod applyJoinResultMethod = CodegenMethod.makeParentNode(Void.TYPE, forge.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(Set.class, "newData").addParam(Set.class, "oldData");
        if (!(spec.isJoin() && spec.isHasOutputLimit() && spec.isHasOutputLimitSnapshot())) {
            applyJoinResultMethod.getBlock().methodThrowUnsupported();
        } else {
            forge.applyJoinResultCodegen(classScope, applyJoinResultMethod, instance);
        }
        CodegenMethod processOutputLimitedLastAllNonBufferedViewMethod = CodegenMethod.makeParentNode(Void.TYPE, forge.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(EventBean[].class, "newData").addParam(EventBean[].class, "oldData").addParam(Boolean.TYPE, "isSynthesize");
        if (!spec.isJoin() && spec.isHasOutputLimit() && spec.getOutputConditionType() == ResultSetProcessorOutputConditionType.POLICY_LASTALL_UNORDERED) {
            forge.processOutputLimitedLastAllNonBufferedViewCodegen(classScope, processOutputLimitedLastAllNonBufferedViewMethod, instance);
        } else {
            processOutputLimitedLastAllNonBufferedViewMethod.getBlock().methodThrowUnsupported();
        }
        CodegenMethod processOutputLimitedLastAllNonBufferedJoinMethod = CodegenMethod.makeParentNode(Void.TYPE, forge.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(Set.class, "newData").addParam(Set.class, "oldData").addParam(Boolean.TYPE, "isSynthesize");
        if (!spec.isJoin() || !spec.isHasOutputLimit() || spec.getOutputConditionType() != ResultSetProcessorOutputConditionType.POLICY_LASTALL_UNORDERED) {
            processOutputLimitedLastAllNonBufferedJoinMethod.getBlock().methodThrowUnsupported();
        } else {
            forge.processOutputLimitedLastAllNonBufferedJoinCodegen(classScope, processOutputLimitedLastAllNonBufferedJoinMethod, instance);
        }
        CodegenMethod continueOutputLimitedLastAllNonBufferedViewMethod = CodegenMethod.makeParentNode(UniformPair.class, forge.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(Boolean.TYPE, "isSynthesize");
        if (!spec.isJoin() && spec.isHasOutputLimit() && spec.getOutputConditionType() == ResultSetProcessorOutputConditionType.POLICY_LASTALL_UNORDERED) {
            forge.continueOutputLimitedLastAllNonBufferedViewCodegen(classScope, continueOutputLimitedLastAllNonBufferedViewMethod, instance);
        } else {
            continueOutputLimitedLastAllNonBufferedViewMethod.getBlock().methodThrowUnsupported();
        }
        CodegenMethod continueOutputLimitedLastAllNonBufferedJoinMethod = CodegenMethod.makeParentNode(UniformPair.class, forge.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(Boolean.TYPE, "isSynthesize");
        if (!spec.isJoin() || !spec.isHasOutputLimit() || spec.getOutputConditionType() != ResultSetProcessorOutputConditionType.POLICY_LASTALL_UNORDERED) {
            continueOutputLimitedLastAllNonBufferedJoinMethod.getBlock().methodThrowUnsupported();
        } else {
            forge.continueOutputLimitedLastAllNonBufferedJoinCodegen(classScope, continueOutputLimitedLastAllNonBufferedJoinMethod, instance);
        }
        CodegenMethod acceptHelperVisitorMethod = CodegenMethod.makeParentNode(Void.TYPE, forge.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(ResultSetProcessorOutputHelperVisitor.class, "visitor");
        forge.acceptHelperVisitorCodegen(classScope, acceptHelperVisitorMethod, instance);
        CodegenMethod stopMethod = CodegenMethod.makeParentNode(Void.TYPE, forge.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope);
        forge.stopMethodCodegen(classScope, stopMethod, instance);
        CodegenClassMethods innerMethods = new CodegenClassMethods();
        CodegenStackGenerator.recursiveBuildStack(getResultEventTypeMethod, "getResultEventType", innerMethods);
        CodegenStackGenerator.recursiveBuildStack(processViewResultMethod, "processViewResult", innerMethods);
        CodegenStackGenerator.recursiveBuildStack(processJoinResultMethod, "processJoinResult", innerMethods);
        CodegenStackGenerator.recursiveBuildStack(getIteratorMethodView, "getIterator", innerMethods);
        CodegenStackGenerator.recursiveBuildStack(getIteratorMethodJoin, "getIterator", innerMethods);
        CodegenStackGenerator.recursiveBuildStack(clearMethod, "clear", innerMethods);
        CodegenStackGenerator.recursiveBuildStack(stopMethod, "stop", innerMethods);
        CodegenStackGenerator.recursiveBuildStack(processOutputLimitedJoinMethod, "processOutputLimitedJoin", innerMethods);
        CodegenStackGenerator.recursiveBuildStack(processOutputLimitedViewMethod, "processOutputLimitedView", innerMethods);
        CodegenStackGenerator.recursiveBuildStack(setAgentInstanceContextMethod, "setAgentInstanceContext", innerMethods);
        CodegenStackGenerator.recursiveBuildStack(applyViewResultMethod, "applyViewResult", innerMethods);
        CodegenStackGenerator.recursiveBuildStack(applyJoinResultMethod, "applyJoinResult", innerMethods);
        CodegenStackGenerator.recursiveBuildStack(processOutputLimitedLastAllNonBufferedViewMethod, "processOutputLimitedLastAllNonBufferedView", innerMethods);
        CodegenStackGenerator.recursiveBuildStack(processOutputLimitedLastAllNonBufferedJoinMethod, "processOutputLimitedLastAllNonBufferedJoin", innerMethods);
        CodegenStackGenerator.recursiveBuildStack(continueOutputLimitedLastAllNonBufferedViewMethod, "continueOutputLimitedLastAllNonBufferedView", innerMethods);
        CodegenStackGenerator.recursiveBuildStack(continueOutputLimitedLastAllNonBufferedJoinMethod, "continueOutputLimitedLastAllNonBufferedJoin", innerMethods);
        CodegenStackGenerator.recursiveBuildStack(acceptHelperVisitorMethod, "acceptHelperVisitor", innerMethods);
        for (Map.Entry<String, CodegenMethod> methodEntry : instance.getMethods().getMethods().entrySet()) {
            CodegenStackGenerator.recursiveBuildStack(methodEntry.getValue(), methodEntry.getKey(), innerMethods);
        }
        CodegenInnerClass innerClass = new CodegenInnerClass(CLASSNAME_RESULTSETPROCESSOR, forge.getInterfaceClass(), serviceCtor, instance.getMembers(), innerMethods);
        innerClasses.add(innerClass);
    }

    private static void generateInstrumentedProcessJoin(ResultSetProcessorFactoryForge forge, CodegenClassScope classScope, CodegenMethod method, CodegenInstanceAux instance) {
        if (!classScope.isInstrumented()) {
            forge.processJoinResultCodegen(classScope, method, instance);
            return;
        }
        CodegenMethod instrumented = method.makeChild(UniformPair.class, forge.getClass(), (CodegenScope)classScope).addParam(Set.class, "newData").addParam(Set.class, "oldData").addParam(Boolean.TYPE, "isSynthesize");
        forge.processJoinResultCodegen(classScope, instrumented, instance);
        method.getBlock().apply(InstrumentationCode.instblock(classScope, "q" + forge.getInstrumentedQName(), new CodegenExpression[0])).declareVar(UniformPair.class, "pair", (CodegenExpression)CodegenExpressionBuilder.localMethod(instrumented, ResultSetProcessorCodegenNames.REF_NEWDATA, ResultSetProcessorCodegenNames.REF_OLDDATA, ResultSetProcessorCodegenNames.REF_ISSYNTHESIZE)).apply(InstrumentationCode.instblock(classScope, "a" + forge.getInstrumentedQName(), CodegenExpressionBuilder.ref("pair"))).methodReturn(CodegenExpressionBuilder.ref("pair"));
    }

    private static void generateInstrumentedProcessView(ResultSetProcessorFactoryForge forge, CodegenClassScope classScope, CodegenMethod method, CodegenInstanceAux instance) {
        if (!classScope.isInstrumented()) {
            forge.processViewResultCodegen(classScope, method, instance);
            return;
        }
        CodegenMethod instrumented = method.makeChild(UniformPair.class, forge.getClass(), (CodegenScope)classScope).addParam(EventBean[].class, "newData").addParam(EventBean[].class, "oldData").addParam(Boolean.TYPE, "isSynthesize");
        forge.processViewResultCodegen(classScope, instrumented, instance);
        method.getBlock().apply(InstrumentationCode.instblock(classScope, "q" + forge.getInstrumentedQName(), new CodegenExpression[0])).declareVar(UniformPair.class, "pair", (CodegenExpression)CodegenExpressionBuilder.localMethod(instrumented, ResultSetProcessorCodegenNames.REF_NEWDATA, ResultSetProcessorCodegenNames.REF_OLDDATA, ResultSetProcessorCodegenNames.REF_ISSYNTHESIZE)).apply(InstrumentationCode.instblock(classScope, "a" + forge.getInstrumentedQName(), CodegenExpressionBuilder.ref("pair"))).methodReturn(CodegenExpressionBuilder.ref("pair"));
    }

    private static void makeSelectExprProcessors(CodegenClassScope classScope, List<CodegenInnerClass> innerClasses, List<CodegenTypedParam> explicitMembers, CodegenCtor outerClassCtor, String classNameParent, boolean rollup, SelectExprProcessorForge[] forges) {
        int i;
        if (!rollup) {
            String name = "SelectExprProcessorImpl";
            explicitMembers.add(new CodegenTypedParam(SelectExprProcessor.class, "selectExprProcessor"));
            outerClassCtor.getBlock().assignRef("selectExprProcessor", CodegenExpressionBuilder.newInstance(name, CodegenExpressionBuilder.ref("this"), EPStatementInitServices.REF));
            CodegenInnerClass innerClass = StmtClassForgeableRSPFactoryProvider.makeSelectExprProcessor(name, classNameParent, classScope, forges[0]);
            innerClasses.add(innerClass);
            return;
        }
        for (i = 0; i < forges.length; ++i) {
            String name = "SelectExprProcessorImpl" + i;
            SelectExprProcessorForge forge = forges[i];
            CodegenInnerClass innerClass = StmtClassForgeableRSPFactoryProvider.makeSelectExprProcessor(name, classNameParent, classScope, forge);
            innerClasses.add(innerClass);
        }
        explicitMembers.add(new CodegenTypedParam(SelectExprProcessor[].class, "selectExprProcessorArray"));
        outerClassCtor.getBlock().assignRef("selectExprProcessorArray", CodegenExpressionBuilder.newArrayByLength(SelectExprProcessor.class, CodegenExpressionBuilder.constant(forges.length)));
        for (i = 0; i < forges.length; ++i) {
            outerClassCtor.getBlock().assignArrayElement("selectExprProcessorArray", CodegenExpressionBuilder.constant(i), CodegenExpressionBuilder.newInstance("SelectExprProcessorImpl" + i, CodegenExpressionBuilder.ref("this"), EPStatementInitServices.REF));
        }
    }

    private static CodegenInnerClass makeSelectExprProcessor(String className, String classNameParent, CodegenClassScope classScope, SelectExprProcessorForge forge) {
        final ExprForgeCodegenSymbol exprSymbol = new ExprForgeCodegenSymbol(true, null);
        final SelectExprProcessorCodegenSymbol selectEnv = new SelectExprProcessorCodegenSymbol();
        CodegenSymbolProvider symbolProvider = new CodegenSymbolProvider(){

            @Override
            public void provide(Map<String, Class> symbols) {
                exprSymbol.provide(symbols);
                selectEnv.provide(symbols);
            }
        };
        ArrayList<CodegenTypedParam> members = new ArrayList<CodegenTypedParam>(2);
        members.add(new CodegenTypedParam(EventBeanTypedEventFactory.class, MEMBER_EVENTBEANFACTORY.getRef()));
        ArrayList<CodegenTypedParam> ctorParams = new ArrayList<CodegenTypedParam>(2);
        ctorParams.add(new CodegenTypedParam(classNameParent, "o"));
        ctorParams.add(new CodegenTypedParam(EPStatementInitServices.class, EPStatementInitServices.REF.getRef(), false));
        CodegenCtor ctor = new CodegenCtor(StmtClassForgeableRSPFactoryProvider.class, classScope, ctorParams);
        ctor.getBlock().assignRef(MEMBER_EVENTBEANFACTORY, CodegenExpressionBuilder.exprDotMethod(EPStatementInitServices.REF, "getEventBeanTypedEventFactory", new CodegenExpression[0]));
        CodegenMethod processMethod = CodegenMethod.makeParentNode(EventBean.class, StmtClassForgeableRSPFactoryProvider.class, symbolProvider, (CodegenScope)classScope).addParam(EventBean[].class, "eventsPerStream").addParam(Boolean.TYPE, "isNewData").addParam(Boolean.TYPE, "isSynthesize").addParam(ExprEvaluatorContext.class, "exprEvalCtx");
        processMethod.getBlock().apply(InstrumentationCode.instblock(classScope, "qSelectClause", ExprForgeCodegenNames.REF_EPS, ResultSetProcessorCodegenNames.REF_ISNEWDATA, ResultSetProcessorCodegenNames.REF_ISSYNTHESIZE, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
        CodegenMethod performMethod = forge.processCodegen(CodegenExpressionBuilder.member("o.resultEventType"), MEMBER_EVENTBEANFACTORY, processMethod, selectEnv, exprSymbol, classScope);
        exprSymbol.derivedSymbolsCodegen(processMethod, processMethod.getBlock(), classScope);
        processMethod.getBlock().declareVar(EventBean.class, "out", (CodegenExpression)CodegenExpressionBuilder.localMethod(performMethod, new CodegenExpression[0])).apply(InstrumentationCode.instblock(classScope, "aSelectClause", ResultSetProcessorCodegenNames.REF_ISNEWDATA, CodegenExpressionBuilder.ref("out"), CodegenExpressionBuilder.constantNull())).methodReturn(CodegenExpressionBuilder.ref("out"));
        CodegenClassMethods allMethods = new CodegenClassMethods();
        CodegenStackGenerator.recursiveBuildStack(processMethod, "process", allMethods);
        return new CodegenInnerClass(className, SelectExprProcessor.class, ctor, members, allMethods);
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public StmtClassForgeableType getForgeableType() {
        return StmtClassForgeableType.RSPPROVIDER;
    }
}

