/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage3;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenField;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenPackageScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSubstitutionParamEntry;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProvider;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProviderEmpty;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassMethods;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassType;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenCtor;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenTypedParam;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionNewAnonymousClass;
import com.espertech.esper.common.internal.bytecodemodel.name.CodegenFieldName;
import com.espertech.esper.common.internal.bytecodemodel.name.CodegenFieldNameAgg;
import com.espertech.esper.common.internal.bytecodemodel.name.CodegenFieldNameMatchRecognizeAgg;
import com.espertech.esper.common.internal.bytecodemodel.name.CodegenFieldNameMatchRecognizePrevious;
import com.espertech.esper.common.internal.bytecodemodel.name.CodegenFieldNamePrevious;
import com.espertech.esper.common.internal.bytecodemodel.name.CodegenFieldNamePrior;
import com.espertech.esper.common.internal.bytecodemodel.name.CodegenFieldNameSubqueryAgg;
import com.espertech.esper.common.internal.bytecodemodel.name.CodegenFieldNameSubqueryPrevious;
import com.espertech.esper.common.internal.bytecodemodel.name.CodegenFieldNameSubqueryPrior;
import com.espertech.esper.common.internal.bytecodemodel.name.CodegenFieldNameSubqueryResult;
import com.espertech.esper.common.internal.bytecodemodel.name.CodegenFieldNameTableAccess;
import com.espertech.esper.common.internal.bytecodemodel.name.CodegenFieldNameViewAgg;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenStackGenerator;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeable;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableType;
import com.espertech.esper.common.internal.context.module.StatementAIFactoryAssignments;
import com.espertech.esper.common.internal.context.module.StatementFields;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodAssignerSetter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class StmtClassForgeableStmtFields
implements StmtClassForgeable {
    private final String className;
    private final CodegenPackageScope packageScope;
    private final int numStreams;

    public StmtClassForgeableStmtFields(String className, CodegenPackageScope packageScope, int numStreams) {
        this.className = className;
        this.packageScope = packageScope;
        this.numStreams = numStreams;
    }

    @Override
    public CodegenClass forge(boolean includeDebugSymbols, boolean fireAndForget) {
        ArrayList<CodegenTypedParam> members = new ArrayList<CodegenTypedParam>();
        this.generateNamedMembers(members);
        for (Map.Entry<CodegenField, CodegenExpression> entry : this.packageScope.getFieldsUnshared().entrySet()) {
            CodegenField field = entry.getKey();
            members.add(new CodegenTypedParam(field.getType(), field.getName()).setStatic(true).setFinal(false));
        }
        this.generateSubstitutionParamMembers(members);
        CodegenCtor ctor = new CodegenCtor(this.getClass(), includeDebugSymbols, Collections.emptyList());
        CodegenClassScope classScope = new CodegenClassScope(includeDebugSymbols, this.packageScope, this.className);
        CodegenMethod initMethod = this.packageScope.getInitMethod();
        for (Map.Entry<CodegenField, CodegenExpression> entry : this.packageScope.getFieldsUnshared().entrySet()) {
            initMethod.getBlock().assignRef(entry.getKey().getName(), entry.getValue());
        }
        CodegenMethod assignMethod = CodegenMethod.makeParentNode(Void.TYPE, this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(StatementAIFactoryAssignments.class, "assignments").setStatic(true);
        CodegenMethod unassignMethod = CodegenMethod.makeParentNode(Void.TYPE, this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).setStatic(true);
        StmtClassForgeableStmtFields.generateAssignAndUnassign(this.numStreams, assignMethod, unassignMethod, this.packageScope.getFieldsNamed());
        CodegenClassMethods methods = new CodegenClassMethods();
        CodegenStackGenerator.recursiveBuildStack(initMethod, "init", methods);
        CodegenStackGenerator.recursiveBuildStack(assignMethod, "assign", methods);
        CodegenStackGenerator.recursiveBuildStack(unassignMethod, "unassign", methods);
        return new CodegenClass(CodegenClassType.STATEMENTFIELDS, StatementFields.class, this.className, classScope, members, ctor, methods, Collections.emptyList());
    }

    private void generateSubstitutionParamMembers(List<CodegenTypedParam> members) {
        List<CodegenSubstitutionParamEntry> numbered = this.packageScope.getSubstitutionParamsByNumber();
        LinkedHashMap<String, CodegenSubstitutionParamEntry> named = this.packageScope.getSubstitutionParamsByName();
        if (numbered.isEmpty() && named.isEmpty()) {
            return;
        }
        if (!numbered.isEmpty() && !named.isEmpty()) {
            throw new IllegalStateException("Both named and numbered substitution parameters are non-empty");
        }
        List<CodegenSubstitutionParamEntry> fields = !numbered.isEmpty() ? numbered : new ArrayList<CodegenSubstitutionParamEntry>(named.values());
        for (int i = 0; i < fields.size(); ++i) {
            String name = fields.get(i).getField().getName();
            members.add(new CodegenTypedParam(fields.get(i).getType(), name).setStatic(true).setFinal(false));
        }
    }

    private void generateNamedMembers(List<CodegenTypedParam> fields) {
        for (Map.Entry<CodegenFieldName, CodegenField> entry : this.packageScope.getFieldsNamed().entrySet()) {
            fields.add(new CodegenTypedParam(entry.getValue().getType(), entry.getKey().getName()).setFinal(false).setStatic(true));
        }
    }

    private static void generateAssignAndUnassign(int numStreams, CodegenMethod assign, CodegenMethod unassign, LinkedHashMap<CodegenFieldName, CodegenField> names) {
        for (Map.Entry<CodegenFieldName, CodegenField> entry : names.entrySet()) {
            CodegenFieldName subq;
            CodegenFieldName name = entry.getKey();
            if (name instanceof CodegenFieldNameAgg) {
                StmtClassForgeableStmtFields.generate(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("assignments"), "getAggregationResultFuture", new CodegenExpression[0]), name, assign, unassign, true);
                continue;
            }
            if (name instanceof CodegenFieldNamePrevious) {
                CodegenFieldNamePrevious previous = (CodegenFieldNamePrevious)name;
                StmtClassForgeableStmtFields.generate(CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("assignments"), "getPreviousStrategies", new CodegenExpression[0]), CodegenExpressionBuilder.constant(previous.getStreamNumber())), name, assign, unassign, true);
                continue;
            }
            if (name instanceof CodegenFieldNamePrior) {
                CodegenFieldNamePrior prior = (CodegenFieldNamePrior)name;
                StmtClassForgeableStmtFields.generate(CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("assignments"), "getPriorStrategies", new CodegenExpression[0]), CodegenExpressionBuilder.constant(prior.getStreamNumber())), name, assign, unassign, true);
                continue;
            }
            if (name instanceof CodegenFieldNameViewAgg) {
                StmtClassForgeableStmtFields.generate(CodegenExpressionBuilder.constantNull(), name, assign, unassign, true);
                continue;
            }
            if (name instanceof CodegenFieldNameSubqueryResult) {
                subq = (CodegenFieldNameSubqueryResult)name;
                CodegenExpression subqueryLookupStrategy = CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("assignments"), "getSubqueryLookup", CodegenExpressionBuilder.constant(((CodegenFieldNameSubqueryResult)subq).getSubqueryNumber()));
                StmtClassForgeableStmtFields.generate(subqueryLookupStrategy, name, assign, unassign, true);
                continue;
            }
            if (name instanceof CodegenFieldNameSubqueryPrior) {
                subq = (CodegenFieldNameSubqueryPrior)name;
                CodegenExpression prior = CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("assignments"), "getSubqueryPrior", CodegenExpressionBuilder.constant(((CodegenFieldNameSubqueryPrior)subq).getSubqueryNumber()));
                StmtClassForgeableStmtFields.generate(prior, name, assign, unassign, true);
                continue;
            }
            if (name instanceof CodegenFieldNameSubqueryPrevious) {
                subq = (CodegenFieldNameSubqueryPrevious)name;
                CodegenExpression prev = CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("assignments"), "getSubqueryPrevious", CodegenExpressionBuilder.constant(((CodegenFieldNameSubqueryPrevious)subq).getSubqueryNumber()));
                StmtClassForgeableStmtFields.generate(prev, name, assign, unassign, true);
                continue;
            }
            if (name instanceof CodegenFieldNameSubqueryAgg) {
                subq = (CodegenFieldNameSubqueryAgg)name;
                CodegenExpression agg = CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("assignments"), "getSubqueryAggregation", CodegenExpressionBuilder.constant(((CodegenFieldNameSubqueryAgg)subq).getSubqueryNumber()));
                StmtClassForgeableStmtFields.generate(agg, name, assign, unassign, true);
                continue;
            }
            if (name instanceof CodegenFieldNameTableAccess) {
                CodegenFieldNameTableAccess tableAccess = (CodegenFieldNameTableAccess)name;
                CodegenExpression tableAccessLookupStrategy = CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("assignments"), "getTableAccess", CodegenExpressionBuilder.constant(tableAccess.getTableAccessNumber()));
                StmtClassForgeableStmtFields.generate(tableAccessLookupStrategy, name, assign, unassign, false);
                continue;
            }
            if (name instanceof CodegenFieldNameMatchRecognizePrevious) {
                StmtClassForgeableStmtFields.generate(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("assignments"), "getRowRecogPreviousStrategy", new CodegenExpression[0]), name, assign, unassign, true);
                continue;
            }
            if (name instanceof CodegenFieldNameMatchRecognizeAgg) {
                StmtClassForgeableStmtFields.generate(CodegenExpressionBuilder.constantNull(), name, assign, unassign, true);
                continue;
            }
            throw new IllegalStateException("Unrecognized field " + entry.getKey());
        }
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public StmtClassForgeableType getForgeableType() {
        return StmtClassForgeableType.FIELDS;
    }

    public static void makeSubstitutionSetter(CodegenPackageScope packageScope, CodegenMethod method, CodegenClassScope classScope) {
        CodegenExpressionNewAnonymousClass assignerSetterClass = CodegenExpressionBuilder.newAnonymousClass(method.getBlock(), FAFQueryMethodAssignerSetter.class);
        method.getBlock().methodReturn(assignerSetterClass);
        CodegenMethod assignMethod = CodegenMethod.makeParentNode(Void.TYPE, StmtClassForgeableStmtFields.class, classScope).addParam(StatementAIFactoryAssignments.class, "assignments");
        assignerSetterClass.addMethod("assign", assignMethod);
        assignMethod.getBlock().staticMethod(packageScope.getFieldsClassNameOptional(), "assign", CodegenExpressionBuilder.ref("assignments"));
        CodegenMethod setValueMethod = CodegenMethod.makeParentNode(Void.TYPE, StmtClassForgeableStmtFields.class, classScope).addParam(Integer.TYPE, "index").addParam(Object.class, "value");
        assignerSetterClass.addMethod("setValue", setValueMethod);
        CodegenSubstitutionParamEntry.codegenSetterMethod(classScope, setValueMethod);
    }

    private static void generate(CodegenExpression init, CodegenFieldName name, CodegenMethod assign, CodegenMethod unassign, boolean generateUnassign) {
        assign.getBlock().assignRef(name.getName(), init);
        if (generateUnassign) {
            unassign.getBlock().assignRef(name.getName(), CodegenExpressionBuilder.constantNull());
        }
    }
}

