/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.aifactory.createdataflow;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.compile.stage3.StmtForgeMethodResult;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.context.aifactory.createdataflow.DataflowDesc;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOperatorForge;
import com.espertech.esper.common.internal.epl.dataflow.realize.LogicalChannel;
import com.espertech.esper.common.internal.epl.dataflow.util.OperatorMetadataDescriptor;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataflowDescForge {
    private final String dataflowName;
    private final Map<String, EventType> declaredTypes;
    private final Map<Integer, OperatorMetadataDescriptor> operatorMetadata;
    private final Set<Integer> operatorBuildOrder;
    private final Map<Integer, DataFlowOperatorForge> operatorFactories;
    private final List<LogicalChannel> logicalChannels;
    private final List<StmtForgeMethodResult> forgables;
    private final List<StmtClassForgeableFactory> additionalForgables;

    public DataflowDescForge(String dataflowName, Map<String, EventType> declaredTypes, Map<Integer, OperatorMetadataDescriptor> operatorMetadata, Set<Integer> operatorBuildOrder, Map<Integer, DataFlowOperatorForge> operatorFactories, List<LogicalChannel> logicalChannels, List<StmtForgeMethodResult> forgables, List<StmtClassForgeableFactory> additionalForgables) {
        this.dataflowName = dataflowName;
        this.declaredTypes = declaredTypes;
        this.operatorMetadata = operatorMetadata;
        this.operatorBuildOrder = operatorBuildOrder;
        this.operatorFactories = operatorFactories;
        this.logicalChannels = logicalChannels;
        this.forgables = forgables;
        this.additionalForgables = additionalForgables;
    }

    public CodegenExpression make(CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(DataflowDesc.class, this.getClass(), (CodegenScope)classScope);
        method.getBlock().declareVar(DataflowDesc.class, "df", CodegenExpressionBuilder.newInstance(DataflowDesc.class, new CodegenExpression[0])).exprDotMethod(CodegenExpressionBuilder.ref("df"), "setDataflowName", CodegenExpressionBuilder.constant(this.dataflowName)).exprDotMethod(CodegenExpressionBuilder.ref("df"), "setDeclaredTypes", DataflowDescForge.makeTypes(this.declaredTypes, method, symbols, classScope)).exprDotMethod(CodegenExpressionBuilder.ref("df"), "setOperatorMetadata", DataflowDescForge.makeOpMeta(this.operatorMetadata, method, symbols, classScope)).exprDotMethod(CodegenExpressionBuilder.ref("df"), "setOperatorBuildOrder", DataflowDescForge.makeOpBuildOrder(this.operatorBuildOrder, method, symbols, classScope)).exprDotMethod(CodegenExpressionBuilder.ref("df"), "setOperatorFactories", DataflowDescForge.makeOpFactories(this.operatorFactories, method, symbols, classScope)).exprDotMethod(CodegenExpressionBuilder.ref("df"), "setLogicalChannels", DataflowDescForge.makeOpChannels(this.logicalChannels, method, symbols, classScope)).methodReturn(CodegenExpressionBuilder.ref("df"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    public Map<Integer, DataFlowOperatorForge> getOperatorFactories() {
        return this.operatorFactories;
    }

    public List<StmtForgeMethodResult> getForgables() {
        return this.forgables;
    }

    public List<StmtClassForgeableFactory> getAdditionalForgables() {
        return this.additionalForgables;
    }

    private static CodegenExpression makeOpChannels(List<LogicalChannel> logicalChannels, CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(List.class, DataflowDescForge.class, (CodegenScope)classScope);
        method.getBlock().declareVar(List.class, "chnl", CodegenExpressionBuilder.newInstance(ArrayList.class, CodegenExpressionBuilder.constant(logicalChannels.size())));
        for (LogicalChannel channel : logicalChannels) {
            method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("chnl"), "add", channel.make(method, symbols, classScope));
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.ref("chnl"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    private static CodegenExpression makeOpBuildOrder(Set<Integer> operatorBuildOrder, CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(LinkedHashSet.class, DataflowDescForge.class, (CodegenScope)classScope);
        method.getBlock().declareVar(LinkedHashSet.class, "order", CodegenExpressionBuilder.newInstance(LinkedHashSet.class, CodegenExpressionBuilder.constant(CollectionUtil.capacityHashMap(operatorBuildOrder.size()))));
        for (Integer entry : operatorBuildOrder) {
            method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("order"), "add", CodegenExpressionBuilder.constant(entry));
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.ref("order"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    private static CodegenExpression makeOpFactories(Map<Integer, DataFlowOperatorForge> operatorFactories, CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(Map.class, DataflowDescForge.class, (CodegenScope)classScope);
        method.getBlock().declareVar(Map.class, "fac", CodegenExpressionBuilder.newInstance(HashMap.class, CodegenExpressionBuilder.constant(CollectionUtil.capacityHashMap(operatorFactories.size()))));
        for (Map.Entry<Integer, DataFlowOperatorForge> entry : operatorFactories.entrySet()) {
            method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("fac"), "put", CodegenExpressionBuilder.constant(entry.getKey()), entry.getValue().make(method, symbols, classScope));
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.ref("fac"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    private static CodegenExpression makeOpMeta(Map<Integer, OperatorMetadataDescriptor> operatorMetadata, CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(Map.class, DataflowDescForge.class, (CodegenScope)classScope);
        method.getBlock().declareVar(Map.class, "op", CodegenExpressionBuilder.newInstance(HashMap.class, CodegenExpressionBuilder.constant(CollectionUtil.capacityHashMap(operatorMetadata.size()))));
        for (Map.Entry<Integer, OperatorMetadataDescriptor> entry : operatorMetadata.entrySet()) {
            method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("op"), "put", CodegenExpressionBuilder.constant(entry.getKey()), entry.getValue().make(method, symbols, classScope));
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.ref("op"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    private static CodegenExpression makeTypes(Map<String, EventType> declaredTypes, CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(Map.class, DataflowDescForge.class, (CodegenScope)classScope);
        method.getBlock().declareVar(Map.class, "types", CodegenExpressionBuilder.newInstance(HashMap.class, CodegenExpressionBuilder.constant(CollectionUtil.capacityHashMap(declaredTypes.size()))));
        for (Map.Entry<String, EventType> entry : declaredTypes.entrySet()) {
            method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("types"), "put", CodegenExpressionBuilder.constant(entry.getKey()), EventTypeUtility.resolveTypeCodegen(entry.getValue(), symbols.getAddInitSvc(method)));
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.ref("types"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }
}

