/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.aifactory.createdataflow;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.context.aifactory.core.ModuleIncidentals;
import com.espertech.esper.common.internal.context.aifactory.core.StatementAgentInstanceFactory;
import com.espertech.esper.common.internal.context.aifactory.core.StatementAgentInstanceFactoryResult;
import com.espertech.esper.common.internal.context.aifactory.createdataflow.DataflowDesc;
import com.espertech.esper.common.internal.context.aifactory.createdataflow.StatementAgentInstanceFactoryCreateDataflowResult;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryRequirements;
import com.espertech.esper.common.internal.context.module.StatementReadyCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceMgmtCallbackNoAction;
import com.espertech.esper.common.internal.context.util.AgentInstanceUtil;
import com.espertech.esper.common.internal.context.util.StatementAgentInstanceLock;
import com.espertech.esper.common.internal.context.util.StatementContext;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOpFactoryInitializeContext;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOperatorFactory;
import com.espertech.esper.common.internal.view.core.Viewable;
import com.espertech.esper.common.internal.view.core.ViewableDefaultImpl;
import java.util.Map;

public class StatementAgentInstanceFactoryCreateDataflow
implements StatementAgentInstanceFactory,
StatementReadyCallback {
    private Viewable viewable;
    private DataflowDesc dataflow;

    public void setEventType(EventType eventType) {
        this.viewable = new ViewableDefaultImpl(eventType);
    }

    public void setDataflow(DataflowDesc dataflow) {
        this.dataflow = dataflow;
    }

    @Override
    public void ready(StatementContext statementContext, ModuleIncidentals moduleIncidentals, boolean recovery) {
        for (Map.Entry<Integer, DataFlowOperatorFactory> entry : this.dataflow.getOperatorFactories().entrySet()) {
            entry.getValue().initializeFactory(new DataFlowOpFactoryInitializeContext(this.dataflow.getDataflowName(), entry.getKey(), statementContext));
        }
        this.dataflow.setStatementContext(statementContext);
        statementContext.getStatementContextRuntimeServices().getDataflowService().addDataflow(statementContext.getDeploymentId(), this.dataflow);
    }

    @Override
    public void statementCreate(StatementContext statementContext) {
    }

    @Override
    public void statementDestroy(StatementContext statementContext) {
        statementContext.getStatementContextRuntimeServices().getDataflowService().removeDataflow(statementContext.getDeploymentId(), this.dataflow);
    }

    @Override
    public StatementAgentInstanceFactoryResult newContext(AgentInstanceContext agentInstanceContext, boolean isRecoveringResilient) {
        return new StatementAgentInstanceFactoryCreateDataflowResult(this.viewable, AgentInstanceMgmtCallbackNoAction.INSTANCE, agentInstanceContext, this.dataflow);
    }

    @Override
    public AIRegistryRequirements getRegistryRequirements() {
        return AIRegistryRequirements.noRequirements();
    }

    @Override
    public EventType getStatementEventType() {
        return this.viewable.getEventType();
    }

    @Override
    public StatementAgentInstanceLock obtainAgentInstanceLock(StatementContext statementContext, int agentInstanceId) {
        return AgentInstanceUtil.newLock(statementContext);
    }
}

