/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.aifactory.createexpression;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenPackageScope;
import com.espertech.esper.common.internal.compile.stage1.spec.CreateExpressionDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.ExpressionDeclItem;
import com.espertech.esper.common.internal.compile.stage1.spec.ExpressionScriptProvided;
import com.espertech.esper.common.internal.compile.stage3.StatementBaseInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeable;
import com.espertech.esper.common.internal.context.aifactory.core.StmtForgeMethodCreateSimpleBase;
import com.espertech.esper.common.internal.context.aifactory.createexpression.StatementAgentInstanceFactoryCreateExpressionForge;
import com.espertech.esper.common.internal.context.aifactory.createexpression.StmtClassForgeableAIFactoryProviderCreateExpression;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;

public class StmtForgeMethodCreateExpression
extends StmtForgeMethodCreateSimpleBase {
    public StmtForgeMethodCreateExpression(StatementBaseInfo base) {
        super(base);
    }

    @Override
    protected String register(StatementCompileTimeServices services) throws ExprValidationException {
        String expressionName;
        CreateExpressionDesc spec = this.base.getStatementSpec().getRaw().getCreateExpressionDesc();
        if (spec.getExpression() != null) {
            expressionName = spec.getExpression().getName();
            NameAccessModifier visibility = services.getModuleVisibilityRules().getAccessModifierExpression(this.base, expressionName);
            this.checkAlreadyDeclared(expressionName, services, -1);
            ExpressionDeclItem item = spec.getExpression();
            item.setModuleName(this.base.getModuleName());
            item.setVisibility(visibility);
            services.getExprDeclaredCompileTimeRegistry().newExprDeclared(item);
        } else {
            expressionName = spec.getScript().getName();
            int numParameters = spec.getScript().getParameterNames().length;
            this.checkAlreadyDeclared(expressionName, services, numParameters);
            NameAccessModifier visibility = services.getModuleVisibilityRules().getAccessModifierScript(this.base, expressionName, numParameters);
            ExpressionScriptProvided item = spec.getScript();
            item.setModuleName(this.base.getModuleName());
            item.setVisibility(visibility);
            services.getScriptCompileTimeRegistry().newScript(item);
        }
        return expressionName;
    }

    @Override
    protected StmtClassForgeable aiFactoryForgable(String className, CodegenPackageScope packageScope, EventType statementEventType, String objectName) {
        StatementAgentInstanceFactoryCreateExpressionForge forge = new StatementAgentInstanceFactoryCreateExpressionForge(statementEventType, objectName);
        return new StmtClassForgeableAIFactoryProviderCreateExpression(className, packageScope, forge);
    }

    private void checkAlreadyDeclared(String expressionName, StatementCompileTimeServices services, int numParameters) throws ExprValidationException {
        if (services.getExprDeclaredCompileTimeResolver().resolve(expressionName) != null) {
            throw new ExprValidationException("Expression '" + expressionName + "' has already been declared");
        }
        if (services.getScriptCompileTimeResolver().resolve(expressionName, numParameters) != null) {
            throw new ExprValidationException("Script '" + expressionName + "' that takes the same number of parameters has already been declared");
        }
    }
}

