/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.aifactory.ontrigger.core;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.context.activator.ViewableActivationResult;
import com.espertech.esper.common.internal.context.activator.ViewableActivator;
import com.espertech.esper.common.internal.context.aifactory.core.StatementAgentInstanceFactory;
import com.espertech.esper.common.internal.context.aifactory.ontrigger.core.StatementAgentInstanceFactoryOnTriggerResult;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryRequirementSubquery;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryRequirements;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceMgmtCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceUtil;
import com.espertech.esper.common.internal.context.util.StatementContext;
import com.espertech.esper.common.internal.epl.agg.core.AggregationService;
import com.espertech.esper.common.internal.epl.ontrigger.InfraOnExprBaseViewResult;
import com.espertech.esper.common.internal.epl.pattern.core.EvalRootState;
import com.espertech.esper.common.internal.epl.subselect.SubSelectFactory;
import com.espertech.esper.common.internal.epl.subselect.SubSelectFactoryResult;
import com.espertech.esper.common.internal.epl.subselect.SubSelectHelperStart;
import com.espertech.esper.common.internal.epl.table.strategy.ExprTableEvalHelperStart;
import com.espertech.esper.common.internal.epl.table.strategy.ExprTableEvalStrategy;
import com.espertech.esper.common.internal.epl.table.strategy.ExprTableEvalStrategyFactory;
import com.espertech.esper.common.internal.view.core.View;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class StatementAgentInstanceFactoryOnTriggerBase
implements StatementAgentInstanceFactory {
    private EventType resultEventType;
    private ViewableActivator activator;
    private Map<Integer, SubSelectFactory> subselects;
    private Map<Integer, ExprTableEvalStrategyFactory> tableAccesses;

    public abstract InfraOnExprBaseViewResult determineOnExprView(AgentInstanceContext var1, List<AgentInstanceMgmtCallback> var2, boolean var3);

    public abstract View determineFinalOutputView(AgentInstanceContext var1, View var2);

    public void setActivator(ViewableActivator activator) {
        this.activator = activator;
    }

    public void setResultEventType(EventType resultEventType) {
        this.resultEventType = resultEventType;
    }

    public void setSubselects(Map<Integer, SubSelectFactory> subselects) {
        this.subselects = subselects;
    }

    public void setTableAccesses(Map<Integer, ExprTableEvalStrategyFactory> tableAccesses) {
        this.tableAccesses = tableAccesses;
    }

    @Override
    public EventType getStatementEventType() {
        return this.resultEventType;
    }

    @Override
    public void statementCreate(StatementContext statementContext) {
    }

    @Override
    public void statementDestroy(StatementContext statementContext) {
    }

    @Override
    public StatementAgentInstanceFactoryOnTriggerResult newContext(AgentInstanceContext agentInstanceContext, boolean isRecoveringResilient) {
        Map<Integer, ExprTableEvalStrategy> tableAccessEvals;
        Map<Integer, SubSelectFactoryResult> subselectActivations;
        EvalRootState optPatternRoot;
        ViewableActivationResult activationResult;
        AggregationService aggregationService;
        View view;
        ArrayList<AgentInstanceMgmtCallback> stopCallbacks = new ArrayList<AgentInstanceMgmtCallback>();
        try {
            InfraOnExprBaseViewResult onExprViewResult = this.determineOnExprView(agentInstanceContext, stopCallbacks, isRecoveringResilient);
            view = onExprViewResult.getView();
            aggregationService = onExprViewResult.getOptionalAggregationService();
            activationResult = this.activator.activate(agentInstanceContext, false, isRecoveringResilient);
            activationResult.getViewable().setChild(view);
            stopCallbacks.add(activationResult.getStopCallback());
            optPatternRoot = activationResult.getOptionalPatternRoot();
            view = this.determineFinalOutputView(agentInstanceContext, view);
            subselectActivations = SubSelectHelperStart.startSubselects(this.subselects, agentInstanceContext, stopCallbacks, isRecoveringResilient);
            tableAccessEvals = ExprTableEvalHelperStart.startTableAccess(this.tableAccesses, agentInstanceContext);
        }
        catch (RuntimeException ex) {
            AgentInstanceMgmtCallback stopCallback = AgentInstanceUtil.finalizeSafeStopCallbacks(stopCallbacks);
            AgentInstanceUtil.stopSafe(stopCallback, agentInstanceContext);
            throw new EPException(ex.getMessage(), ex);
        }
        Runnable postContextMergeRunnable = () -> {
            if (activationResult.getOptPostContextMergeRunnable() != null) {
                activationResult.getOptPostContextMergeRunnable().run();
            }
        };
        AgentInstanceMgmtCallback stopCallback = AgentInstanceUtil.finalizeSafeStopCallbacks(stopCallbacks);
        return new StatementAgentInstanceFactoryOnTriggerResult(view, stopCallback, agentInstanceContext, aggregationService, subselectActivations, null, null, null, tableAccessEvals, null, postContextMergeRunnable, optPatternRoot, activationResult);
    }

    @Override
    public AIRegistryRequirements getRegistryRequirements() {
        AIRegistryRequirementSubquery[] subqueries = AIRegistryRequirements.getSubqueryRequirements(this.subselects);
        return new AIRegistryRequirements(null, null, subqueries, this.tableAccesses == null ? 0 : this.tableAccesses.size(), false);
    }
}

