/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.aifactory.ontrigger.ontrigger;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.context.aifactory.core.ModuleIncidentals;
import com.espertech.esper.common.internal.context.aifactory.core.StatementAgentInstanceFactoryUtil;
import com.espertech.esper.common.internal.context.aifactory.ontrigger.core.StatementAgentInstanceFactoryOnTriggerBase;
import com.espertech.esper.common.internal.context.module.StatementReadyCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceMgmtCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopServices;
import com.espertech.esper.common.internal.context.util.StatementContext;
import com.espertech.esper.common.internal.context.util.StatementFinalizeCallback;
import com.espertech.esper.common.internal.epl.agg.core.AggregationService;
import com.espertech.esper.common.internal.epl.index.base.EventTable;
import com.espertech.esper.common.internal.epl.lookupplansubord.EventTableIndexMetadata;
import com.espertech.esper.common.internal.epl.lookupplansubord.SubordWMatchExprLookupStrategy;
import com.espertech.esper.common.internal.epl.lookupplansubord.SubordinateQueryPlannerUtil;
import com.espertech.esper.common.internal.epl.lookupplansubord.SubordinateWMatchExprQueryPlan;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindow;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindowInstance;
import com.espertech.esper.common.internal.epl.ontrigger.InfraOnExprBaseViewFactory;
import com.espertech.esper.common.internal.epl.ontrigger.InfraOnExprBaseViewResult;
import com.espertech.esper.common.internal.epl.output.core.OutputProcessViewSimpleWProcessor;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessor;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessorFactoryProvider;
import com.espertech.esper.common.internal.epl.table.core.Table;
import com.espertech.esper.common.internal.epl.table.core.TableInstance;
import com.espertech.esper.common.internal.epl.virtualdw.VirtualDWView;
import com.espertech.esper.common.internal.view.core.View;
import java.util.List;

public abstract class StatementAgentInstanceFactoryOnTriggerInfraBase
extends StatementAgentInstanceFactoryOnTriggerBase
implements StatementReadyCallback {
    private NamedWindow namedWindow;
    private Table table;
    private SubordinateWMatchExprQueryPlan queryPlan;
    private InfraOnExprBaseViewFactory factory;
    private ResultSetProcessorFactoryProvider nonSelectRSPFactoryProvider;

    protected abstract InfraOnExprBaseViewFactory setupFactory(EventType var1, NamedWindow var2, Table var3, StatementContext var4);

    protected abstract boolean isSelect();

    public void setNamedWindow(NamedWindow namedWindow) {
        this.namedWindow = namedWindow;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setQueryPlan(SubordinateWMatchExprQueryPlan queryPlan) {
        this.queryPlan = queryPlan;
    }

    public void setNonSelectRSPFactoryProvider(ResultSetProcessorFactoryProvider nonSelectRSPFactoryProvider) {
        this.nonSelectRSPFactoryProvider = nonSelectRSPFactoryProvider;
    }

    @Override
    public void ready(final StatementContext statementContext, ModuleIncidentals moduleIncidentals, boolean recovery) {
        EventType infraEventType = this.namedWindow != null ? this.namedWindow.getRootView().getEventType() : this.table.getMetaData().getInternalEventType();
        this.factory = this.setupFactory(infraEventType, this.namedWindow, this.table, statementContext);
        if (this.queryPlan.getIndexDescs() != null) {
            EventTableIndexMetadata indexInfo = this.namedWindow != null ? this.namedWindow.getEventTableIndexMetadata() : this.table.getEventTableIndexMetadata();
            SubordinateQueryPlannerUtil.addIndexMetaAndRef(this.queryPlan.getIndexDescs(), indexInfo, statementContext.getDeploymentId(), statementContext.getStatementName());
            statementContext.addFinalizeCallback(new StatementFinalizeCallback(){

                @Override
                public void statementDestroyed(StatementContext context) {
                    for (int i = 0; i < StatementAgentInstanceFactoryOnTriggerInfraBase.this.queryPlan.getIndexDescs().length; ++i) {
                        boolean last;
                        if (StatementAgentInstanceFactoryOnTriggerInfraBase.this.namedWindow != null) {
                            last = StatementAgentInstanceFactoryOnTriggerInfraBase.this.namedWindow.getEventTableIndexMetadata().removeIndexReference(StatementAgentInstanceFactoryOnTriggerInfraBase.this.queryPlan.getIndexDescs()[i].getIndexMultiKey(), statementContext.getDeploymentId());
                            if (!last) continue;
                            StatementAgentInstanceFactoryOnTriggerInfraBase.this.namedWindow.getEventTableIndexMetadata().removeIndex(StatementAgentInstanceFactoryOnTriggerInfraBase.this.queryPlan.getIndexDescs()[i].getIndexMultiKey());
                            StatementAgentInstanceFactoryOnTriggerInfraBase.this.namedWindow.removeAllInstanceIndexes(StatementAgentInstanceFactoryOnTriggerInfraBase.this.queryPlan.getIndexDescs()[i].getIndexMultiKey());
                            continue;
                        }
                        last = StatementAgentInstanceFactoryOnTriggerInfraBase.this.table.getEventTableIndexMetadata().removeIndexReference(StatementAgentInstanceFactoryOnTriggerInfraBase.this.queryPlan.getIndexDescs()[i].getIndexMultiKey(), statementContext.getDeploymentId());
                        if (!last) continue;
                        StatementAgentInstanceFactoryOnTriggerInfraBase.this.table.getEventTableIndexMetadata().removeIndex(StatementAgentInstanceFactoryOnTriggerInfraBase.this.queryPlan.getIndexDescs()[i].getIndexMultiKey());
                        StatementAgentInstanceFactoryOnTriggerInfraBase.this.table.removeAllInstanceIndexes(StatementAgentInstanceFactoryOnTriggerInfraBase.this.queryPlan.getIndexDescs()[i].getIndexMultiKey());
                    }
                }
            });
        }
    }

    @Override
    public InfraOnExprBaseViewResult determineOnExprView(final AgentInstanceContext agentInstanceContext, List<AgentInstanceMgmtCallback> stopCallbacks, boolean isRecoveringResilient) {
        NamedWindowInstance namedWindowInstance = null;
        TableInstance tableInstance = null;
        if (this.namedWindow != null) {
            namedWindowInstance = this.namedWindow.getNamedWindowInstance(agentInstanceContext);
            if (namedWindowInstance == null) {
                throw new RuntimeException("Failed to obtain named window instance for named window '" + this.namedWindow.getName() + "'");
            }
        } else {
            tableInstance = this.table.getTableInstance(agentInstanceContext.getAgentInstanceId());
            if (tableInstance == null) {
                throw new RuntimeException("Failed to obtain table instance for table '" + this.table.getName() + "'");
            }
        }
        EventTable[] indexes = null;
        if (this.queryPlan.getIndexDescs() != null) {
            if (this.namedWindow != null) {
                indexes = SubordinateQueryPlannerUtil.realizeTables(this.queryPlan.getIndexDescs(), namedWindowInstance.getRootViewInstance().getEventType(), namedWindowInstance.getRootViewInstance().getIndexRepository(), namedWindowInstance.getRootViewInstance().getDataWindowContents(), namedWindowInstance.getTailViewInstance().getAgentInstanceContext(), isRecoveringResilient);
                stopCallbacks.add(new AgentInstanceMgmtCallback(){

                    @Override
                    public void stop(AgentInstanceStopServices services) {
                        for (int i = 0; i < StatementAgentInstanceFactoryOnTriggerInfraBase.this.queryPlan.getIndexDescs().length; ++i) {
                            boolean last = StatementAgentInstanceFactoryOnTriggerInfraBase.this.namedWindow.getEventTableIndexMetadata().removeIndexReference(StatementAgentInstanceFactoryOnTriggerInfraBase.this.queryPlan.getIndexDescs()[i].getIndexMultiKey(), agentInstanceContext.getDeploymentId());
                            if (!last) continue;
                            StatementAgentInstanceFactoryOnTriggerInfraBase.this.namedWindow.getEventTableIndexMetadata().removeIndex(StatementAgentInstanceFactoryOnTriggerInfraBase.this.queryPlan.getIndexDescs()[i].getIndexMultiKey());
                            StatementAgentInstanceFactoryOnTriggerInfraBase.this.namedWindow.removeAllInstanceIndexes(StatementAgentInstanceFactoryOnTriggerInfraBase.this.queryPlan.getIndexDescs()[i].getIndexMultiKey());
                        }
                    }
                });
            } else {
                indexes = new EventTable[this.queryPlan.getIndexDescs().length];
                for (int i = 0; i < indexes.length; ++i) {
                    indexes[i] = tableInstance.getIndexRepository().getIndexByDesc(this.queryPlan.getIndexDescs()[i].getIndexMultiKey());
                }
            }
        }
        Iterable<EventBean> scanIterable = this.namedWindow != null ? namedWindowInstance.getRootViewInstance().getDataWindowContents() : tableInstance.getIterableTableScan();
        VirtualDWView virtualDW = this.namedWindow != null ? namedWindowInstance.getRootViewInstance().getVirtualDataWindow() : null;
        SubordWMatchExprLookupStrategy lookupStrategy = this.queryPlan.getFactory().realize(indexes, agentInstanceContext, scanIterable, virtualDW);
        if (this.namedWindow != null) {
            return this.factory.makeNamedWindow(lookupStrategy, namedWindowInstance.getRootViewInstance(), agentInstanceContext);
        }
        return this.factory.makeTable(lookupStrategy, tableInstance, agentInstanceContext);
    }

    @Override
    public View determineFinalOutputView(AgentInstanceContext agentInstanceContext, View onExprView) {
        if (!this.isSelect()) {
            Pair<ResultSetProcessor, AggregationService> pair = StatementAgentInstanceFactoryUtil.startResultSetAndAggregation(this.nonSelectRSPFactoryProvider, agentInstanceContext, false, null);
            OutputProcessViewSimpleWProcessor out = new OutputProcessViewSimpleWProcessor(agentInstanceContext, pair.getFirst());
            out.setParent(onExprView);
            onExprView.setChild(out);
            return out;
        }
        return onExprView;
    }

    public NamedWindow getNamedWindow() {
        return this.namedWindow;
    }

    public Table getTable() {
        return this.table;
    }
}

