/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.aifactory.select;

import com.espertech.esper.common.internal.compile.stage1.spec.DBStatementStreamSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.MethodStreamSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.OuterJoinDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.PatternStreamSpecCompiled;
import com.espertech.esper.common.internal.compile.stage1.spec.StreamSpecCompiled;
import com.espertech.esper.common.internal.compile.stage1.spec.TableQueryStreamSpec;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompiled;
import com.espertech.esper.common.internal.compile.stage2.FilterStreamSpecCompiled;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompiled;
import com.espertech.esper.common.internal.context.aifactory.select.StreamJoinAnalysisResultCompileTime;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.lookupplansubord.EventTableIndexMetadataUtil;
import com.espertech.esper.common.internal.epl.namedwindow.path.NamedWindowMetaData;
import com.espertech.esper.common.internal.type.OuterJoinType;
import com.espertech.esper.common.internal.view.core.ViewFactoryForge;
import com.espertech.esper.common.internal.view.core.ViewFactoryForgeUtil;
import java.util.List;

public class StatementForgeMethodSelectUtil {
    protected static boolean[] getHasIStreamOnly(boolean[] isNamedWindow, List<ViewFactoryForge>[] views) {
        boolean[] result = new boolean[views.length];
        for (int i = 0; i < views.length; ++i) {
            if (isNamedWindow[i]) continue;
            result[i] = !ViewFactoryForgeUtil.hasDataWindows(views[i]);
        }
        return result;
    }

    static String[] determineStreamNames(StreamSpecCompiled[] streams) {
        String[] streamNames = new String[streams.length];
        for (int i = 0; i < streams.length; ++i) {
            streamNames[i] = streams[i].getOptionalStreamName();
            if (streamNames[i] != null) continue;
            streamNames[i] = "stream_" + i;
        }
        return streamNames;
    }

    static StreamJoinAnalysisResultCompileTime verifyJoinViews(StatementSpecCompiled statementSpec) throws ExprValidationException {
        StreamSpecCompiled[] streamSpecs = statementSpec.getStreamSpecs();
        StreamJoinAnalysisResultCompileTime analysisResult = new StreamJoinAnalysisResultCompileTime(streamSpecs.length);
        if (streamSpecs.length < 2) {
            return analysisResult;
        }
        for (int i = 0; i < statementSpec.getStreamSpecs().length; ++i) {
            StreamSpecCompiled streamSpec = statementSpec.getStreamSpecs()[i];
            if (streamSpec.getOptions().isUnidirectional()) {
                analysisResult.setUnidirectionalInd(i);
            }
            if (streamSpec.getViewSpecs().length > 0) {
                analysisResult.setHasChildViews(i);
            }
            if (!(streamSpec instanceof NamedWindowConsumerStreamSpec)) continue;
            NamedWindowConsumerStreamSpec nwSpec = (NamedWindowConsumerStreamSpec)streamSpec;
            if (nwSpec.getOptPropertyEvaluator() != null && !streamSpec.getOptions().isUnidirectional()) {
                throw new ExprValidationException("Failed to validate named window use in join, contained-event is only allowed for named windows when marked as unidirectional");
            }
            NamedWindowMetaData nwinfo = nwSpec.getNamedWindow();
            analysisResult.setNamedWindowsPerStream(i, nwinfo);
            analysisResult.getUniqueKeys()[i] = EventTableIndexMetadataUtil.getUniqueness(nwinfo.getIndexMetadata(), nwinfo.getUniqueness());
        }
        if (statementSpec.getStreamSpecs().length > 1 && analysisResult.isUnidirectional()) {
            StatementForgeMethodSelectUtil.verifyJoinUnidirectional(analysisResult, statementSpec);
        }
        int countProviderNonpolling = 0;
        for (int i = 0; i < statementSpec.getStreamSpecs().length; ++i) {
            if (StatementForgeMethodSelectUtil.isPolling(statementSpec.getStreamSpecs()[i])) continue;
            ++countProviderNonpolling;
        }
        if (countProviderNonpolling == 1) {
            int nonPolling = 0;
            for (int i = 0; i < statementSpec.getStreamSpecs().length; ++i) {
                if (StatementForgeMethodSelectUtil.isPolling(statementSpec.getStreamSpecs()[i])) continue;
                nonPolling = i;
                break;
            }
            if (statementSpec.getStreamSpecs()[nonPolling].getViewSpecs().length == 0) {
                analysisResult.setUnidirectionalInd(nonPolling);
            }
            return analysisResult;
        }
        FilterSpecCompiled unidirectionalFilterSpec = null;
        FilterSpecCompiled lastFilterSpec = null;
        boolean pureSelfJoin = true;
        for (StreamSpecCompiled streamSpec : statementSpec.getStreamSpecs()) {
            if (!(streamSpec instanceof FilterStreamSpecCompiled)) {
                pureSelfJoin = false;
                continue;
            }
            FilterSpecCompiled filterSpec = ((FilterStreamSpecCompiled)streamSpec).getFilterSpecCompiled();
            if (lastFilterSpec != null && !lastFilterSpec.equalsTypeAndFilter(filterSpec)) {
                pureSelfJoin = false;
            }
            if (streamSpec.getViewSpecs().length > 0) {
                pureSelfJoin = false;
            }
            lastFilterSpec = filterSpec;
            if (!streamSpec.getOptions().isUnidirectional()) continue;
            unidirectionalFilterSpec = filterSpec;
        }
        if (pureSelfJoin && unidirectionalFilterSpec == null) {
            analysisResult.setPureSelfJoin(true);
            return analysisResult;
        }
        for (int i = 0; i < statementSpec.getStreamSpecs().length; ++i) {
            StreamSpecCompiled streamSpec = statementSpec.getStreamSpecs()[i];
            if (streamSpec.getViewSpecs().length > 0) continue;
            String name = streamSpec.getOptionalStreamName();
            if (name == null && streamSpec instanceof FilterStreamSpecCompiled) {
                name = ((FilterStreamSpecCompiled)streamSpec).getFilterSpecCompiled().getFilterForEventTypeName();
            }
            if (name == null && streamSpec instanceof PatternStreamSpecCompiled) {
                name = "pattern event stream";
            }
            if (streamSpec.getOptions().isUnidirectional()) continue;
            if (unidirectionalFilterSpec != null && streamSpec instanceof FilterStreamSpecCompiled && ((FilterStreamSpecCompiled)streamSpec).getFilterSpecCompiled().equalsTypeAndFilter(unidirectionalFilterSpec)) {
                analysisResult.setUnidirectionalNonDriving(i);
                continue;
            }
            if (!(streamSpec instanceof FilterStreamSpecCompiled) && !(streamSpec instanceof PatternStreamSpecCompiled)) continue;
            throw new ExprValidationException("Joins require that at least one view is specified for each stream, no view was specified for " + name);
        }
        return analysisResult;
    }

    private static boolean isPolling(StreamSpecCompiled streamSpec) {
        return streamSpec instanceof MethodStreamSpec || streamSpec instanceof DBStatementStreamSpec || streamSpec instanceof TableQueryStreamSpec;
    }

    private static void verifyJoinUnidirectional(StreamJoinAnalysisResultCompileTime analysisResult, StatementSpecCompiled statementSpec) throws ExprValidationException {
        int numUnidirectionalStreams = analysisResult.getUnidirectionalCount();
        int numStreams = statementSpec.getStreamSpecs().length;
        if (!StatementForgeMethodSelectUtil.isFullOuterJoinAllStreams(statementSpec)) {
            if (numUnidirectionalStreams > 1) {
                throw new ExprValidationException("The unidirectional keyword can only apply to one stream in a join");
            }
        } else if (numUnidirectionalStreams > 1 && numUnidirectionalStreams < numStreams) {
            throw new ExprValidationException("The unidirectional keyword must either apply to a single stream or all streams in a full outer join");
        }
        for (int i = 0; i < statementSpec.getStreamSpecs().length; ++i) {
            if (!analysisResult.getUnidirectionalInd()[i] || !analysisResult.getHasChildViews()[i]) continue;
            throw new ExprValidationException("The unidirectional keyword requires that no views are declared onto the stream (applies to stream " + i + ")");
        }
    }

    private static boolean isFullOuterJoinAllStreams(StatementSpecCompiled statementSpec) {
        List<OuterJoinDesc> outers = statementSpec.getRaw().getOuterJoinDescList();
        if (outers == null || outers.size() == 0) {
            return false;
        }
        for (int stream = 0; stream < statementSpec.getStreamSpecs().length - 1; ++stream) {
            if (outers.get(stream).getOuterJoinType() == OuterJoinType.FULL) continue;
            return false;
        }
        return true;
    }
}

