/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.aifactory.update;

import com.espertech.esper.common.client.EventPropertyDescriptor;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerSetAssignment;
import com.espertech.esper.common.internal.compile.stage1.spec.UpdateDesc;
import com.espertech.esper.common.internal.context.aifactory.update.InternalEventRouterDescForge;
import com.espertech.esper.common.internal.context.aifactory.update.InternalEventRouterWriterArrayElementForge;
import com.espertech.esper.common.internal.context.aifactory.update.InternalEventRouterWriterCurlyForge;
import com.espertech.esper.common.internal.context.aifactory.update.InternalEventRouterWriterForge;
import com.espertech.esper.common.internal.epl.expression.assign.ExprAssignment;
import com.espertech.esper.common.internal.epl.expression.assign.ExprAssignmentCurly;
import com.espertech.esper.common.internal.epl.expression.assign.ExprAssignmentLHS;
import com.espertech.esper.common.internal.epl.expression.assign.ExprAssignmentLHSArrayElement;
import com.espertech.esper.common.internal.epl.expression.assign.ExprAssignmentLHSIdent;
import com.espertech.esper.common.internal.epl.expression.assign.ExprAssignmentLHSIdentWSubprop;
import com.espertech.esper.common.internal.epl.expression.assign.ExprAssignmentStraight;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.event.core.EventBeanCopyMethodForge;
import com.espertech.esper.common.internal.event.core.EventTypeSPI;
import com.espertech.esper.common.internal.util.TypeWidenerException;
import com.espertech.esper.common.internal.util.TypeWidenerFactory;
import com.espertech.esper.common.internal.util.TypeWidenerSPI;
import java.lang.annotation.Annotation;
import java.util.ArrayList;

public class InternalEventRouterDescFactory {
    public static InternalEventRouterDescForge getValidatePreprocessing(EventType eventType, UpdateDesc desc, Annotation[] annotations) throws ExprValidationException {
        if (!(eventType instanceof EventTypeSPI)) {
            throw new ExprValidationException("Update statements require the event type to implement the " + EventTypeSPI.class + " interface");
        }
        EventTypeSPI eventTypeSPI = (EventTypeSPI)eventType;
        ArrayList<TypeWidenerSPI> wideners = new ArrayList<TypeWidenerSPI>();
        ArrayList<String> properties = new ArrayList<String>();
        ArrayList<String> propertiesTouched = new ArrayList<String>();
        ArrayList<ExprNode> expressions = new ArrayList<ExprNode>();
        ArrayList<InternalEventRouterWriterForge> specialWriters = new ArrayList<InternalEventRouterWriterForge>();
        for (int i = 0; i < desc.getAssignments().size(); ++i) {
            OnTriggerSetAssignment onSet = desc.getAssignments().get(i);
            ExprAssignment assignmentDesc = onSet.getValidated();
            try {
                if (assignmentDesc instanceof ExprAssignmentStraight) {
                    TypeWidenerSPI widener;
                    EventPropertyDescriptor writableProperty;
                    String propertyName;
                    ExprAssignmentStraight assignment = (ExprAssignmentStraight)assignmentDesc;
                    ExprAssignmentLHS lhs = assignment.getLhs();
                    if (lhs instanceof ExprAssignmentLHSIdent) {
                        ExprAssignmentLHSIdent ident = (ExprAssignmentLHSIdent)lhs;
                        propertyName = ident.getIdent();
                        writableProperty = eventTypeSPI.getWritableProperty(propertyName);
                        if (writableProperty == null) {
                            throw new ExprValidationException("Property '" + propertyName + "' is not available for write access");
                        }
                        try {
                            widener = TypeWidenerFactory.getCheckPropertyAssignType(ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(assignment.getRhs()), assignment.getRhs().getForge().getEvaluationType(), writableProperty.getPropertyType(), propertyName, false, null, null);
                        }
                        catch (TypeWidenerException ex) {
                            throw new ExprValidationException(ex.getMessage(), ex);
                        }
                        properties.add(propertyName);
                        propertiesTouched.add(propertyName);
                        expressions.add(assignment.getRhs());
                        wideners.add(widener);
                        continue;
                    }
                    if (lhs instanceof ExprAssignmentLHSIdentWSubprop) {
                        ExprAssignmentLHSIdentWSubprop subprop = (ExprAssignmentLHSIdentWSubprop)lhs;
                        throw new ExprValidationException("Property '" + subprop.getSubpropertyName() + "' is not available for write access");
                    }
                    if (lhs instanceof ExprAssignmentLHSArrayElement) {
                        ExprAssignmentLHSArrayElement arrayElement = (ExprAssignmentLHSArrayElement)lhs;
                        propertyName = lhs.getIdent();
                        writableProperty = eventTypeSPI.getWritableProperty(propertyName);
                        if (writableProperty == null) {
                            throw new ExprValidationException("Property '" + propertyName + "' is not available for write access");
                        }
                        if (!writableProperty.getPropertyType().isArray()) {
                            throw new ExprValidationException("Property '" + propertyName + "' type is not array");
                        }
                        try {
                            widener = TypeWidenerFactory.getCheckPropertyAssignType(ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(assignment.getRhs()), assignment.getRhs().getForge().getEvaluationType(), writableProperty.getPropertyType().getComponentType(), propertyName, false, null, null);
                        }
                        catch (TypeWidenerException ex) {
                            throw new ExprValidationException(ex.getMessage(), ex);
                        }
                        InternalEventRouterWriterArrayElementForge special = new InternalEventRouterWriterArrayElementForge(arrayElement.getIndexExpression(), assignment.getRhs(), widener, propertyName);
                        specialWriters.add(special);
                        continue;
                    }
                    throw new IllegalStateException("Unrecognized left hande side assignment " + lhs);
                }
                if (assignmentDesc instanceof ExprAssignmentCurly) {
                    ExprAssignmentCurly curly = (ExprAssignmentCurly)assignmentDesc;
                    InternalEventRouterWriterCurlyForge special = new InternalEventRouterWriterCurlyForge(curly.getExpression());
                    specialWriters.add(special);
                    continue;
                }
                throw new IllegalStateException("Unrecognized assignment " + assignmentDesc);
            }
            catch (ExprValidationException ex) {
                throw new ExprValidationException("Failed to validate assignment expression '" + ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(assignmentDesc.getOriginalExpression()) + "': " + ex.getMessage(), ex);
            }
        }
        EventBeanCopyMethodForge copyMethod = eventTypeSPI.getCopyMethodForge(propertiesTouched.toArray(new String[0]));
        if (copyMethod == null) {
            throw new ExprValidationException("The update-clause requires the underlying event representation to support copy (via Serializable by default)");
        }
        return new InternalEventRouterDescForge(copyMethod, wideners.toArray(new TypeWidenerSPI[0]), eventType, annotations, desc.getOptionalWhereClause(), properties.toArray(new String[0]), expressions.toArray(new ExprNode[0]), specialWriters.toArray(new InternalEventRouterWriterForge[0]));
    }
}

