/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.aifactory.update;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.context.aifactory.core.ModuleIncidentals;
import com.espertech.esper.common.internal.context.aifactory.core.StatementAgentInstanceFactory;
import com.espertech.esper.common.internal.context.aifactory.core.StatementAgentInstanceFactoryResult;
import com.espertech.esper.common.internal.context.aifactory.update.InternalEventRouterDesc;
import com.espertech.esper.common.internal.context.aifactory.update.StatementAgentInstanceFactoryUpdateResult;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryRequirements;
import com.espertech.esper.common.internal.context.module.StatementReadyCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceMgmtCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopServices;
import com.espertech.esper.common.internal.context.util.AgentInstanceTransferServices;
import com.espertech.esper.common.internal.context.util.AgentInstanceUtil;
import com.espertech.esper.common.internal.context.util.InternalRoutePreprocessView;
import com.espertech.esper.common.internal.context.util.StatementAgentInstanceLock;
import com.espertech.esper.common.internal.context.util.StatementContext;
import com.espertech.esper.common.internal.epl.subselect.SubSelectFactory;
import com.espertech.esper.common.internal.epl.subselect.SubSelectFactoryResult;
import com.espertech.esper.common.internal.epl.subselect.SubSelectHelperStart;
import java.util.ArrayList;
import java.util.Map;

public class StatementAgentInstanceFactoryUpdate
implements StatementAgentInstanceFactory,
StatementReadyCallback {
    private InternalEventRouterDesc desc;
    private InternalRoutePreprocessView viewable;
    private Map<Integer, SubSelectFactory> subselects;

    public void setDesc(InternalEventRouterDesc desc) {
        this.desc = desc;
    }

    public void setSubselects(Map<Integer, SubSelectFactory> subselects) {
        this.subselects = subselects;
    }

    @Override
    public EventType getStatementEventType() {
        return this.desc.getEventType();
    }

    @Override
    public void ready(StatementContext statementContext, ModuleIncidentals moduleIncidentals, boolean recovery) {
        this.viewable = new InternalRoutePreprocessView(this.desc.getEventType(), statementContext.getStatementResultService());
        this.desc.setAnnotations(statementContext.getAnnotations());
    }

    @Override
    public void statementCreate(StatementContext statementContext) {
    }

    @Override
    public void statementDestroy(StatementContext statementContext) {
    }

    @Override
    public StatementAgentInstanceFactoryResult newContext(final AgentInstanceContext agentInstanceContext, boolean isRecoveringResilient) {
        ArrayList<AgentInstanceMgmtCallback> stopCallbacks = new ArrayList<AgentInstanceMgmtCallback>();
        stopCallbacks.add(new AgentInstanceMgmtCallback(){

            @Override
            public void stop(AgentInstanceStopServices services) {
                agentInstanceContext.getInternalEventRouter().removePreprocessing(StatementAgentInstanceFactoryUpdate.this.desc.getEventType(), StatementAgentInstanceFactoryUpdate.this.desc);
            }

            @Override
            public void transfer(AgentInstanceTransferServices services) {
                services.getAgentInstanceContext().getInternalEventRouter().removePreprocessing(StatementAgentInstanceFactoryUpdate.this.desc.getEventType(), StatementAgentInstanceFactoryUpdate.this.desc);
                services.getTargetInternalEventRouter().addPreprocessing(StatementAgentInstanceFactoryUpdate.this.desc, StatementAgentInstanceFactoryUpdate.this.viewable, agentInstanceContext.getStatementContext(), !StatementAgentInstanceFactoryUpdate.this.subselects.isEmpty());
            }
        });
        Map<Integer, SubSelectFactoryResult> subselectActivations = SubSelectHelperStart.startSubselects(this.subselects, agentInstanceContext, stopCallbacks, isRecoveringResilient);
        boolean hasSubselect = !subselectActivations.isEmpty();
        agentInstanceContext.getInternalEventRouter().addPreprocessing(this.desc, this.viewable, agentInstanceContext.getStatementContext(), hasSubselect);
        AgentInstanceMgmtCallback stopCallback = AgentInstanceUtil.finalizeSafeStopCallbacks(stopCallbacks);
        return new StatementAgentInstanceFactoryUpdateResult(this.viewable, stopCallback, agentInstanceContext, subselectActivations);
    }

    @Override
    public AIRegistryRequirements getRegistryRequirements() {
        return AIRegistryRequirements.noRequirements();
    }

    @Override
    public StatementAgentInstanceLock obtainAgentInstanceLock(StatementContext statementContext, int agentInstanceId) {
        return AgentInstanceUtil.newLock(statementContext);
    }
}

