/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.airegistry;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.ArrayWrap;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryAggregation;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryUtil;
import com.espertech.esper.common.internal.epl.agg.core.AggregationGroupByRollupLevel;
import com.espertech.esper.common.internal.epl.agg.core.AggregationRow;
import com.espertech.esper.common.internal.epl.agg.core.AggregationRowRemovedCallback;
import com.espertech.esper.common.internal.epl.agg.core.AggregationService;
import com.espertech.esper.common.internal.epl.agg.core.AggregationServiceVisitor;
import com.espertech.esper.common.internal.epl.agg.core.AggregationServiceVisitorWGroupDetail;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import java.util.Collection;

public class AIRegistryAggregationMultiPerm
implements AIRegistryAggregation {
    private final ArrayWrap<AggregationService> services = new ArrayWrap(AggregationService.class, 2);
    private int count;

    AIRegistryAggregationMultiPerm() {
    }

    @Override
    public void assignService(int serviceId, AggregationService aggregationService) {
        AIRegistryUtil.checkExpand(serviceId, this.services);
        this.services.getArray()[serviceId] = aggregationService;
        ++this.count;
    }

    @Override
    public void deassignService(int serviceId) {
        if (serviceId >= this.services.getArray().length) {
            return;
        }
        this.services.getArray()[serviceId] = null;
        --this.count;
    }

    @Override
    public int getInstanceCount() {
        return this.count;
    }

    @Override
    public void applyEnter(EventBean[] eventsPerStream, Object optionalGroupKeyPerRow, ExprEvaluatorContext exprEvaluatorContext) {
        this.services.getArray()[exprEvaluatorContext.getAgentInstanceId()].applyEnter(eventsPerStream, optionalGroupKeyPerRow, exprEvaluatorContext);
    }

    @Override
    public void applyLeave(EventBean[] eventsPerStream, Object optionalGroupKeyPerRow, ExprEvaluatorContext exprEvaluatorContext) {
        this.services.getArray()[exprEvaluatorContext.getAgentInstanceId()].applyLeave(eventsPerStream, optionalGroupKeyPerRow, exprEvaluatorContext);
    }

    @Override
    public void setCurrentAccess(Object groupKey, int agentInstanceId, AggregationGroupByRollupLevel rollupLevel) {
        this.services.getArray()[agentInstanceId].setCurrentAccess(groupKey, agentInstanceId, null);
    }

    @Override
    public AggregationService getContextPartitionAggregationService(int agentInstanceId) {
        return this.services.getArray()[agentInstanceId];
    }

    @Override
    public void clearResults(ExprEvaluatorContext exprEvaluatorContext) {
        this.services.getArray()[exprEvaluatorContext.getAgentInstanceId()].clearResults(exprEvaluatorContext);
    }

    @Override
    public Object getValue(int column, int agentInstanceId, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.services.getArray()[agentInstanceId].getValue(column, agentInstanceId, eventsPerStream, isNewData, exprEvaluatorContext);
    }

    @Override
    public Collection<EventBean> getCollectionOfEvents(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.services.getArray()[context.getAgentInstanceId()].getCollectionOfEvents(column, eventsPerStream, isNewData, context);
    }

    @Override
    public Collection<Object> getCollectionScalar(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.services.getArray()[context.getAgentInstanceId()].getCollectionScalar(column, eventsPerStream, isNewData, context);
    }

    @Override
    public EventBean getEventBean(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.services.getArray()[context.getAgentInstanceId()].getEventBean(column, eventsPerStream, isNewData, context);
    }

    @Override
    public AggregationRow getAggregationRow(int agentInstanceId, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.services.getArray()[context.getAgentInstanceId()].getAggregationRow(agentInstanceId, eventsPerStream, isNewData, context);
    }

    @Override
    public void setRemovedCallback(AggregationRowRemovedCallback callback) {
    }

    @Override
    public void accept(AggregationServiceVisitor visitor) {
        throw new UnsupportedOperationException("Not applicable");
    }

    @Override
    public void acceptGroupDetail(AggregationServiceVisitorWGroupDetail visitor) {
        throw new UnsupportedOperationException("Not applicable");
    }

    @Override
    public boolean isGrouped() {
        throw new UnsupportedOperationException("Not applicable");
    }

    @Override
    public Object getGroupKey(int agentInstanceId) {
        return this.services.getArray()[agentInstanceId].getGroupKey(agentInstanceId);
    }

    @Override
    public Collection<Object> getGroupKeys(ExprEvaluatorContext exprEvaluatorContext) {
        return this.services.getArray()[exprEvaluatorContext.getAgentInstanceId()].getGroupKeys(exprEvaluatorContext);
    }

    @Override
    public void stop() {
    }
}

