/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.airegistry;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.ArrayWrap;
import com.espertech.esper.common.internal.context.airegistry.AIRegistrySubselectLookup;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryUtil;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.lookup.LookupStrategyDesc;
import com.espertech.esper.common.internal.epl.lookup.SubordTableLookupStrategy;
import java.util.Collection;

public class AIRegistrySubselectLookupMultiPerm
implements AIRegistrySubselectLookup {
    private final LookupStrategyDesc strategyDesc;
    private final ArrayWrap<SubordTableLookupStrategy> strategies;
    private int count;

    public AIRegistrySubselectLookupMultiPerm(LookupStrategyDesc strategyDesc) {
        this.strategyDesc = strategyDesc;
        this.strategies = new ArrayWrap(SubordTableLookupStrategy.class, 10);
    }

    @Override
    public void assignService(int num, SubordTableLookupStrategy subselectStrategy) {
        AIRegistryUtil.checkExpand(num, this.strategies);
        this.strategies.getArray()[num] = subselectStrategy;
        ++this.count;
    }

    @Override
    public void deassignService(int num) {
        this.strategies.getArray()[num] = null;
        --this.count;
    }

    @Override
    public Collection<EventBean> lookup(EventBean[] events, ExprEvaluatorContext context) {
        return this.strategies.getArray()[context.getAgentInstanceId()].lookup(events, context);
    }

    @Override
    public int getInstanceCount() {
        return this.count;
    }

    @Override
    public String toQueryPlan() {
        return this.strategyDesc.getLookupStrategy().name();
    }

    @Override
    public LookupStrategyDesc getStrategyDesc() {
        return this.strategyDesc;
    }
}

