/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.controller.category;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompiled;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompiled;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.context.controller.core.ContextControllerPortableInfo;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.util.StatementSpecCompiledAnalyzer;
import com.espertech.esper.common.internal.epl.util.StatementSpecCompiledAnalyzerResult;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import java.util.List;

public class ContextControllerCategoryValidation
implements ContextControllerPortableInfo {
    private final EventType categoryEventType;

    public ContextControllerCategoryValidation(EventType categoryEventType) {
        this.categoryEventType = categoryEventType;
    }

    public EventType getCategoryEventType() {
        return this.categoryEventType;
    }

    @Override
    public CodegenExpression make(CodegenExpressionRef addInitSvc) {
        return CodegenExpressionBuilder.newInstance(ContextControllerCategoryValidation.class, EventTypeUtility.resolveTypeCodegen(this.categoryEventType, addInitSvc));
    }

    @Override
    public void validateStatement(String contextName, StatementSpecCompiled spec, StatementCompileTimeServices compileTimeServices) throws ExprValidationException {
        StatementSpecCompiledAnalyzerResult streamAnalysis = StatementSpecCompiledAnalyzer.analyzeFilters(spec);
        List<FilterSpecCompiled> filters = streamAnalysis.getFilters();
        boolean isCreateWindow = spec.getRaw().getCreateWindowDesc() != null;
        String message = "Category context '" + contextName + "' requires that any of the events types that are listed in the category context also appear in any of the filter expressions of the statement";
        if (!isCreateWindow) {
            for (FilterSpecCompiled filter : filters) {
                EventType stmtFilterType = filter.getFilterForEventType();
                if (stmtFilterType == this.categoryEventType) {
                    return;
                }
                if (!EventTypeUtility.isTypeOrSubTypeOf(stmtFilterType, this.categoryEventType)) continue;
                return;
            }
            if (!filters.isEmpty()) {
                throw new ExprValidationException(message);
            }
            return;
        }
        String declaredAsName = spec.getRaw().getCreateWindowDesc().getAsEventTypeName();
        if (declaredAsName != null) {
            if (this.categoryEventType.getName().equals(declaredAsName)) {
                return;
            }
            throw new ExprValidationException(message);
        }
    }
}

