/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.controller.condition;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.IntSeqKey;
import com.espertech.esper.common.internal.context.controller.condition.ContextConditionDescriptor;
import com.espertech.esper.common.internal.context.controller.condition.ContextConditionDescriptorCrontab;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerConditionCallback;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerConditionCrontab;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerConditionNonHA;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerEndConditionMatchEventProvider;
import com.espertech.esper.common.internal.context.controller.core.ContextController;
import com.espertech.esper.common.internal.context.controller.initterm.ContextControllerInitTermUtil;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceTransferServices;
import com.espertech.esper.common.internal.context.util.EPStatementHandleCallbackSchedule;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallback;
import com.espertech.esper.common.internal.schedule.ScheduleObjectType;
import com.espertech.esper.common.internal.schedule.ScheduleSpec;
import java.util.Map;

public class ContextControllerConditionCrontabImpl
implements ContextControllerConditionNonHA,
ContextControllerConditionCrontab {
    public static final String NAME_AUDITPROVIDER_SCHEDULE = "context-condition crontab";
    private final IntSeqKey conditionPath;
    private final long scheduleSlot;
    private final ScheduleSpec[] scheduleSpecs;
    private final ContextConditionDescriptorCrontab crontab;
    private final ContextControllerConditionCallback callback;
    private final ContextController controller;
    private EPStatementHandleCallbackSchedule scheduleHandle;

    public ContextControllerConditionCrontabImpl(IntSeqKey conditionPath, long scheduleSlot, ScheduleSpec[] scheduleSpecs, ContextConditionDescriptorCrontab crontab, ContextControllerConditionCallback callback, ContextController controller) {
        this.conditionPath = conditionPath;
        this.scheduleSlot = scheduleSlot;
        this.scheduleSpecs = scheduleSpecs;
        this.crontab = crontab;
        this.callback = callback;
        this.controller = controller;
    }

    @Override
    public boolean activate(EventBean optionalTriggeringEvent, ContextControllerEndConditionMatchEventProvider endConditionMatchEventProvider, Map<String, Object> optionalTriggeringPattern) {
        ScheduleHandleCallback scheduleCallback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger() {
                AgentInstanceContext agentInstanceContext = ContextControllerConditionCrontabImpl.this.controller.getRealization().getAgentInstanceContextCreate();
                agentInstanceContext.getInstrumentationProvider().qContextScheduledEval(agentInstanceContext.getStatementContext().getContextRuntimeDescriptor());
                ContextControllerConditionCrontabImpl.this.scheduleHandle = null;
                agentInstanceContext.getAuditProvider().scheduleFire(agentInstanceContext, ScheduleObjectType.context, ContextControllerConditionCrontabImpl.NAME_AUDITPROVIDER_SCHEDULE);
                ContextControllerConditionCrontabImpl.this.callback.rangeNotification(ContextControllerConditionCrontabImpl.this.conditionPath, ContextControllerConditionCrontabImpl.this, null, null, null, null);
                agentInstanceContext.getInstrumentationProvider().aContextScheduledEval();
            }
        };
        AgentInstanceContext agentInstanceContext = this.controller.getRealization().getAgentInstanceContextCreate();
        this.scheduleHandle = new EPStatementHandleCallbackSchedule(agentInstanceContext.getEpStatementAgentInstanceHandle(), scheduleCallback);
        long nextScheduledTime = ContextControllerInitTermUtil.computeScheduleMinimumDelta(this.scheduleSpecs, agentInstanceContext.getTimeProvider().getTime(), agentInstanceContext.getClasspathImportServiceRuntime());
        agentInstanceContext.getAuditProvider().scheduleAdd(nextScheduledTime, agentInstanceContext, this.scheduleHandle, ScheduleObjectType.context, NAME_AUDITPROVIDER_SCHEDULE);
        agentInstanceContext.getSchedulingService().add(nextScheduledTime, this.scheduleHandle, this.scheduleSlot);
        return false;
    }

    @Override
    public void deactivate() {
        if (this.scheduleHandle != null) {
            AgentInstanceContext agentInstanceContext = this.controller.getRealization().getAgentInstanceContextCreate();
            agentInstanceContext.getAuditProvider().scheduleRemove(agentInstanceContext, this.scheduleHandle, ScheduleObjectType.context, NAME_AUDITPROVIDER_SCHEDULE);
            agentInstanceContext.getSchedulingService().remove(this.scheduleHandle, this.scheduleSlot);
        }
        this.scheduleHandle = null;
    }

    @Override
    public boolean isImmediate() {
        return this.crontab.isImmediate();
    }

    @Override
    public boolean isRunning() {
        return this.scheduleHandle != null;
    }

    @Override
    public Long getExpectedEndTime() {
        return this.crontab.getExpectedEndTime(this.controller.getRealization(), this.scheduleSpecs);
    }

    @Override
    public ContextConditionDescriptor getDescriptor() {
        return this.crontab;
    }

    @Override
    public ScheduleSpec[] getSchedules() {
        return this.scheduleSpecs;
    }

    @Override
    public void transfer(AgentInstanceTransferServices xfer) {
    }
}

