/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.controller.hash;

import com.espertech.esper.common.internal.collection.IntSeqKey;
import com.espertech.esper.common.internal.context.controller.core.ContextControllerFilterEntry;
import com.espertech.esper.common.internal.context.controller.hash.ContextControllerHashSvc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class ContextControllerHashSvcLevelOne
implements ContextControllerHashSvc {
    private static final Object[] EMPTY_PARENT_PARTITION_KEYS = new Object[0];
    private ContextControllerFilterEntry[] filterEntries;
    private int[] subpathOrCPIdsPreallocate;
    private Map<Integer, Integer> optionalHashes;

    public ContextControllerHashSvcLevelOne(boolean preallocate) {
        if (!preallocate) {
            this.optionalHashes = new HashMap<Integer, Integer>();
        }
    }

    @Override
    public void mgmtCreate(IntSeqKey controllerPath, Object[] parentPartitionKeys) {
    }

    @Override
    public void mgmtSetFilters(IntSeqKey controllerPath, ContextControllerFilterEntry[] filterEntries) {
        this.filterEntries = filterEntries;
    }

    @Override
    public int[] mgmtGetSubpathOrCPIdsWhenPreallocate(IntSeqKey path) {
        return this.subpathOrCPIdsPreallocate;
    }

    @Override
    public void mgmtSetSubpathOrCPIdsWhenPreallocate(IntSeqKey path, int[] subpathOrCPIds) {
        this.subpathOrCPIdsPreallocate = subpathOrCPIds;
    }

    @Override
    public Object[] mgmtGetParentPartitionKeys(IntSeqKey controllerPath) {
        return EMPTY_PARENT_PARTITION_KEYS;
    }

    @Override
    public ContextControllerFilterEntry[] mgmtGetFilters(IntSeqKey controllerPath) {
        return this.filterEntries;
    }

    @Override
    public boolean hashHasSeenPartition(IntSeqKey controllerPath, int value) {
        return this.optionalHashes.containsKey(value);
    }

    @Override
    public void hashAddPartition(IntSeqKey controllerPath, int value, int subpathIdOrCPId) {
        this.optionalHashes.put(value, subpathIdOrCPId);
    }

    @Override
    public void hashVisit(IntSeqKey controllerPath, BiConsumer<Integer, Integer> hashAndCPId) {
        if (this.optionalHashes == null) {
            if (this.subpathOrCPIdsPreallocate == null) {
                return;
            }
            for (int i = 0; i < this.subpathOrCPIdsPreallocate.length; ++i) {
                hashAndCPId.accept(i, this.subpathOrCPIdsPreallocate[i]);
            }
            return;
        }
        for (Map.Entry<Integer, Integer> entry : this.optionalHashes.entrySet()) {
            hashAndCPId.accept(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public int hashGetSubpathOrCPId(IntSeqKey controllerPath, int hash) {
        if (this.optionalHashes == null) {
            if (hash >= this.subpathOrCPIdsPreallocate.length) {
                return -1;
            }
            return this.subpathOrCPIdsPreallocate[hash];
        }
        Integer entry = this.optionalHashes.get(hash);
        return entry == null ? -1 : entry;
    }

    @Override
    public Collection<Integer> deactivate(IntSeqKey controllerPath) {
        if (this.optionalHashes == null) {
            ArrayList<Integer> ids = new ArrayList<Integer>(this.subpathOrCPIdsPreallocate.length);
            for (int id : this.subpathOrCPIdsPreallocate) {
                ids.add(id);
            }
            return ids;
        }
        ArrayList<Integer> ids = new ArrayList<Integer>(this.optionalHashes.values());
        this.optionalHashes.clear();
        return ids;
    }

    @Override
    public void destroy() {
        if (this.optionalHashes != null) {
            this.optionalHashes.clear();
        }
        this.subpathOrCPIdsPreallocate = null;
        this.filterEntries = null;
    }
}

