/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.controller.hash;

import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.stage1.spec.ContextSpecHash;
import com.espertech.esper.common.internal.compile.stage1.spec.ContextSpecHashItem;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.context.controller.core.ContextControllerFactory;
import com.espertech.esper.common.internal.context.controller.hash.ContextControllerHashFactory;
import com.espertech.esper.common.internal.context.controller.hash.ContextControllerHashSvc;
import com.espertech.esper.common.internal.context.controller.hash.ContextControllerHashSvcLevelAny;
import com.espertech.esper.common.internal.context.controller.hash.ContextControllerHashSvcLevelOne;
import com.espertech.esper.common.internal.context.controller.hash.ContextControllerHashedGetterCRC32SerializedForge;
import com.espertech.esper.common.internal.context.controller.hash.ContextControllerHashedGetterCRC32SingleForge;
import com.espertech.esper.common.internal.context.controller.hash.ContextControllerHashedGetterHashMultiple;
import com.espertech.esper.common.internal.context.controller.hash.ContextControllerHashedGetterHashSingleForge;
import com.espertech.esper.common.internal.context.controller.hash.ContextControllerHashedGetterSingleRowForge;
import com.espertech.esper.common.internal.context.controller.hash.HashFunctionEnum;
import com.espertech.esper.common.internal.context.mgr.ContextManagerRealization;
import com.espertech.esper.common.internal.epl.expression.chain.Chainable;
import com.espertech.esper.common.internal.epl.expression.core.ExprEventEvaluatorForgeFromProp;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterSpecLookupableForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.event.core.EventPropertyValueGetterForge;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForgeSingleton;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIONullableIntegerSerde;
import com.espertech.esper.common.internal.settings.ClasspathImportSingleRowDesc;
import java.util.List;

public class ContextControllerHashUtil {
    public static void validateContextDesc(String contextName, ContextSpecHash hashedSpec, StatementRawInfo statementRawInfo, StatementCompileTimeServices services) throws ExprValidationException {
        if (hashedSpec.getItems().isEmpty()) {
            throw new ExprValidationException("Empty list of hash items");
        }
        for (ContextSpecHashItem item : hashedSpec.getItems()) {
            EventPropertyValueGetterForge getter;
            Chainable chainable = item.getFunction();
            String hashFuncName = chainable.getRootNameOrEmptyString();
            List<ExprNode> params = chainable.getParametersOrEmpty();
            HashFunctionEnum hashFunction = HashFunctionEnum.determine(contextName, hashFuncName);
            Pair<Class, ClasspathImportSingleRowDesc> hashSingleRowFunction = null;
            if (hashFunction == null) {
                try {
                    hashSingleRowFunction = services.getClasspathImportServiceCompileTime().resolveSingleRow(hashFuncName, services.getClassProvidedClasspathExtension());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (hashSingleRowFunction == null) {
                    throw new ExprValidationException("For context '" + contextName + "' expected a hash function that is any of {" + HashFunctionEnum.getStringList() + "} or a plug-in single-row function or script but received '" + hashFuncName + "'");
                }
            }
            if (params.isEmpty()) {
                throw new ExprValidationException("For context '" + contextName + "' expected one or more parameters to the hash function, but found no parameter list");
            }
            ExprNode paramExpr = params.get(0);
            Class paramType = paramExpr.getForge().getEvaluationType();
            if (hashFunction == HashFunctionEnum.CONSISTENT_HASH_CRC32) {
                getter = params.size() > 1 || paramType != String.class ? new ContextControllerHashedGetterCRC32SerializedForge(params, hashedSpec.getGranularity()) : new ContextControllerHashedGetterCRC32SingleForge(paramExpr, hashedSpec.getGranularity());
            } else if (hashFunction == HashFunctionEnum.HASH_CODE) {
                getter = params.size() > 1 ? new ContextControllerHashedGetterHashMultiple(params, hashedSpec.getGranularity()) : new ContextControllerHashedGetterHashSingleForge(paramExpr, hashedSpec.getGranularity());
            } else if (hashSingleRowFunction != null) {
                getter = new ContextControllerHashedGetterSingleRowForge(hashSingleRowFunction, params, hashedSpec.getGranularity(), item.getFilterSpecCompiled().getFilterForEventType(), statementRawInfo, services);
            } else {
                throw new IllegalArgumentException("Unrecognized hash code function '" + hashFuncName + "'");
            }
            String expression = hashFuncName + "(" + ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(paramExpr) + ")";
            DataInputOutputSerdeForgeSingleton valueSerde = new DataInputOutputSerdeForgeSingleton(DIONullableIntegerSerde.class);
            ExprEventEvaluatorForgeFromProp eval = new ExprEventEvaluatorForgeFromProp(getter);
            ExprFilterSpecLookupableForge lookupable = new ExprFilterSpecLookupableForge(expression, eval, null, Integer.class, true, valueSerde);
            item.setLookupable(lookupable);
        }
    }

    public static ContextControllerHashSvc makeService(ContextControllerHashFactory factory, ContextManagerRealization realization) {
        ContextControllerFactory[] factories = realization.getContextManager().getContextDefinition().getControllerFactories();
        boolean preallocate = factory.getHashSpec().isPreallocate();
        if (factories.length == 1) {
            return new ContextControllerHashSvcLevelOne(preallocate);
        }
        return new ContextControllerHashSvcLevelAny(preallocate);
    }
}

