/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.controller.initterm;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.IntSeqKey;
import com.espertech.esper.common.internal.context.controller.condition.ContextConditionDescriptor;
import com.espertech.esper.common.internal.context.controller.condition.ContextConditionDescriptorFilter;
import com.espertech.esper.common.internal.context.controller.condition.ContextConditionDescriptorImmediate;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerConditionFactory;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerConditionNonHA;
import com.espertech.esper.common.internal.context.controller.initterm.ContextControllerInitTermBase;
import com.espertech.esper.common.internal.context.controller.initterm.ContextControllerInitTermFactory;
import com.espertech.esper.common.internal.context.controller.initterm.ContextControllerInitTermSvcEntry;
import com.espertech.esper.common.internal.context.controller.initterm.ContextControllerInitTermUtil;
import com.espertech.esper.common.internal.context.controller.initterm.ContextControllerInitTermWLastTrigger;
import com.espertech.esper.common.internal.context.mgr.ContextManagerRealization;
import com.espertech.esper.common.internal.context.util.AgentInstance;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceUtil;
import com.espertech.esper.common.internal.context.util.FilterFaultHandler;
import com.espertech.esper.common.internal.context.util.StatementAgentInstanceLock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ContextControllerInitTermNonOverlap
extends ContextControllerInitTermBase
implements ContextControllerInitTermWLastTrigger {
    private EventBean lastTriggerEvent;

    public ContextControllerInitTermNonOverlap(ContextControllerInitTermFactory factory, ContextManagerRealization realization) {
        super(factory, realization);
    }

    @Override
    public void activate(IntSeqKey path, Object[] parentPartitionKeys, EventBean optionalTriggeringEvent, Map<String, Object> optionalTriggeringPattern) {
        this.initTermSvc.mgmtCreate(path, parentPartitionKeys);
        ContextControllerConditionNonHA startCondition = ContextControllerConditionFactory.getEndpoint(path, parentPartitionKeys, this.factory.initTermSpec.getStartCondition(), this, this, true);
        boolean currentlyRunning = ContextControllerInitTermUtil.determineCurrentlyRunning(startCondition, this);
        if (!currentlyRunning) {
            this.initTermSvc.mgmtUpdSetStartCondition(path, startCondition);
            boolean isTriggeringEventMatchesFilter = startCondition.activate(optionalTriggeringEvent, null, optionalTriggeringPattern);
            if (isTriggeringEventMatchesFilter) {
                this.rangeNotificationStart(path, optionalTriggeringEvent, null, null, null);
            }
        } else {
            this.instantiateAndActivateEndCondition(path, optionalTriggeringEvent, optionalTriggeringPattern, optionalTriggeringPattern, startCondition);
        }
    }

    @Override
    public void rangeNotification(IntSeqKey conditionPath, ContextControllerConditionNonHA originCondition, EventBean optionalTriggeringEvent, Map<String, Object> optionalTriggeringPattern, EventBean optionalTriggeringEventPattern, Map<String, Object> optionalPatternForInclusiveEval) {
        boolean endConditionNotification;
        boolean bl = endConditionNotification = originCondition.getDescriptor() != this.factory.getInitTermSpec().getStartCondition();
        if (endConditionNotification) {
            this.rangeNotificationEnd(conditionPath, originCondition, optionalTriggeringEvent, optionalTriggeringPattern, optionalTriggeringEventPattern);
        } else {
            this.lastTriggerEvent = optionalTriggeringEvent;
            this.rangeNotificationStart(conditionPath, optionalTriggeringEvent, optionalTriggeringPattern, optionalTriggeringEventPattern, optionalPatternForInclusiveEval);
        }
    }

    @Override
    public EventBean getLastTriggerEvent() {
        return this.lastTriggerEvent;
    }

    private void rangeNotificationStart(IntSeqKey controllerPath, EventBean optionalTriggeringEvent, Map<String, Object> optionalTriggeringPattern, EventBean optionalTriggeringEventPattern, Map<String, Object> optionalPatternForInclusiveEval) {
        ContextControllerConditionNonHA startCondition = this.initTermSvc.mgmtUpdClearStartCondition(controllerPath);
        if (startCondition.isRunning()) {
            startCondition.deactivate();
        }
        List<AgentInstance> agentInstances = this.instantiateAndActivateEndCondition(controllerPath, optionalTriggeringEvent, optionalTriggeringPattern, optionalPatternForInclusiveEval, startCondition);
        this.installFilterFaultHandler(agentInstances, controllerPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rangeNotificationEnd(IntSeqKey conditionPath, ContextControllerConditionNonHA endCondition, EventBean optionalTriggeringEvent, Map<String, Object> optionalTriggeringPattern, EventBean optionalTriggeringEventPattern) {
        ContextControllerInitTermSvcEntry instance;
        if (endCondition.isRunning()) {
            endCondition.deactivate();
        }
        if ((instance = this.initTermSvc.endDelete(conditionPath)) == null) {
            return;
        }
        boolean startNow = this.factory.getInitTermSpec().getStartCondition() instanceof ContextConditionDescriptorImmediate;
        ArrayList<AgentInstance> agentInstancesLocksHeld = null;
        if (startNow) {
            this.realization.getAgentInstanceContextCreate().getFilterService().acquireWriteLock();
            agentInstancesLocksHeld = new ArrayList<AgentInstance>(2);
        }
        this.realization.contextPartitionTerminate(conditionPath.removeFromEnd(), instance.getSubpathIdOrCPId(), this, optionalTriggeringPattern, startNow, agentInstancesLocksHeld);
        try {
            IntSeqKey controllerPath = conditionPath.removeFromEnd();
            Object[] partitionKeys = this.initTermSvc.mgmtGetParentPartitionKeys(controllerPath);
            ContextConditionDescriptor startDesc = this.factory.initTermSpec.getStartCondition();
            ContextControllerConditionNonHA startCondition = ContextControllerConditionFactory.getEndpoint(controllerPath, partitionKeys, startDesc, this, this, true);
            if (!startCondition.isImmediate()) {
                startCondition.activate(optionalTriggeringEvent, null, optionalTriggeringPattern);
                this.initTermSvc.mgmtUpdSetStartCondition(controllerPath, startCondition);
            } else {
                this.instantiateAndActivateEndCondition(controllerPath, null, null, null, startCondition);
            }
        }
        finally {
            if (agentInstancesLocksHeld != null) {
                for (AgentInstance agentInstance : agentInstancesLocksHeld) {
                    agentInstance.getAgentInstanceContext().getEpStatementAgentInstanceHandle().getStatementFilterVersion().setStmtFilterVersion(Long.MAX_VALUE);
                    if (agentInstance.getAgentInstanceContext().getStatementContext().getEpStatementHandle().isHasTableAccess()) {
                        agentInstance.getAgentInstanceContext().getTableExprEvaluatorContext().releaseAcquiredLocks();
                    }
                    agentInstance.getAgentInstanceContext().getAgentInstanceLock().releaseWriteLock();
                }
            }
            if (startNow) {
                this.realization.getAgentInstanceContextCreate().getFilterService().releaseWriteLock();
            }
        }
    }

    private void installFilterFaultHandler(List<AgentInstance> agentInstances, IntSeqKey controllerPath) {
        if (agentInstances.isEmpty()) {
            return;
        }
        if (!(this.factory.getInitTermSpec().getStartCondition() instanceof ContextConditionDescriptorFilter)) {
            return;
        }
        NonOverlapWFIlterStartFilterFaultHandler myFaultHandler = new NonOverlapWFIlterStartFilterFaultHandler(this);
        for (AgentInstance agentInstance : agentInstances) {
            agentInstance.getAgentInstanceContext().getEpStatementAgentInstanceHandle().setFilterFaultHandler(myFaultHandler);
        }
    }

    public static class NonOverlapWFIlterStartFilterFaultHandler
    implements FilterFaultHandler {
        private final ContextControllerInitTermWLastTrigger contextControllerInitTerm;

        public NonOverlapWFIlterStartFilterFaultHandler(ContextControllerInitTermWLastTrigger contextControllerInitTerm) {
            this.contextControllerInitTerm = contextControllerInitTerm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean handleFilterFault(EventBean theEvent, long version) {
            AgentInstanceContext aiCreate = this.contextControllerInitTerm.getRealization().getAgentInstanceContextCreate();
            StatementAgentInstanceLock lock = aiCreate.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock();
            lock.acquireWriteLock();
            try {
                EventBean trigger = this.contextControllerInitTerm.getLastTriggerEvent();
                if (theEvent != trigger) {
                    AgentInstanceUtil.evaluateEventForStatement(theEvent, null, Collections.singletonList(new AgentInstance(null, aiCreate, null)), aiCreate);
                }
                boolean bl = true;
                return bl;
            }
            finally {
                lock.releaseWriteLock();
            }
        }
    }
}

