/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.controller.keyed;

import com.espertech.esper.common.internal.collection.IntSeqKey;
import com.espertech.esper.common.internal.context.controller.core.ContextControllerFilterEntry;
import com.espertech.esper.common.internal.context.controller.keyed.ContextControllerDetailKeyedItem;
import com.espertech.esper.common.internal.context.controller.keyed.ContextControllerKeyedImpl;
import com.espertech.esper.common.internal.context.mgr.ContextManagerUtil;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceTransferServices;
import com.espertech.esper.common.internal.context.util.EPStatementHandleCallbackFilter;
import com.espertech.esper.common.internal.filterspec.FilterSpecActivatable;
import com.espertech.esper.common.internal.filterspec.FilterValueSetParam;
import com.espertech.esper.common.internal.filtersvc.FilterHandleCallback;

public abstract class ContextControllerKeyedFilterEntry
implements FilterHandleCallback,
ContextControllerFilterEntry {
    protected final ContextControllerKeyedImpl callback;
    protected final IntSeqKey controllerPath;
    protected final ContextControllerDetailKeyedItem item;
    protected final Object[] parentPartitionKeys;
    protected EPStatementHandleCallbackFilter filterHandle;
    protected FilterValueSetParam[][] filterValueSet;

    public ContextControllerKeyedFilterEntry(ContextControllerKeyedImpl callback, IntSeqKey controllerPath, ContextControllerDetailKeyedItem item, Object[] parentPartitionKeys) {
        this.callback = callback;
        this.controllerPath = controllerPath;
        this.item = item;
        this.parentPartitionKeys = parentPartitionKeys;
    }

    public abstract void destroy();

    protected void start(FilterSpecActivatable activatable) {
        if (this.filterHandle != null) {
            throw new IllegalStateException("Already started");
        }
        AgentInstanceContext agentInstanceContext = this.callback.getAgentInstanceContextCreate();
        this.filterHandle = new EPStatementHandleCallbackFilter(agentInstanceContext.getEpStatementAgentInstanceHandle(), this);
        FilterValueSetParam[][] addendum = ContextManagerUtil.computeAddendumNonStmt(this.parentPartitionKeys, activatable, this.callback.getRealization());
        this.filterValueSet = activatable.getValueSet(null, addendum, agentInstanceContext, agentInstanceContext.getStatementContextFilterEvalEnv());
        agentInstanceContext.getFilterService().add(activatable.getFilterForEventType(), this.filterValueSet, this.filterHandle);
        long filtersVersion = agentInstanceContext.getFilterService().getFiltersVersion();
        agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementFilterVersion().setStmtFilterVersion(filtersVersion);
    }

    protected void stop(FilterSpecActivatable activatable) {
        if (this.filterHandle == null) {
            return;
        }
        AgentInstanceContext agentInstanceContext = this.callback.getAgentInstanceContextCreate();
        agentInstanceContext.getFilterService().remove(this.filterHandle, activatable.getFilterForEventType(), this.filterValueSet);
        long filtersVersion = agentInstanceContext.getFilterService().getFiltersVersion();
        agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementFilterVersion().setStmtFilterVersion(filtersVersion);
        this.filterHandle = null;
        this.filterValueSet = null;
    }

    @Override
    public boolean isSubSelect() {
        return false;
    }

    public int getStatementId() {
        return this.callback.getAgentInstanceContextCreate().getStatementContext().getStatementId();
    }

    @Override
    public EPStatementHandleCallbackFilter getFilterHandle() {
        return this.filterHandle;
    }

    @Override
    public void transfer(FilterSpecActivatable activatable, AgentInstanceTransferServices xfer) {
        xfer.getAgentInstanceContext().getFilterService().remove(this.filterHandle, activatable.getFilterForEventType(), this.filterValueSet);
        xfer.getTargetFilterService().add(activatable.getFilterForEventType(), this.filterValueSet, this.filterHandle);
    }
}

