/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.controller.keyed;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.IntSeqKey;
import com.espertech.esper.common.internal.context.controller.condition.ContextConditionDescriptorFilter;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerConditionCallback;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerConditionFactory;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerConditionNonHA;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerEndConditionMatchEventProvider;
import com.espertech.esper.common.internal.context.controller.core.ContextControllerFilterEntry;
import com.espertech.esper.common.internal.context.controller.keyed.ContextControllerDetailKeyedItem;
import com.espertech.esper.common.internal.context.controller.keyed.ContextControllerKeyed;
import com.espertech.esper.common.internal.context.controller.keyed.ContextControllerKeyedFactory;
import com.espertech.esper.common.internal.context.controller.keyed.ContextControllerKeyedFilterEntry;
import com.espertech.esper.common.internal.context.controller.keyed.ContextControllerKeyedFilterEntryNoInit;
import com.espertech.esper.common.internal.context.controller.keyed.ContextControllerKeyedFilterEntryWInit;
import com.espertech.esper.common.internal.context.controller.keyed.ContextControllerKeyedPartitionKeyWInit;
import com.espertech.esper.common.internal.context.controller.keyed.ContextControllerKeyedSvc;
import com.espertech.esper.common.internal.context.controller.keyed.ContextControllerKeyedSvcEntry;
import com.espertech.esper.common.internal.context.controller.keyed.ContextControllerKeyedUtil;
import com.espertech.esper.common.internal.context.mgr.ContextManagerRealization;
import com.espertech.esper.common.internal.context.mgr.ContextPartitionInstantiationResult;
import com.espertech.esper.common.internal.context.util.AgentInstance;
import com.espertech.esper.common.internal.context.util.AgentInstanceTransferServices;
import com.espertech.esper.common.internal.context.util.AgentInstanceUtil;
import com.espertech.esper.common.internal.context.util.FilterFaultHandler;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public class ContextControllerKeyedImpl
extends ContextControllerKeyed {
    protected final ContextControllerKeyedSvc keyedSvc;

    public ContextControllerKeyedImpl(ContextControllerKeyedFactory factory, ContextManagerRealization realization) {
        super(realization, factory);
        this.keyedSvc = ContextControllerKeyedUtil.getService(factory, realization);
    }

    @Override
    public void activate(IntSeqKey path, Object[] parentPartitionKeys, EventBean optionalTriggeringEvent, Map<String, Object> optionalTriggeringPattern) {
        this.keyedSvc.mgmtCreate(path, parentPartitionKeys);
        ContextControllerFilterEntry[] filterEntries = this.activateFilters(optionalTriggeringEvent, path, parentPartitionKeys);
        this.keyedSvc.mgmtSetFilters(path, filterEntries);
    }

    @Override
    public void deactivate(IntSeqKey path, boolean terminateChildContexts) {
        ContextControllerFilterEntry[] filters;
        if (path.length() != this.factory.getFactoryEnv().getNestingLevel() - 1) {
            throw new IllegalStateException("Unrecognized controller path");
        }
        for (ContextControllerFilterEntry callback : filters = this.keyedSvc.mgmtGetFilters(path)) {
            ((ContextControllerKeyedFilterEntry)callback).destroy();
        }
        if (this.factory.getKeyedSpec().getOptionalTermination() != null) {
            List<ContextControllerConditionNonHA> terminationConditions = this.keyedSvc.keyGetTermConditions(path);
            for (ContextControllerConditionNonHA condition : terminationConditions) {
                condition.deactivate();
            }
        }
        Collection<Integer> subpaths = this.keyedSvc.deactivate(path);
        if (terminateChildContexts) {
            for (int subpathId : subpaths) {
                this.realization.contextPartitionTerminate(path, subpathId, this, null, false, null);
            }
        }
    }

    public void matchFound(ContextControllerDetailKeyedItem item, EventBean theEvent, IntSeqKey controllerPath, String optionalInitCondAsName) {
        if (controllerPath.length() != this.factory.getFactoryEnv().getNestingLevel() - 1) {
            throw new IllegalStateException("Unrecognized controller path");
        }
        Object getterKey = item.getGetter().get(theEvent);
        boolean exists = this.keyedSvc.keyHasSeen(controllerPath, getterKey);
        if (exists || theEvent == this.lastTerminatingEvent) {
            return;
        }
        this.lastTerminatingEvent = null;
        Object partitionKey = getterKey;
        if (this.factory.keyedSpec.isHasAsName()) {
            partitionKey = new ContextControllerKeyedPartitionKeyWInit(getterKey, optionalInitCondAsName, optionalInitCondAsName == null ? null : theEvent);
        }
        Object[] parentPartitionKeys = this.keyedSvc.mgmtGetPartitionKeys(controllerPath);
        int subpathId = this.keyedSvc.mgmtGetIncSubpath(controllerPath);
        ContextPartitionInstantiationResult result = this.realization.contextPartitionInstantiate(controllerPath, subpathId, this, theEvent, null, parentPartitionKeys, partitionKey);
        int subpathIdOrCPId = result.getSubpathOrCPId();
        ContextControllerConditionNonHA terminationCondition = null;
        if (this.factory.getKeyedSpec().getOptionalTermination() != null) {
            IntSeqKey conditionPath = controllerPath.addToEnd(subpathIdOrCPId);
            terminationCondition = this.activateTermination(theEvent, parentPartitionKeys, partitionKey, conditionPath, optionalInitCondAsName);
            for (AgentInstance agentInstance : result.getAgentInstances()) {
                agentInstance.getAgentInstanceContext().getEpStatementAgentInstanceHandle().setFilterFaultHandler(ContextControllerWTerminationFilterFaultHandler.INSTANCE);
            }
        }
        this.keyedSvc.keyAdd(controllerPath, getterKey, subpathIdOrCPId, terminationCondition);
        long filterVersionAfterStart = this.realization.getAgentInstanceContextCreate().getFilterService().getFiltersVersion();
        this.realization.getAgentInstanceContextCreate().getEpStatementAgentInstanceHandle().getStatementFilterVersion().setStmtFilterVersion(filterVersionAfterStart);
    }

    @Override
    protected void visitPartitions(IntSeqKey controllerPath, BiConsumer<Object, Integer> keyAndSubpathOrCPId) {
        this.keyedSvc.keyVisit(controllerPath, keyAndSubpathOrCPId);
    }

    @Override
    protected int getSubpathOrCPId(IntSeqKey path, Object keyForLookup) {
        return this.keyedSvc.keyGetSubpathOrCPId(path, keyForLookup);
    }

    @Override
    public void destroy() {
        this.keyedSvc.destroy();
    }

    private ContextControllerConditionNonHA activateTermination(EventBean triggeringEvent, Object[] parentPartitionKeys, final Object partitionKey, IntSeqKey conditionPath, final String optionalInitCondAsName) {
        ContextControllerConditionCallback callback = new ContextControllerConditionCallback(){

            @Override
            public void rangeNotification(IntSeqKey conditionPath, ContextControllerConditionNonHA originEndpoint, EventBean optionalTriggeringEvent, Map<String, Object> optionalTriggeringPattern, EventBean optionalTriggeringEventPattern, Map<String, Object> optionalPatternForInclusiveEval) {
                Object getterKey;
                IntSeqKey parentPath = conditionPath.removeFromEnd();
                ContextControllerKeyedSvcEntry removed = ContextControllerKeyedImpl.this.keyedSvc.keyRemove(parentPath, getterKey = ContextControllerKeyedImpl.this.factory.getGetterKey(partitionKey));
                if (removed == null) {
                    return;
                }
                ContextControllerKeyedImpl.this.lastTerminatingEvent = optionalTriggeringEvent != null ? optionalTriggeringEvent : optionalTriggeringEventPattern;
                ContextControllerKeyedImpl.this.realization.contextPartitionTerminate(conditionPath.removeFromEnd(), removed.getSubpathOrCPId(), ContextControllerKeyedImpl.this, optionalTriggeringPattern, false, null);
                removed.getTerminationCondition().deactivate();
            }
        };
        Object[] partitionKeys = CollectionUtil.addValue(parentPartitionKeys, partitionKey);
        ContextControllerConditionNonHA terminationCondition = ContextControllerConditionFactory.getEndpoint(conditionPath, partitionKeys, this.factory.keyedSpec.getOptionalTermination(), callback, this, false);
        ContextControllerEndConditionMatchEventProvider endConditionMatchEventProvider = null;
        if (optionalInitCondAsName != null) {
            endConditionMatchEventProvider = new ContextControllerEndConditionMatchEventProvider(){

                @Override
                public void populateEndConditionFromTrigger(MatchedEventMap map, EventBean triggeringEvent) {
                    ContextControllerKeyedUtil.populatePriorMatch(optionalInitCondAsName, map, triggeringEvent);
                }

                @Override
                public void populateEndConditionFromTrigger(MatchedEventMap map, Map<String, Object> triggeringPattern) {
                }
            };
        }
        terminationCondition.activate(triggeringEvent, endConditionMatchEventProvider, null);
        return terminationCondition;
    }

    private ContextControllerFilterEntry[] activateFilters(EventBean optionalTriggeringEvent, IntSeqKey controllerPath, Object[] parentPartitionKeys) {
        ContextConditionDescriptorFilter[] optionalInit = this.factory.getKeyedSpec().getOptionalInit();
        if (optionalInit == null || optionalInit.length == 0) {
            return this.activateFiltersFromPartitionKeys(optionalTriggeringEvent, controllerPath, parentPartitionKeys);
        }
        return this.activateFiltersFromInit(optionalTriggeringEvent, controllerPath, parentPartitionKeys);
    }

    private ContextControllerFilterEntry[] activateFiltersFromInit(EventBean optionalTriggeringEvent, IntSeqKey controllerPath, Object[] parentPartitionKeys) {
        ContextConditionDescriptorFilter[] inits = this.factory.getKeyedSpec().getOptionalInit();
        ContextControllerFilterEntry[] filterEntries = new ContextControllerFilterEntry[inits.length];
        for (int i = 0; i < inits.length; ++i) {
            ContextConditionDescriptorFilter init = inits[i];
            ContextControllerDetailKeyedItem found = ContextControllerKeyedUtil.findInitMatchingKey(this.factory.getKeyedSpec().getItems(), init);
            filterEntries[i] = this.activateFilterWithInit(init, found, optionalTriggeringEvent, controllerPath, parentPartitionKeys);
        }
        return filterEntries;
    }

    private ContextControllerFilterEntry[] activateFiltersFromPartitionKeys(EventBean optionalTriggeringEvent, IntSeqKey controllerPath, Object[] parentPartitionKeys) {
        ContextControllerDetailKeyedItem[] items = this.factory.getKeyedSpec().getItems();
        ContextControllerFilterEntry[] filterEntries = new ContextControllerFilterEntry[items.length];
        for (int i = 0; i < items.length; ++i) {
            filterEntries[i] = this.activateFilterNoInit(items[i], optionalTriggeringEvent, controllerPath, parentPartitionKeys);
        }
        return filterEntries;
    }

    private ContextControllerFilterEntry activateFilterNoInit(ContextControllerDetailKeyedItem item, EventBean optionalTriggeringEvent, IntSeqKey controllerPath, Object[] parentPartitionKeys) {
        boolean match;
        ContextControllerKeyedFilterEntryNoInit callback = new ContextControllerKeyedFilterEntryNoInit(this, controllerPath, parentPartitionKeys, item);
        if (optionalTriggeringEvent != null && (match = AgentInstanceUtil.evaluateFilterForStatement(optionalTriggeringEvent, this.realization.getAgentInstanceContextCreate(), callback.getFilterHandle()))) {
            callback.matchFound(optionalTriggeringEvent, null);
        }
        return callback;
    }

    private ContextControllerFilterEntry activateFilterWithInit(ContextConditionDescriptorFilter filter, ContextControllerDetailKeyedItem item, EventBean optionalTriggeringEvent, IntSeqKey controllerPath, Object[] parentPartitionKeys) {
        return new ContextControllerKeyedFilterEntryWInit(this, controllerPath, item, parentPartitionKeys, filter);
    }

    @Override
    public void transfer(IntSeqKey path, boolean transferChildContexts, AgentInstanceTransferServices xfer) {
        ContextControllerFilterEntry[] filters = this.keyedSvc.mgmtGetFilters(path);
        for (int i = 0; i < this.factory.getKeyedSpec().getItems().length; ++i) {
            ContextControllerDetailKeyedItem item = this.factory.getKeyedSpec().getItems()[i];
            filters[i].transfer(item.getFilterSpecActivatable(), xfer);
        }
        if (this.factory.getKeyedSpec().getOptionalTermination() != null) {
            this.keyedSvc.keyVisitEntry(path, entry -> entry.getTerminationCondition().transfer(xfer));
        }
        if (!transferChildContexts) {
            return;
        }
        this.keyedSvc.keyVisit(path, (partitionKey, subpathId) -> this.realization.transferRecursive(path, (int)subpathId, this, xfer));
    }

    public static class ContextControllerWTerminationFilterFaultHandler
    implements FilterFaultHandler {
        public static final FilterFaultHandler INSTANCE = new ContextControllerWTerminationFilterFaultHandler();

        private ContextControllerWTerminationFilterFaultHandler() {
        }

        @Override
        public boolean handleFilterFault(EventBean theEvent, long version) {
            return true;
        }
    }
}

