/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.controller.keyed;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventPropertyGetter;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.meta.EventTypeTypeClass;
import com.espertech.esper.common.client.util.MultiKey;
import com.espertech.esper.common.client.util.StatementType;
import com.espertech.esper.common.internal.collection.MultiKeyArrayWrap;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyPlanner;
import com.espertech.esper.common.internal.compile.stage1.spec.ContextSpecKeyed;
import com.espertech.esper.common.internal.compile.stage1.spec.ContextSpecKeyedItem;
import com.espertech.esper.common.internal.context.aifactory.createwindow.StatementAgentInstanceFactoryCreateNW;
import com.espertech.esper.common.internal.context.controller.condition.ContextConditionDescriptorFilter;
import com.espertech.esper.common.internal.context.controller.keyed.ContextControllerDetailKeyed;
import com.espertech.esper.common.internal.context.controller.keyed.ContextControllerDetailKeyedItem;
import com.espertech.esper.common.internal.context.controller.keyed.ContextControllerKeyedFactory;
import com.espertech.esper.common.internal.context.controller.keyed.ContextControllerKeyedSvc;
import com.espertech.esper.common.internal.context.controller.keyed.ContextControllerKeyedSvcLevelAny;
import com.espertech.esper.common.internal.context.controller.keyed.ContextControllerKeyedSvcLevelOne;
import com.espertech.esper.common.internal.context.mgr.ContextControllerStatementDesc;
import com.espertech.esper.common.internal.context.mgr.ContextManagerRealization;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.StatementContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterSpecLookupable;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.filterspec.FilterAddendumUtil;
import com.espertech.esper.common.internal.filterspec.FilterOperator;
import com.espertech.esper.common.internal.filterspec.FilterSpecActivatable;
import com.espertech.esper.common.internal.filterspec.FilterValueSetParam;
import com.espertech.esper.common.internal.filterspec.FilterValueSetParamImpl;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.Map;

public class ContextControllerKeyedUtil {
    public static Object[] unpackKey(Object key) {
        if (key instanceof MultiKey) {
            return MultiKey.toObjectArray((MultiKey)key);
        }
        if (key instanceof MultiKeyArrayWrap) {
            return new Object[]{((MultiKeyArrayWrap)key).getArray()};
        }
        return new Object[]{key};
    }

    protected static ContextControllerKeyedSvc getService(ContextControllerKeyedFactory factory, ContextManagerRealization realization) {
        if (factory.getFactoryEnv().isRoot()) {
            return new ContextControllerKeyedSvcLevelOne();
        }
        return new ContextControllerKeyedSvcLevelAny();
    }

    protected static Class[] validateContextDesc(String contextName, ContextSpecKeyed partitionSpec) throws ExprValidationException {
        if (partitionSpec.getItems().isEmpty()) {
            throw new ExprValidationException("Empty list of partition items");
        }
        for (ContextSpecKeyedItem item : partitionSpec.getItems()) {
            EventType type = item.getFilterSpecCompiled().getFilterForEventType();
            for (String property : item.getPropertyNames()) {
                EventPropertyGetter getter = type.getGetter(property);
                if (getter != null) continue;
                throw new ExprValidationException("For context '" + contextName + "' property name '" + property + "' not found on type " + type.getName());
            }
        }
        ContextSpecKeyedItem firstItem = partitionSpec.getItems().get(0);
        if (partitionSpec.getItems().size() > 1) {
            for (int i = 0; i < partitionSpec.getItems().size(); ++i) {
                EventType compareTo = partitionSpec.getItems().get(i).getFilterSpecCompiled().getFilterForEventType();
                for (int j = 0; j < partitionSpec.getItems().size(); ++j) {
                    if (i == j) continue;
                    EventType compareFrom = partitionSpec.getItems().get(j).getFilterSpecCompiled().getFilterForEventType();
                    if (compareFrom == compareTo) {
                        throw new ExprValidationException("For context '" + contextName + "' the event type '" + compareFrom.getName() + "' is listed twice");
                    }
                    if (!EventTypeUtility.isTypeOrSubTypeOf(compareFrom, compareTo) && !EventTypeUtility.isTypeOrSubTypeOf(compareTo, compareFrom)) continue;
                    throw new ExprValidationException("For context '" + contextName + "' the event type '" + compareFrom.getName() + "' is listed twice: Event type '" + compareFrom.getName() + "' is a subtype or supertype of event type '" + compareTo.getName() + "'");
                }
            }
            String[] names = new String[firstItem.getPropertyNames().size()];
            Class[] types = new Class[firstItem.getPropertyNames().size()];
            Class[] typesBoxed = new Class[firstItem.getPropertyNames().size()];
            for (int i = 0; i < firstItem.getPropertyNames().size(); ++i) {
                String property;
                names[i] = property = firstItem.getPropertyNames().get(i);
                types[i] = firstItem.getFilterSpecCompiled().getFilterForEventType().getPropertyType(property);
                typesBoxed[i] = JavaClassHelper.getBoxedType(types[i]);
            }
            for (int item = 1; item < partitionSpec.getItems().size(); ++item) {
                ContextSpecKeyedItem nextItem = partitionSpec.getItems().get(item);
                if (nextItem.getPropertyNames().size() != types.length) {
                    throw new ExprValidationException("For context '" + contextName + "' expected the same number of property names for each event type, found " + types.length + " properties for event type '" + firstItem.getFilterSpecCompiled().getFilterForEventType().getName() + "' and " + nextItem.getPropertyNames().size() + " properties for event type '" + nextItem.getFilterSpecCompiled().getFilterForEventType().getName() + "'");
                }
                for (int i = 0; i < nextItem.getPropertyNames().size(); ++i) {
                    String property = nextItem.getPropertyNames().get(i);
                    Class type = JavaClassHelper.getBoxedType(nextItem.getFilterSpecCompiled().getFilterForEventType().getPropertyType(property));
                    Class typeBoxed = JavaClassHelper.getBoxedType(type);
                    boolean left = JavaClassHelper.isSubclassOrImplementsInterface(typeBoxed, typesBoxed[i]);
                    boolean right = JavaClassHelper.isSubclassOrImplementsInterface(typesBoxed[i], typeBoxed);
                    if (typeBoxed == typesBoxed[i] || left || right) continue;
                    throw new ExprValidationException("For context '" + contextName + "' for context '" + contextName + "' found mismatch of property types, property '" + names[i] + "' of type '" + JavaClassHelper.getClassNameFullyQualPretty(types[i]) + "' compared to property '" + property + "' of type '" + JavaClassHelper.getClassNameFullyQualPretty(typeBoxed) + "'");
                }
            }
        }
        Class[] propertyTypes = new Class[firstItem.getPropertyNames().size()];
        for (int i = 0; i < firstItem.getPropertyNames().size(); ++i) {
            String property = firstItem.getPropertyNames().get(i);
            propertyTypes[i] = firstItem.getFilterSpecCompiled().getFilterForEventType().getPropertyType(property);
        }
        return propertyTypes;
    }

    public static FilterValueSetParam[][] getAddendumFilters(Object getterKey, FilterSpecActivatable filtersSpec, ContextControllerDetailKeyed keyedSpec, boolean includePartition, ContextControllerStatementDesc optionalStatementDesc, Map<Integer, ContextControllerStatementDesc> statements, AgentInstanceContext agentInstanceContext) {
        boolean isCreateWindow = optionalStatementDesc != null && optionalStatementDesc.getLightweight().getStatementContext().getStatementInformationals().getStatementType() == StatementType.CREATE_WINDOW;
        ContextControllerDetailKeyedItem foundPartition = null;
        if (!isCreateWindow) {
            if (filtersSpec.getFilterForEventType().getMetadata().getTypeClass() == EventTypeTypeClass.NAMED_WINDOW) {
                String string = ContextControllerKeyedUtil.findNamedWindowDeclaredAsName(statements, filtersSpec.getFilterForEventType().getMetadata().getName());
                ContextControllerDetailKeyedItem[] contextControllerDetailKeyedItemArray = keyedSpec.getItems();
                int n = contextControllerDetailKeyedItemArray.length;
                for (int i = 0; i < n; ++i) {
                    ContextControllerDetailKeyedItem partitionItem = contextControllerDetailKeyedItemArray[i];
                    if (!partitionItem.getFilterSpecActivatable().getFilterForEventType().getName().equals(string)) continue;
                    foundPartition = partitionItem;
                    break;
                }
            }
            if (foundPartition == null) {
                for (ContextControllerDetailKeyedItem partitionItem : keyedSpec.getItems()) {
                    boolean typeOrSubtype = EventTypeUtility.isTypeOrSubTypeOf(filtersSpec.getFilterForEventType(), partitionItem.getFilterSpecActivatable().getFilterForEventType());
                    if (!typeOrSubtype) continue;
                    foundPartition = partitionItem;
                    break;
                }
            }
        } else {
            StatementAgentInstanceFactoryCreateNW statementAgentInstanceFactoryCreateNW = (StatementAgentInstanceFactoryCreateNW)optionalStatementDesc.getLightweight().getStatementContext().getStatementAIFactoryProvider().getFactory();
            String declaredAsName = statementAgentInstanceFactoryCreateNW.getAsEventTypeName();
            for (ContextControllerDetailKeyedItem partitionItem : keyedSpec.getItems()) {
                if (!partitionItem.getFilterSpecActivatable().getFilterForEventType().getName().equals(declaredAsName)) continue;
                foundPartition = partitionItem;
                break;
            }
        }
        if (foundPartition == null) {
            return null;
        }
        ExprFilterSpecLookupable[] exprFilterSpecLookupableArray = foundPartition.getLookupables();
        FilterValueSetParam[] addendumFilters = new FilterValueSetParam[exprFilterSpecLookupableArray.length];
        if (exprFilterSpecLookupableArray.length == 1) {
            addendumFilters[0] = ContextControllerKeyedUtil.getFilterMayEqualOrNull(exprFilterSpecLookupableArray[0], getterKey);
        } else {
            MultiKey keyProvisioning = (MultiKey)getterKey;
            for (int i = 0; i < exprFilterSpecLookupableArray.length; ++i) {
                addendumFilters[i] = ContextControllerKeyedUtil.getFilterMayEqualOrNull(exprFilterSpecLookupableArray[i], keyProvisioning.getKey(i));
            }
        }
        FilterValueSetParam[][] addendum = new FilterValueSetParam[][]{addendumFilters};
        FilterValueSetParam[][] partitionFilters = foundPartition.getFilterSpecActivatable().getValueSet(null, null, agentInstanceContext, agentInstanceContext.getStatementContextFilterEvalEnv());
        if (partitionFilters != null && includePartition) {
            addendum = FilterAddendumUtil.addAddendum(partitionFilters, addendum[0]);
        }
        return addendum;
    }

    private static String findNamedWindowDeclaredAsName(Map<Integer, ContextControllerStatementDesc> statements, String name) {
        for (Map.Entry<Integer, ContextControllerStatementDesc> stmtEntry : statements.entrySet()) {
            StatementAgentInstanceFactoryCreateNW factory;
            StatementContext ctx = stmtEntry.getValue().getLightweight().getStatementContext();
            if (ctx.getStatementType() != StatementType.CREATE_WINDOW || !(factory = (StatementAgentInstanceFactoryCreateNW)ctx.getStatementAIFactoryProvider().getFactory()).getStatementEventType().getName().equals(name)) continue;
            return factory.getAsEventTypeName();
        }
        return null;
    }

    public static ContextControllerDetailKeyedItem findInitMatchingKey(ContextControllerDetailKeyedItem[] items, ContextConditionDescriptorFilter init) {
        ContextControllerDetailKeyedItem found = null;
        for (ContextControllerDetailKeyedItem item : items) {
            if (item.getFilterSpecActivatable().getFilterForEventType() != init.getFilterSpecActivatable().getFilterForEventType()) continue;
            found = item;
            break;
        }
        if (found == null) {
            throw new IllegalArgumentException("Failed to find matching partition for type '" + init.getFilterSpecActivatable().getFilterForEventType());
        }
        return found;
    }

    private static FilterValueSetParam getFilterMayEqualOrNull(ExprFilterSpecLookupable lookupable, Object keyValue) {
        if (keyValue != null && keyValue.getClass().isArray()) {
            keyValue = MultiKeyPlanner.toMultiKey(keyValue);
        }
        return new FilterValueSetParamImpl(lookupable, FilterOperator.IS, keyValue);
    }

    public static void populatePriorMatch(String optionalInitCondAsName, MatchedEventMap matchedEventMap, EventBean triggeringEvent) {
        int tag = matchedEventMap.getMeta().getTagFor(optionalInitCondAsName);
        if (tag == -1) {
            return;
        }
        matchedEventMap.add(tag, triggeringEvent);
    }
}

