/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.mgr;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.collection.PathRegistry;
import com.espertech.esper.common.internal.context.compile.ContextMetaData;
import com.espertech.esper.common.internal.util.StringValue;

public class ContextDeployTimeResolver {
    public static String resolveContextDeploymentId(String contextModuleName, NameAccessModifier contextVisibility, String contextName, String myDeploymentId, PathRegistry<String, ContextMetaData> pathContextRegistry) {
        boolean protectedVisibility = contextVisibility == NameAccessModifier.PRIVATE;
        String contextDeploymentId = protectedVisibility ? myDeploymentId : pathContextRegistry.getDeploymentId(contextName, contextModuleName);
        if (contextDeploymentId == null) {
            throw ContextDeployTimeResolver.failedToFind(contextModuleName, contextVisibility, contextName);
        }
        return contextDeploymentId;
    }

    public static EPException failedToFind(String contextModuleName, NameAccessModifier visibility, String contextName) {
        boolean protectedVisibility = visibility == NameAccessModifier.PRIVATE;
        String message = "Failed find to context '" + contextName + "'";
        if (!protectedVisibility) {
            message = message + " module name '" + StringValue.unnamedWhenNullOrEmpty(contextModuleName) + "'";
        }
        return new EPException(message);
    }
}

