/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.mgr;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.context.ContextPartitionIdentifier;
import com.espertech.esper.common.client.context.ContextPartitionSelector;
import com.espertech.esper.common.client.context.ContextPartitionSelectorAll;
import com.espertech.esper.common.client.context.ContextPartitionSelectorById;
import com.espertech.esper.common.client.context.ContextPartitionSelectorNested;
import com.espertech.esper.common.client.context.ContextPartitionStateListener;
import com.espertech.esper.common.client.context.ContextStateEventContextPartitionAllocated;
import com.espertech.esper.common.client.context.ContextStateEventContextPartitionDeallocated;
import com.espertech.esper.common.internal.collection.IntSeqKey;
import com.espertech.esper.common.internal.collection.IntSeqKeyRoot;
import com.espertech.esper.common.internal.context.controller.core.ContextController;
import com.espertech.esper.common.internal.context.controller.core.ContextControllerFactory;
import com.espertech.esper.common.internal.context.controller.core.ContextControllerFactoryEnv;
import com.espertech.esper.common.internal.context.controller.core.ContextControllerLifecycleCallback;
import com.espertech.esper.common.internal.context.mgr.ContextControllerSelectorUtil;
import com.espertech.esper.common.internal.context.mgr.ContextControllerStatementDesc;
import com.espertech.esper.common.internal.context.mgr.ContextManagerResident;
import com.espertech.esper.common.internal.context.mgr.ContextManagerUtil;
import com.espertech.esper.common.internal.context.mgr.ContextPartitionInstantiationResult;
import com.espertech.esper.common.internal.context.mgr.ContextPartitionVisitor;
import com.espertech.esper.common.internal.context.mgr.ContextPartitionVisitorAgentInstanceId;
import com.espertech.esper.common.internal.context.mgr.ContextStateEventUtil;
import com.espertech.esper.common.internal.context.util.AgentInstance;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceFilterProxyImpl;
import com.espertech.esper.common.internal.context.util.AgentInstanceTransferServices;
import com.espertech.esper.common.internal.context.util.AgentInstanceUtil;
import com.espertech.esper.common.internal.context.util.FilterFaultHandler;
import com.espertech.esper.common.internal.context.util.StatementContext;
import com.espertech.esper.common.internal.event.core.MappedEventBean;
import com.espertech.esper.common.internal.filterspec.FilterSpecActivatable;
import com.espertech.esper.common.internal.filterspec.FilterValueSetParam;
import com.espertech.esper.common.internal.statement.resource.StatementResourceHolder;
import com.espertech.esper.common.internal.statement.resource.StatementResourceService;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextManagerRealization
implements ContextControllerLifecycleCallback,
FilterFaultHandler {
    private static final Logger log = LoggerFactory.getLogger(ContextManagerRealization.class);
    private final ContextManagerResident contextManager;
    private final AgentInstanceContext agentInstanceContextCreate;
    private final ContextController[] contextControllers;

    public ContextManagerRealization(ContextManagerResident contextManager, AgentInstanceContext agentInstanceContextCreate) {
        this.contextManager = contextManager;
        this.agentInstanceContextCreate = agentInstanceContextCreate;
        ContextControllerFactory[] controllerFactories = contextManager.getContextDefinition().getControllerFactories();
        this.contextControllers = new ContextController[controllerFactories.length];
        for (int i = 0; i < controllerFactories.length; ++i) {
            ContextControllerFactory contextControllerFactory = controllerFactories[i];
            this.contextControllers[i] = contextControllerFactory.create(this);
        }
    }

    public ContextController[] getContextControllers() {
        return this.contextControllers;
    }

    public void startContext() {
        this.contextControllers[0].activate(IntSeqKeyRoot.INSTANCE, new Object[0], null, null);
    }

    public void stopContext() {
        this.contextControllers[0].deactivate(IntSeqKeyRoot.INSTANCE, this.contextControllers.length > 1);
    }

    public void safeDestroyContext() {
        for (ContextController controllerPage : this.contextControllers) {
            controllerPage.destroy();
        }
        StatementContext statementContext = this.agentInstanceContextCreate.getStatementContext();
        statementContext.getStatementCPCacheService().clear(statementContext);
    }

    @Override
    public ContextPartitionInstantiationResult contextPartitionInstantiate(IntSeqKey controllerPathId, int subpathId, ContextController originator, EventBean optionalTriggeringEvent, Map<String, Object> optionalPatternForInclusiveEval, Object[] parentPartitionKeys, Object partitionKey) {
        ContextControllerFactoryEnv controllerEnv = originator.getFactory().getFactoryEnv();
        if (controllerPathId.length() != controllerEnv.getNestingLevel() - 1) {
            throw new IllegalStateException("Unexpected controller path");
        }
        if (parentPartitionKeys.length != controllerEnv.getNestingLevel() - 1) {
            throw new IllegalStateException("Unexpected partition key size");
        }
        int nestingLevel = controllerEnv.getNestingLevel();
        if (nestingLevel < this.contextControllers.length) {
            ContextController nextContext = this.contextControllers[nestingLevel];
            Object[] nestedPartitionKeys = this.addPartitionKey(nestingLevel, parentPartitionKeys, partitionKey);
            IntSeqKey childPath = controllerPathId.addToEnd(subpathId);
            nextContext.activate(childPath, nestedPartitionKeys, optionalTriggeringEvent, optionalPatternForInclusiveEval);
            return new ContextPartitionInstantiationResult(subpathId, Collections.emptyList());
        }
        Object[] allPartitionKeys = CollectionUtil.addValue(parentPartitionKeys, partitionKey);
        int assignedContextId = this.contextManager.getContextPartitionIdService().allocateId(allPartitionKeys);
        MappedEventBean contextBean = ContextManagerUtil.buildContextProperties(assignedContextId, allPartitionKeys, this.contextManager.getContextDefinition(), this.agentInstanceContextCreate.getStatementContext());
        ArrayList<AgentInstance> startedInstances = new ArrayList<AgentInstance>(2);
        for (Map.Entry<Integer, ContextControllerStatementDesc> statementEntry : this.contextManager.getStatements().entrySet()) {
            ContextControllerStatementDesc statementDesc = statementEntry.getValue();
            Supplier<IdentityHashMap<FilterSpecActivatable, FilterValueSetParam[][]>> generator = () -> ContextManagerUtil.computeAddendumForStatement(statementDesc, this.contextManager.getStatements(), this.contextManager.getContextDefinition().getControllerFactories(), allPartitionKeys, this.agentInstanceContextCreate);
            AgentInstanceFilterProxyImpl proxy = new AgentInstanceFilterProxyImpl(generator);
            AgentInstance agentInstance = AgentInstanceUtil.startStatement(this.contextManager.getStatementContextCreate().getStatementContextRuntimeServices(), assignedContextId, statementDesc, contextBean, proxy);
            startedInstances.add(agentInstance);
        }
        if (optionalTriggeringEvent != null || optionalPatternForInclusiveEval != null) {
            AgentInstanceUtil.evaluateEventForStatement(optionalTriggeringEvent, optionalPatternForInclusiveEval, startedInstances, this.agentInstanceContextCreate);
        }
        if (this.contextManager.getListenersMayNull() != null) {
            ContextPartitionIdentifier identifier = this.contextManager.getContextPartitionIdentifier(allPartitionKeys);
            ContextStateEventUtil.dispatchPartition(this.contextManager.getListenersMayNull(), () -> new ContextStateEventContextPartitionAllocated(this.agentInstanceContextCreate.getRuntimeURI(), this.contextManager.getContextRuntimeDescriptor().getContextDeploymentId(), this.contextManager.getContextDefinition().getContextName(), assignedContextId, identifier), ContextPartitionStateListener::onContextPartitionAllocated);
        }
        return new ContextPartitionInstantiationResult(assignedContextId, startedInstances);
    }

    @Override
    public void contextPartitionTerminate(IntSeqKey controllerPath, int subpathIdOrCPId, ContextController originator, Map<String, Object> terminationProperties, boolean leaveLocksAcquired, List<AgentInstance> agentInstancesLocksHeld) {
        if (controllerPath.length() != originator.getFactory().getFactoryEnv().getNestingLevel() - 1) {
            throw new IllegalStateException("Unrecognized controller path");
        }
        ContextControllerFactoryEnv controllerEnv = originator.getFactory().getFactoryEnv();
        int nestingLevel = controllerEnv.getNestingLevel();
        if (nestingLevel < this.contextControllers.length) {
            ContextController childController = this.contextControllers[nestingLevel];
            IntSeqKey path = controllerPath.addToEnd(subpathIdOrCPId);
            childController.deactivate(path, true);
            return;
        }
        int agentInstanceId = subpathIdOrCPId;
        ListIterator<ContextControllerStatementDesc> iterator = new ArrayList<ContextControllerStatementDesc>(this.contextManager.getStatements().values()).listIterator(this.contextManager.getStatements().size());
        while (iterator.hasPrevious()) {
            ContextControllerStatementDesc statementDesc = iterator.previous();
            AgentInstanceUtil.contextPartitionTerminate(agentInstanceId, statementDesc, this.contextControllers, terminationProperties, leaveLocksAcquired, agentInstancesLocksHeld);
        }
        for (Map.Entry<Integer, ContextControllerStatementDesc> statementEntry : this.contextManager.getStatements().entrySet()) {
            ContextControllerStatementDesc statementDesc = statementEntry.getValue();
            StatementResourceService svc = statementDesc.getLightweight().getStatementContext().getStatementCPCacheService().getStatementResourceService();
            StatementResourceHolder statementResourceHolder = svc.deallocatePartitioned(agentInstanceId);
        }
        this.contextManager.getContextPartitionIdService().removeId(agentInstanceId);
        if (this.contextManager.getListenersMayNull() != null) {
            ContextStateEventUtil.dispatchPartition(this.contextManager.getListenersMayNull(), () -> new ContextStateEventContextPartitionDeallocated(this.agentInstanceContextCreate.getRuntimeURI(), this.contextManager.getContextRuntimeDescriptor().getContextDeploymentId(), this.contextManager.getContextDefinition().getContextName(), agentInstanceId), ContextPartitionStateListener::onContextPartitionDeallocated);
        }
    }

    public void startLateStatement(ContextControllerStatementDesc statement) {
        Collection<Integer> ids = this.contextManager.getContextPartitionIdService().getIds();
        for (int cpid : ids) {
            Object[] partitionKeys = this.contextManager.getContextPartitionIdService().getPartitionKeys(cpid);
            MappedEventBean contextBean = ContextManagerUtil.buildContextProperties(cpid, partitionKeys, this.contextManager.getContextDefinition(), this.agentInstanceContextCreate.getStatementContext());
            Supplier<IdentityHashMap<FilterSpecActivatable, FilterValueSetParam[][]>> generator = () -> ContextManagerUtil.computeAddendumForStatement(statement, this.contextManager.getStatements(), this.contextManager.getContextDefinition().getControllerFactories(), partitionKeys, this.agentInstanceContextCreate);
            AgentInstanceFilterProxyImpl proxy = new AgentInstanceFilterProxyImpl(generator);
            AgentInstanceUtil.startStatement(this.contextManager.getStatementContextCreate().getStatementContextRuntimeServices(), cpid, statement, contextBean, proxy);
        }
    }

    public AgentInstanceContext getAgentInstanceContextCreate() {
        return this.agentInstanceContextCreate;
    }

    public Collection<Integer> getAgentInstanceIds(ContextPartitionSelector selector) {
        if (selector instanceof ContextPartitionSelectorById) {
            ContextPartitionSelectorById byId = (ContextPartitionSelectorById)selector;
            Set<Integer> ids = byId.getContextPartitionIds();
            if (ids == null || ids.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Integer> agentInstanceIds = new ArrayList<Integer>(ids);
            agentInstanceIds.retainAll(this.contextManager.getContextPartitionIdService().getIds());
            return agentInstanceIds;
        }
        if (selector instanceof ContextPartitionSelectorAll) {
            return this.contextManager.getContextPartitionIdService().getIds();
        }
        if (selector instanceof ContextPartitionSelectorNested) {
            if (this.contextControllers.length == 1) {
                throw ContextControllerSelectorUtil.getInvalidSelector(new Class[]{ContextPartitionSelectorNested.class}, selector, true);
            }
            ContextPartitionSelectorNested nested = (ContextPartitionSelectorNested)selector;
            ContextPartitionVisitorAgentInstanceId visitor = new ContextPartitionVisitorAgentInstanceId(this.contextControllers.length);
            for (ContextPartitionSelector[] stack : nested.getSelectors()) {
                this.contextControllers[0].visitSelectedPartitions(IntSeqKeyRoot.INSTANCE, stack[0], visitor, stack);
            }
            return visitor.getIds();
        }
        if (this.contextControllers.length > 1) {
            throw ContextControllerSelectorUtil.getInvalidSelector(new Class[]{ContextPartitionSelectorAll.class, ContextPartitionSelectorById.class, ContextPartitionSelectorNested.class}, selector, true);
        }
        ContextPartitionVisitorAgentInstanceId visitor = new ContextPartitionVisitorAgentInstanceId(this.contextControllers.length);
        this.contextControllers[0].visitSelectedPartitions(IntSeqKeyRoot.INSTANCE, selector, visitor, new ContextPartitionSelector[]{selector});
        return visitor.getIds();
    }

    public void removeStatement(ContextControllerStatementDesc statementDesc) {
        Collection<Integer> ids = this.contextManager.getContextPartitionIdService().getIds();
        for (Integer id : ids) {
            try {
                AgentInstanceUtil.contextPartitionTerminate(id, statementDesc, this.contextControllers, null, false, null);
            }
            catch (RuntimeException ex) {
                log.error("Failed to terminated context partition: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Override
    public void contextPartitionRecursiveVisit(IntSeqKey controllerPath, int subpathOrAgentInstanceId, ContextController originator, ContextPartitionVisitor visitor, ContextPartitionSelector[] selectorPerLevel) {
        if (controllerPath.length() != originator.getFactory().getFactoryEnv().getNestingLevel() - 1) {
            throw new IllegalStateException("Unrecognized controller path");
        }
        int nestingLevel = originator.getFactory().getFactoryEnv().getNestingLevel();
        if (nestingLevel < this.contextControllers.length) {
            ContextController childController = this.contextControllers[nestingLevel];
            IntSeqKey subPath = controllerPath.addToEnd(subpathOrAgentInstanceId);
            childController.visitSelectedPartitions(subPath, selectorPerLevel[nestingLevel], visitor, selectorPerLevel);
            return;
        }
        visitor.add(subpathOrAgentInstanceId, originator.getFactory().getFactoryEnv().getNestingLevel());
    }

    public ContextManagerResident getContextManager() {
        return this.contextManager;
    }

    public void activateCreateVariableStatement(ContextControllerStatementDesc statement) {
        Collection<Integer> ids = this.contextManager.getContextPartitionIdService().getIds();
        ContextManagerUtil.getAgentInstances(statement, ids);
    }

    @Override
    public boolean handleFilterFault(EventBean theEvent, long version) {
        Collection<Integer> ids = this.contextManager.getContextPartitionIdService().getIds();
        for (Map.Entry<Integer, ContextControllerStatementDesc> stmt : this.contextManager.getStatements().entrySet()) {
            List<AgentInstance> agentInstances = ContextManagerUtil.getAgentInstancesFiltered(stmt.getValue(), ids, agentInstance -> agentInstance.getAgentInstanceContext().getFilterVersionAfterAllocation() >= version);
            AgentInstanceUtil.evaluateEventForStatement(theEvent, null, agentInstances, this.agentInstanceContextCreate);
        }
        return false;
    }

    private Object[] addPartitionKey(int nestingLevel, Object[] parentPartitionKeys, Object partitionKey) {
        Object[] keysPerContext = new Object[nestingLevel];
        if (nestingLevel > 1) {
            System.arraycopy(parentPartitionKeys, 0, keysPerContext, 0, parentPartitionKeys.length);
        }
        keysPerContext[nestingLevel - 1] = partitionKey;
        return keysPerContext;
    }

    public void transfer(AgentInstanceTransferServices xfer) {
        this.contextControllers[0].transfer(IntSeqKeyRoot.INSTANCE, this.contextControllers.length > 1, xfer);
    }

    public void transferRecursive(IntSeqKey controllerPath, int subpathOrAgentInstanceId, ContextController originator, AgentInstanceTransferServices xfer) {
        if (controllerPath.length() != originator.getFactory().getFactoryEnv().getNestingLevel() - 1) {
            throw new IllegalStateException("Unrecognized controller path");
        }
        int nestingLevel = originator.getFactory().getFactoryEnv().getNestingLevel();
        if (nestingLevel >= this.contextControllers.length) {
            return;
        }
        ContextController childController = this.contextControllers[nestingLevel];
        IntSeqKey subPath = controllerPath.addToEnd(subpathOrAgentInstanceId);
        childController.transfer(subPath, nestingLevel < this.contextControllers.length - 1, xfer);
    }
}

