/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.module;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.context.module.ModuleDependenciesRuntime;
import com.espertech.esper.common.internal.context.module.ModuleIndexMeta;
import com.espertech.esper.common.internal.epl.namedwindow.compile.NamedWindowCompileTimeRegistry;
import com.espertech.esper.common.internal.epl.script.core.NameAndParamNum;
import com.espertech.esper.common.internal.epl.script.core.NameParamNumAndModule;
import com.espertech.esper.common.internal.epl.table.compiletime.TableCompileTimeRegistry;
import com.espertech.esper.common.internal.type.NameAndModule;
import java.util.Collection;
import java.util.HashSet;

public class ModuleDependenciesCompileTime {
    private final Collection<NameAndModule> pathEventTypes = new HashSet<NameAndModule>();
    private final Collection<NameAndModule> pathNamedWindows = new HashSet<NameAndModule>();
    private final Collection<NameAndModule> pathTables = new HashSet<NameAndModule>();
    private final Collection<NameAndModule> pathVariables = new HashSet<NameAndModule>();
    private final Collection<NameAndModule> pathContexts = new HashSet<NameAndModule>();
    private final Collection<NameAndModule> pathExpressions = new HashSet<NameAndModule>();
    private final Collection<ModuleIndexMeta> pathIndexes = new HashSet<ModuleIndexMeta>();
    private final Collection<NameParamNumAndModule> pathScripts = new HashSet<NameParamNumAndModule>();
    private final Collection<NameAndModule> pathClasses = new HashSet<NameAndModule>();
    private final Collection<String> publicEventTypes = new HashSet<String>();
    private final Collection<String> publicVariables = new HashSet<String>();

    public void addPathEventType(String eventTypeName, String moduleName) {
        this.pathEventTypes.add(new NameAndModule(eventTypeName, moduleName));
    }

    public void addPathNamedWindow(String namedWindowName, String moduleName) {
        this.pathNamedWindows.add(new NameAndModule(namedWindowName, moduleName));
    }

    public void addPathTable(String tableName, String moduleName) {
        this.pathTables.add(new NameAndModule(tableName, moduleName));
    }

    public void addPathVariable(String variableName, String moduleName) {
        this.pathVariables.add(new NameAndModule(variableName, moduleName));
    }

    public void addPathContext(String contextName, String moduleName) {
        this.pathContexts.add(new NameAndModule(contextName, moduleName));
    }

    public void addPathExpression(String expressionName, String moduleName) {
        this.pathExpressions.add(new NameAndModule(expressionName, moduleName));
    }

    public void addPathScript(NameAndParamNum key, String moduleName) {
        this.pathScripts.add(new NameParamNumAndModule(key.getName(), key.getParamNum(), moduleName));
    }

    public void addPublicEventType(String eventTypeName) {
        this.publicEventTypes.add(eventTypeName);
    }

    public void addPublicVariable(String variableName) {
        this.publicVariables.add(variableName);
    }

    public void addPathClass(String className, String moduleName) {
        this.pathClasses.add(new NameAndModule(className, moduleName));
    }

    public void addPathIndex(boolean namedWindow, String infraName, String infraModuleName, String indexName, String indexModuleName, NamedWindowCompileTimeRegistry namedWindowCompileTimeRegistry, TableCompileTimeRegistry tableCompileTimeRegistry) {
        if (indexName == null) {
            return;
        }
        if (!namedWindow && infraName.equals(indexName)) {
            return;
        }
        if (namedWindow && namedWindowCompileTimeRegistry.getNamedWindows().get(infraName) != null) {
            return;
        }
        if (!namedWindow && tableCompileTimeRegistry.getTables().get(infraName) != null) {
            return;
        }
        this.pathIndexes.add(new ModuleIndexMeta(namedWindow, infraName, infraModuleName, indexName, indexModuleName));
    }

    public CodegenExpression make(CodegenMethodScope parent, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(ModuleDependenciesRuntime.class, this.getClass(), (CodegenScope)classScope);
        method.getBlock().declareVar(ModuleDependenciesRuntime.class, "md", CodegenExpressionBuilder.newInstance(ModuleDependenciesRuntime.class, new CodegenExpression[0])).exprDotMethod(CodegenExpressionBuilder.ref("md"), "setPathEventTypes", NameAndModule.makeArray(this.pathEventTypes)).exprDotMethod(CodegenExpressionBuilder.ref("md"), "setPathNamedWindows", NameAndModule.makeArray(this.pathNamedWindows)).exprDotMethod(CodegenExpressionBuilder.ref("md"), "setPathTables", NameAndModule.makeArray(this.pathTables)).exprDotMethod(CodegenExpressionBuilder.ref("md"), "setPathVariables", NameAndModule.makeArray(this.pathVariables)).exprDotMethod(CodegenExpressionBuilder.ref("md"), "setPathContexts", NameAndModule.makeArray(this.pathContexts)).exprDotMethod(CodegenExpressionBuilder.ref("md"), "setPathExpressions", NameAndModule.makeArray(this.pathExpressions)).exprDotMethod(CodegenExpressionBuilder.ref("md"), "setPathIndexes", ModuleIndexMeta.makeArray(this.pathIndexes)).exprDotMethod(CodegenExpressionBuilder.ref("md"), "setPathScripts", NameParamNumAndModule.makeArray(this.pathScripts)).exprDotMethod(CodegenExpressionBuilder.ref("md"), "setPathClasses", NameAndModule.makeArray(this.pathClasses)).exprDotMethod(CodegenExpressionBuilder.ref("md"), "setPublicEventTypes", CodegenExpressionBuilder.constant(this.publicEventTypes.toArray(new String[this.publicEventTypes.size()]))).exprDotMethod(CodegenExpressionBuilder.ref("md"), "setPublicVariables", CodegenExpressionBuilder.constant(this.publicVariables.toArray(new String[this.publicVariables.size()]))).methodReturn(CodegenExpressionBuilder.ref("md"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }
}

