/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.module;

import com.espertech.esper.common.client.EPCompiled;
import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.internal.collection.PathRegistry;
import com.espertech.esper.common.internal.context.module.ModuleProvider;
import com.espertech.esper.common.internal.context.module.ModuleProviderCLPair;
import com.espertech.esper.common.internal.epl.classprovided.core.ClassProvided;
import com.espertech.esper.common.internal.epl.classprovided.core.ClassProvidedImportClassLoaderFactory;

public class ModuleProviderUtil {
    public static ModuleProviderCLPair analyze(EPCompiled compiled, ClassLoader classLoaderParent, PathRegistry<String, ClassProvided> classProvidedPathRegistry) {
        ModuleProvider moduleResource;
        Class<?> clazz;
        ClassLoader classLoader = ClassProvidedImportClassLoaderFactory.getClassLoader(compiled.getClasses(), classLoaderParent, classProvidedPathRegistry);
        String resourceClassName = compiled.getManifest().getModuleProviderClassName();
        try {
            clazz = classLoader.loadClass(resourceClassName);
        }
        catch (ClassNotFoundException e) {
            throw new EPException(e);
        }
        try {
            moduleResource = (ModuleProvider)clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new EPException(e);
        }
        return new ModuleProviderCLPair(classLoader, moduleResource);
    }
}

