/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.util;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.context.aifactory.update.InternalEventRouterWriter;
import com.espertech.esper.common.internal.context.aifactory.update.InternalEventRouterWriterArrayElement;
import com.espertech.esper.common.internal.context.aifactory.update.InternalEventRouterWriterCurly;
import com.espertech.esper.common.internal.context.util.InternalEventRouterEntry;
import com.espertech.esper.common.internal.context.util.InternalRoutePreprocessView;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.event.core.EventBeanCopyMethod;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationCommon;
import com.espertech.esper.common.internal.statement.resource.StatementResourceHolder;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalEventRouterPreprocessor {
    private static final Logger log = LoggerFactory.getLogger(InternalEventRouterPreprocessor.class);
    private static final Comparator<InternalEventRouterEntry> COMPARATOR = new Comparator<InternalEventRouterEntry>(){

        @Override
        public int compare(InternalEventRouterEntry o1, InternalEventRouterEntry o2) {
            if (o1.getPriority() > o2.getPriority()) {
                return 1;
            }
            if (o1.getPriority() < o2.getPriority()) {
                return -1;
            }
            if (o1.isDrop()) {
                return -1;
            }
            if (o2.isDrop()) {
                return -1;
            }
            return 0;
        }
    };
    private final EventBeanCopyMethod copyMethod;
    private final InternalEventRouterEntry[] entries;
    private final boolean empty;

    public InternalEventRouterPreprocessor(EventBeanCopyMethod copyMethod, List<InternalEventRouterEntry> entries) {
        this.copyMethod = copyMethod;
        Collections.sort(entries, COMPARATOR);
        this.entries = entries.toArray(new InternalEventRouterEntry[entries.size()]);
        this.empty = this.entries.length == 0;
    }

    public EventBean process(EventBean theEvent, ExprEvaluatorContext exprEvaluatorContext, InstrumentationCommon instrumentation) {
        InternalRoutePreprocessView view;
        if (this.empty) {
            return theEvent;
        }
        instrumentation.qUpdateIStream(this.entries);
        EventBean oldEvent = theEvent;
        boolean haveCloned = false;
        EventBean[] eventsPerStream = new EventBean[]{theEvent};
        InternalEventRouterEntry lastEntry = null;
        for (int i = 0; i < this.entries.length; ++i) {
            InternalEventRouterEntry entry = this.entries[i];
            instrumentation.qUpdateIStreamApply(i, entry);
            ExprEvaluator whereClause = entry.getOptionalWhereClause();
            if (whereClause != null) {
                instrumentation.qUpdateIStreamApplyWhere();
                Boolean result = (Boolean)whereClause.evaluate(eventsPerStream, true, exprEvaluatorContext);
                if (result == null || !result.booleanValue()) {
                    instrumentation.aUpdateIStreamApplyWhere(false);
                    instrumentation.aUpdateIStreamApply(null, false);
                    continue;
                }
                instrumentation.aUpdateIStreamApplyWhere(true);
            }
            if (entry.isDrop()) {
                instrumentation.aUpdateIStreamApply(null, false);
                return null;
            }
            if (lastEntry != null) {
                InternalRoutePreprocessView view2 = lastEntry.getOutputView();
                if (view2.isIndicate()) {
                    EventBean copied = this.copyMethod.copy(theEvent);
                    view2.indicate(copied, oldEvent);
                    oldEvent = copied;
                } else if (this.entries[i].getOutputView().isIndicate()) {
                    oldEvent = this.copyMethod.copy(theEvent);
                }
            }
            if (!haveCloned) {
                EventBean copiedEvent = this.copyMethod.copy(theEvent);
                if (copiedEvent == null) {
                    log.warn("Event of type " + theEvent.getEventType().getName() + " could not be copied");
                    instrumentation.aUpdateIStreamApply(null, false);
                    return null;
                }
                haveCloned = true;
                eventsPerStream[0] = copiedEvent;
                theEvent = copiedEvent;
            }
            this.apply(theEvent, eventsPerStream, entry, exprEvaluatorContext, instrumentation);
            lastEntry = entry;
            instrumentation.aUpdateIStreamApply(theEvent, true);
        }
        if (lastEntry != null && (view = lastEntry.getOutputView()).isIndicate()) {
            view.indicate(theEvent, oldEvent);
        }
        instrumentation.aUpdateIStream(theEvent, haveCloned);
        return theEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void apply(EventBean theEvent, EventBean[] eventsPerStream, InternalEventRouterEntry entry, ExprEvaluatorContext exprEvaluatorContext, InstrumentationCommon instrumentation) {
        Object[] values;
        if (entry.isHasSubselect()) {
            StatementResourceHolder holder = entry.getStatementContext().getStatementCPCacheService().makeOrGetEntryCanNull(-1, entry.getStatementContext());
            holder.getAgentInstanceContext().getAgentInstanceLock().acquireWriteLock();
            try {
                values = this.obtainValues(eventsPerStream, entry, exprEvaluatorContext, instrumentation);
            }
            finally {
                holder.getAgentInstanceContext().getAgentInstanceLock().releaseWriteLock();
            }
        } else {
            values = this.obtainValues(eventsPerStream, entry, exprEvaluatorContext, instrumentation);
        }
        entry.getWriter().write(values, theEvent);
        if (entry.getSpecialPropWriters().length > 0) {
            for (InternalEventRouterWriter special : entry.getSpecialPropWriters()) {
                if (special instanceof InternalEventRouterWriterArrayElement) {
                    Integer index;
                    Object arrayValue;
                    InternalEventRouterWriterArrayElement array = (InternalEventRouterWriterArrayElement)special;
                    Object value = array.getRhsExpression().evaluate(eventsPerStream, true, exprEvaluatorContext);
                    if (value != null && array.getTypeWidener() != null) {
                        value = array.getTypeWidener().widen(value);
                    }
                    if ((arrayValue = theEvent.get(array.getPropertyName())) == null || (index = (Integer)array.getIndexExpression().evaluate(eventsPerStream, true, exprEvaluatorContext)) == null) continue;
                    int len = Array.getLength(arrayValue);
                    if (index < len) {
                        if (value == null && arrayValue.getClass().getComponentType().isPrimitive()) continue;
                        Array.set(arrayValue, index, value);
                        continue;
                    }
                    throw new EPException("Array length " + len + " less than index " + index + " for property '" + array.getPropertyName() + "'");
                }
                if (special instanceof InternalEventRouterWriterCurly) {
                    InternalEventRouterWriterCurly curly = (InternalEventRouterWriterCurly)special;
                    curly.getExpression().evaluate(eventsPerStream, true, exprEvaluatorContext);
                    continue;
                }
                throw new IllegalStateException("Unrecognized writer " + special);
            }
        }
    }

    private Object[] obtainValues(EventBean[] eventsPerStream, InternalEventRouterEntry entry, ExprEvaluatorContext exprEvaluatorContext, InstrumentationCommon instrumentation) {
        instrumentation.qUpdateIStreamApplyAssignments(entry);
        Object[] values = new Object[entry.getAssignments().length];
        for (int i = 0; i < entry.getAssignments().length; ++i) {
            instrumentation.qUpdateIStreamApplyAssignmentItem(i);
            Object value = entry.getAssignments()[i].evaluate(eventsPerStream, true, exprEvaluatorContext);
            if (value != null && entry.getWideners()[i] != null) {
                value = entry.getWideners()[i].widen(value);
            }
            values[i] = value;
            instrumentation.aUpdateIStreamApplyAssignmentItem(value);
        }
        instrumentation.aUpdateIStreamApplyAssignments(values);
        return values;
    }
}

