/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.util;

import com.espertech.esper.common.client.annotation.NoLock;
import com.espertech.esper.common.client.util.StatementType;
import com.espertech.esper.common.internal.context.util.StatementAgentInstanceLock;
import com.espertech.esper.common.internal.context.util.StatementAgentInstanceLockFactory;
import com.espertech.esper.common.internal.context.util.StatementAgentInstanceLockNoLockImpl;
import com.espertech.esper.common.internal.context.util.StatementAgentInstanceLockRW;
import com.espertech.esper.common.internal.epl.annotation.AnnotationUtil;
import java.lang.annotation.Annotation;

public class StatementAgentInstanceLockFactoryImpl
implements StatementAgentInstanceLockFactory {
    private final boolean fairlocks;
    private final boolean disableLocking;

    public StatementAgentInstanceLockFactoryImpl(boolean fairlocks, boolean disableLocking) {
        this.fairlocks = fairlocks;
        this.disableLocking = disableLocking;
    }

    @Override
    public StatementAgentInstanceLock getStatementLock(String statementName, Annotation[] annotations, boolean stateless, StatementType statementType) {
        if (statementType.isOnTriggerInfra()) {
            throw new UnsupportedOperationException("Operation not available for statement type " + (Object)((Object)statementType));
        }
        boolean foundNoLock = AnnotationUtil.hasAnnotation(annotations, NoLock.class);
        if (this.disableLocking || foundNoLock || stateless) {
            return new StatementAgentInstanceLockNoLockImpl(statementName);
        }
        return new StatementAgentInstanceLockRW(this.fairlocks);
    }
}

