/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.agg.access.linear;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.hook.aggmultifunc.AggregationMultiFunctionMethodDesc;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.context.aifactory.core.ModuleTableInitializeSymbol;
import com.espertech.esper.common.internal.epl.agg.access.linear.AggregationAccessorLinearType;
import com.espertech.esper.common.internal.epl.agg.access.linear.AggregationMethodLinearCount;
import com.espertech.esper.common.internal.epl.agg.access.linear.AggregationMethodLinearFirstLastForge;
import com.espertech.esper.common.internal.epl.agg.access.linear.AggregationMethodLinearFirstLastIndexForge;
import com.espertech.esper.common.internal.epl.agg.access.linear.AggregationMethodLinearListReference;
import com.espertech.esper.common.internal.epl.agg.access.linear.AggregationMethodLinearNoParamForge;
import com.espertech.esper.common.internal.epl.agg.access.linear.AggregationMethodLinearWindowForge;
import com.espertech.esper.common.internal.epl.agg.core.AggregationForgeFactory;
import com.espertech.esper.common.internal.epl.agg.core.AggregationPortableValidation;
import com.espertech.esper.common.internal.epl.agg.core.AggregationValidationUtil;
import com.espertech.esper.common.internal.epl.expression.agg.accessagg.ExprAggMultiFunctionUtil;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeConstantType;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprStreamUnderlyingNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.core.ExprWildcard;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeServiceImpl;
import com.espertech.esper.common.internal.epl.table.compiletime.TableCompileTimeUtil;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.List;
import java.util.Locale;

public class AggregationPortableValidationLinear
implements AggregationPortableValidation {
    private EventType containedEventType;

    public AggregationPortableValidationLinear() {
    }

    public AggregationPortableValidationLinear(EventType containedEventType) {
        this.containedEventType = containedEventType;
    }

    public void setContainedEventType(EventType containedEventType) {
        this.containedEventType = containedEventType;
    }

    public EventType getContainedEventType() {
        return this.containedEventType;
    }

    @Override
    public void validateIntoTableCompatible(String tableExpression, AggregationPortableValidation intoTableAgg, String intoExpression, AggregationForgeFactory factory) throws ExprValidationException {
        AggregationValidationUtil.validateAggregationType(this, tableExpression, intoTableAgg, intoExpression);
        AggregationPortableValidationLinear other = (AggregationPortableValidationLinear)intoTableAgg;
        AggregationValidationUtil.validateEventType(this.containedEventType, other.getContainedEventType());
    }

    @Override
    public CodegenExpression make(CodegenMethodScope parent, ModuleTableInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(AggregationPortableValidationLinear.class, this.getClass(), (CodegenScope)classScope);
        method.getBlock().declareVar(AggregationPortableValidationLinear.class, "v", CodegenExpressionBuilder.newInstance(AggregationPortableValidationLinear.class, new CodegenExpression[0])).exprDotMethod(CodegenExpressionBuilder.ref("v"), "setContainedEventType", EventTypeUtility.resolveTypeCodegen(this.containedEventType, symbols.getAddInitSvc(method))).methodReturn(CodegenExpressionBuilder.ref("v"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    @Override
    public boolean isAggregationMethod(String name, ExprNode[] parameters, ExprValidationContext validationContext) {
        return AggregationAccessorLinearType.fromString(name = name.toLowerCase(Locale.ENGLISH)) != null || name.equals("countevents") || name.equals("listreference");
    }

    @Override
    public AggregationMultiFunctionMethodDesc validateAggregationMethod(ExprValidationContext validationContext, String aggMethodName, ExprNode[] params) throws ExprValidationException {
        if ((aggMethodName = aggMethodName.toLowerCase(Locale.ENGLISH)).equals("countevents") || aggMethodName.equals("listreference")) {
            if (params.length > 0) {
                throw new ExprValidationException("Invalid number of parameters");
            }
            Class provider = AggregationMethodLinearCount.class;
            Class result = Integer.class;
            if (aggMethodName.equals("listreference")) {
                provider = AggregationMethodLinearListReference.class;
                result = List.class;
            }
            return new AggregationMultiFunctionMethodDesc(new AggregationMethodLinearNoParamForge(provider, result), null, null, null);
        }
        AggregationAccessorLinearType methodType = AggregationAccessorLinearType.fromString(aggMethodName);
        if (methodType == AggregationAccessorLinearType.FIRST || methodType == AggregationAccessorLinearType.LAST) {
            return this.handleMethodFirstLast(params, methodType, validationContext);
        }
        return this.handleMethodWindow(params, validationContext);
    }

    private AggregationMultiFunctionMethodDesc handleMethodWindow(ExprNode[] childNodes, ExprValidationContext validationContext) throws ExprValidationException {
        if (childNodes.length == 0 || childNodes.length == 1 && childNodes[0] instanceof ExprWildcard) {
            Class componentType = this.getContainedEventType().getUnderlyingType();
            AggregationMethodLinearWindowForge forge = new AggregationMethodLinearWindowForge(JavaClassHelper.getArrayType(componentType), null);
            return new AggregationMultiFunctionMethodDesc(forge, this.getContainedEventType(), null, null);
        }
        if (childNodes.length == 1) {
            ExprNode paramNode = childNodes[0];
            StreamTypeServiceImpl streams = TableCompileTimeUtil.streamTypeFromTableColumn(this.getContainedEventType());
            ExprValidationContext localValidationContext = new ExprValidationContext(streams, validationContext);
            paramNode = ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.AGGPARAM, paramNode, localValidationContext);
            Class paramNodeType = JavaClassHelper.getBoxedType(paramNode.getForge().getEvaluationType());
            AggregationMethodLinearWindowForge forge = new AggregationMethodLinearWindowForge(JavaClassHelper.getArrayType(paramNodeType), paramNode);
            return new AggregationMultiFunctionMethodDesc(forge, null, paramNodeType, null);
        }
        throw new ExprValidationException("Invalid number of parameters");
    }

    private AggregationMultiFunctionMethodDesc handleMethodFirstLast(ExprNode[] childNodes, AggregationAccessorLinearType methodType, ExprValidationContext validationContext) throws ExprValidationException {
        Class underlyingType = this.getContainedEventType().getUnderlyingType();
        if (childNodes.length == 0) {
            AggregationMethodLinearFirstLastForge forge = new AggregationMethodLinearFirstLastForge(underlyingType, methodType, null);
            return new AggregationMultiFunctionMethodDesc(forge, null, null, this.getContainedEventType());
        }
        if (childNodes.length == 1) {
            if (childNodes[0] instanceof ExprWildcard) {
                AggregationMethodLinearFirstLastForge forge = new AggregationMethodLinearFirstLastForge(underlyingType, methodType, null);
                return new AggregationMultiFunctionMethodDesc(forge, null, null, this.getContainedEventType());
            }
            if (childNodes[0] instanceof ExprStreamUnderlyingNode) {
                throw new ExprValidationException("Stream-wildcard is not allowed for table column access");
            }
            ExprNode paramNode = childNodes[0];
            StreamTypeServiceImpl streams = TableCompileTimeUtil.streamTypeFromTableColumn(this.getContainedEventType());
            ExprValidationContext localValidationContext = new ExprValidationContext(streams, validationContext);
            paramNode = ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.AGGPARAM, paramNode, localValidationContext);
            AggregationMethodLinearFirstLastForge forge = new AggregationMethodLinearFirstLastForge(paramNode.getForge().getEvaluationType(), methodType, paramNode);
            return new AggregationMultiFunctionMethodDesc(forge, null, null, null);
        }
        if (childNodes.length == 2) {
            ExprNode indexExpr;
            Integer constant = null;
            ExprNode indexEvalNode = childNodes[1];
            Class indexEvalType = indexEvalNode.getForge().getEvaluationType();
            if (indexEvalType != Integer.class && indexEvalType != Integer.TYPE) {
                throw new ExprValidationException(AggregationPortableValidationLinear.getErrorPrefix(methodType) + " requires a constant index expression that returns an integer value");
            }
            if (indexEvalNode.getForge().getForgeConstantType() == ExprForgeConstantType.COMPILETIMECONST) {
                constant = (Integer)indexEvalNode.getForge().getExprEvaluator().evaluate(null, true, null);
                indexExpr = null;
            } else {
                indexExpr = indexEvalNode;
            }
            AggregationMethodLinearFirstLastIndexForge forge = new AggregationMethodLinearFirstLastIndexForge(underlyingType, methodType, constant, indexExpr);
            return new AggregationMultiFunctionMethodDesc(forge, null, null, this.getContainedEventType());
        }
        throw new ExprValidationException("Invalid number of parameters");
    }

    private static String getErrorPrefix(AggregationAccessorLinearType stateType) {
        return ExprAggMultiFunctionUtil.getErrorPrefix(stateType.toString().toLowerCase(Locale.ENGLISH));
    }
}

