/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.agg.core;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.annotation.Hint;
import com.espertech.esper.common.client.annotation.HintEnum;
import com.espertech.esper.common.client.annotation.HookType;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyClassRef;
import com.espertech.esper.common.internal.compile.stage1.spec.IntoTableSpec;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.epl.agg.access.core.AggregationAgentForge;
import com.espertech.esper.common.internal.epl.agg.core.AggregationAccessorForge;
import com.espertech.esper.common.internal.epl.agg.core.AggregationAccessorSlotPairForge;
import com.espertech.esper.common.internal.epl.agg.core.AggregationForgeFactory;
import com.espertech.esper.common.internal.epl.agg.core.AggregationGroupByRollupDescForge;
import com.espertech.esper.common.internal.epl.agg.core.AggregationMultiFunctionAnalysisHelper;
import com.espertech.esper.common.internal.epl.agg.core.AggregationMultiFunctionAnalysisResult;
import com.espertech.esper.common.internal.epl.agg.core.AggregationPortableValidation;
import com.espertech.esper.common.internal.epl.agg.core.AggregationRowStateForgeDesc;
import com.espertech.esper.common.internal.epl.agg.core.AggregationServiceAggExpressionDesc;
import com.espertech.esper.common.internal.epl.agg.core.AggregationServiceFactoryForgeWMethodGen;
import com.espertech.esper.common.internal.epl.agg.core.AggregationServiceForgeDesc;
import com.espertech.esper.common.internal.epl.agg.core.AggregationServiceNullFactory;
import com.espertech.esper.common.internal.epl.agg.core.AggregationStateFactoryForge;
import com.espertech.esper.common.internal.epl.agg.core.AggregationUseFlags;
import com.espertech.esper.common.internal.epl.agg.groupall.AggregationServiceGroupAllForge;
import com.espertech.esper.common.internal.epl.agg.groupby.AggGroupByDesc;
import com.espertech.esper.common.internal.epl.agg.groupby.AggSvcGroupByReclaimAgedEvalFuncFactoryConstForge;
import com.espertech.esper.common.internal.epl.agg.groupby.AggSvcGroupByReclaimAgedEvalFuncFactoryForge;
import com.espertech.esper.common.internal.epl.agg.groupby.AggSvcGroupByReclaimAgedEvalFuncFactoryVariableForge;
import com.espertech.esper.common.internal.epl.agg.groupby.AggregationServiceGroupByForge;
import com.espertech.esper.common.internal.epl.agg.groupbylocal.AggSvcLocalGroupByForge;
import com.espertech.esper.common.internal.epl.agg.groupbylocal.AggregationGroupByLocalGroupByAnalyzer;
import com.espertech.esper.common.internal.epl.agg.groupbylocal.AggregationGroupByLocalGroupDesc;
import com.espertech.esper.common.internal.epl.agg.groupbylocal.AggregationGroupByLocalGroupLevel;
import com.espertech.esper.common.internal.epl.agg.groupbylocal.AggregationLocalGroupByPlanDesc;
import com.espertech.esper.common.internal.epl.agg.groupbylocal.AggregationLocalGroupByPlanForge;
import com.espertech.esper.common.internal.epl.agg.groupbylocal.AggregationLocalLevelHook;
import com.espertech.esper.common.internal.epl.agg.rollup.AggSvcGroupByRollupForge;
import com.espertech.esper.common.internal.epl.agg.table.AggregationServiceFactoryForgeTable;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateLocalGroupByDesc;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNode;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNodeBase;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNodeGroupKey;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCompare;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.declared.compiletime.ExprDeclaredNode;
import com.espertech.esper.common.internal.epl.expression.table.ExprTableNodeUtil;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodePreviousVisitorWParent;
import com.espertech.esper.common.internal.epl.table.compiletime.TableCompileTimeResolver;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetaData;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetadataColumnAggregation;
import com.espertech.esper.common.internal.epl.table.core.TableColumnMethodPairForge;
import com.espertech.esper.common.internal.epl.util.EPLValidationUtil;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableCompileTimeResolver;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableMetaData;
import com.espertech.esper.common.internal.epl.variable.core.VariableUtil;
import com.espertech.esper.common.internal.serde.compiletime.resolve.SerdeCompileTimeResolver;
import com.espertech.esper.common.internal.settings.ClasspathImportService;
import com.espertech.esper.common.internal.settings.ClasspathImportServiceCompileTime;
import com.espertech.esper.common.internal.settings.ClasspathImportUtil;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AggregationServiceFactoryFactory {
    public static AggregationServiceForgeDesc getService(List<ExprAggregateNode> selectAggregateExprNodes, Map<ExprNode, String> selectClauseNamedNodes, List<ExprDeclaredNode> declaredExpressions, ExprNode[] groupByNodes, MultiKeyClassRef groupByMultiKey, List<ExprAggregateNode> havingAggregateExprNodes, List<ExprAggregateNode> orderByAggregateExprNodes, List<ExprAggregateNodeGroupKey> groupKeyExpressions, boolean hasGroupByClause, Annotation[] annotations, VariableCompileTimeResolver variableCompileTimeResolver, boolean isDisallowNoReclaim, ExprNode whereClause, ExprNode havingClause, EventType[] typesPerStream, AggregationGroupByRollupDescForge groupByRollupDesc, String optionalContextName, IntoTableSpec intoTableSpec, TableCompileTimeResolver tableCompileTimeResolver, boolean isUnidirectional, boolean isFireAndForget, boolean isOnSelect, ClasspathImportServiceCompileTime classpathImportService, StatementRawInfo raw, SerdeCompileTimeResolver serdeResolver) throws ExprValidationException {
        AggregationServiceFactoryForgeWMethodGen serviceForge;
        if (selectAggregateExprNodes.isEmpty() && havingAggregateExprNodes.isEmpty()) {
            if (intoTableSpec != null) {
                throw new ExprValidationException("Into-table requires at least one aggregation function");
            }
            return new AggregationServiceForgeDesc(AggregationServiceNullFactory.INSTANCE, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }
        if (whereClause != null || havingClause != null) {
            ExprNodePreviousVisitorWParent visitor = new ExprNodePreviousVisitorWParent();
            if (whereClause != null) {
                whereClause.accept(visitor);
            }
            if (havingClause != null) {
                havingClause.accept(visitor);
            }
            if (visitor.getPrevious() != null && !visitor.getPrevious().isEmpty()) {
                String funcname = visitor.getPrevious().get(0).getSecond().getPreviousType().toString().toLowerCase(Locale.ENGLISH);
                throw new ExprValidationException("The '" + funcname + "' function may not occur in the where-clause or having-clause of a statement with aggregations as 'previous' does not provide remove stream data; Use the 'first','last','window' or 'count' aggregation functions instead");
            }
        }
        ArrayList<AggregationServiceAggExpressionDesc> aggregations = new ArrayList<AggregationServiceAggExpressionDesc>();
        boolean intoTableNonRollup = groupByRollupDesc == null && intoTableSpec != null;
        for (ExprAggregateNode exprAggregateNode : selectAggregateExprNodes) {
            AggregationServiceFactoryFactory.addEquivalent(exprAggregateNode, aggregations, intoTableNonRollup);
        }
        for (ExprAggregateNode exprAggregateNode : havingAggregateExprNodes) {
            AggregationServiceFactoryFactory.addEquivalent(exprAggregateNode, aggregations, intoTableNonRollup);
        }
        for (ExprAggregateNode exprAggregateNode : orderByAggregateExprNodes) {
            AggregationServiceFactoryFactory.addEquivalent(exprAggregateNode, aggregations, intoTableNonRollup);
        }
        ArrayList<ExprForge[]> methodAggForgesList = new ArrayList<ExprForge[]>();
        for (AggregationServiceAggExpressionDesc aggregation : aggregations) {
            ExprAggregateNode aggregateNode = aggregation.getAggregationNode();
            if (aggregateNode.getFactory().isAccessAggregation()) continue;
            ExprForge[] forges = aggregateNode.getFactory().getMethodAggregationForge(typesPerStream.length > 1, typesPerStream);
            methodAggForgesList.add(forges);
        }
        AggregationGroupByLocalGroupDesc aggregationGroupByLocalGroupDesc = AggregationServiceFactoryFactory.analyzeLocalGroupBy(aggregations, groupByNodes, groupByRollupDesc, intoTableSpec);
        if (intoTableSpec != null) {
            TableMetaData metadata = tableCompileTimeResolver.resolve(intoTableSpec.getName());
            if (metadata == null) {
                throw new ExprValidationException("Invalid into-table clause: Failed to find table by name '" + intoTableSpec.getName() + "'");
            }
            EPLValidationUtil.validateContextName(true, intoTableSpec.getName(), metadata.getOptionalContextName(), optionalContextName, false);
            Class[] groupByTypes = ExprNodeUtilityQuery.getExprResultTypes(groupByNodes);
            Class[] keyTypes = metadata.isKeyed() ? metadata.getKeyTypes() : new Class[]{};
            ExprTableNodeUtil.validateExpressions(intoTableSpec.getName(), groupByTypes, "group-by", groupByNodes, keyTypes, "group-by");
            BindingMatchResult bindingMatchResult = AggregationServiceFactoryFactory.matchBindingsAssignColumnNumbers(intoTableSpec, metadata, aggregations, selectClauseNamedNodes, methodAggForgesList, declaredExpressions, classpathImportService, raw.getStatementName());
            AggregationServiceFactoryForgeTable serviceForge2 = new AggregationServiceFactoryForgeTable(metadata, bindingMatchResult.getMethodPairs(), bindingMatchResult.getTargetStates(), bindingMatchResult.getAgents(), groupByRollupDesc);
            return new AggregationServiceForgeDesc(serviceForge2, aggregations, groupKeyExpressions, Collections.emptyList());
        }
        int columnNumber = 0;
        for (AggregationServiceAggExpressionDesc entry : aggregations) {
            if (entry.getFactory().isAccessAggregation()) continue;
            entry.setColumnNum(columnNumber++);
        }
        for (AggregationServiceAggExpressionDesc entry : aggregations) {
            if (!entry.getFactory().isAccessAggregation()) continue;
            entry.setColumnNum(columnNumber++);
        }
        ExprForge[][] methodAggForges = (ExprForge[][])methodAggForgesList.toArray((T[])new ExprForge[methodAggForgesList.size()][]);
        AggregationForgeFactory[] methodAggFactories = new AggregationForgeFactory[methodAggForges.length];
        int count = 0;
        for (AggregationServiceAggExpressionDesc aggregation : aggregations) {
            ExprAggregateNode aggregateNode = aggregation.getAggregationNode();
            if (aggregateNode.getFactory().isAccessAggregation()) continue;
            methodAggFactories[count] = aggregateNode.getFactory();
            ++count;
        }
        AggregationMultiFunctionAnalysisResult multiFunctionAggPlan = AggregationMultiFunctionAnalysisHelper.analyzeAccessAggregations(aggregations, classpathImportService, isFireAndForget, raw.getStatementName(), groupByNodes);
        AggregationAccessorSlotPairForge[] accessorPairsForge = multiFunctionAggPlan.getAccessorPairsForge();
        AggregationStateFactoryForge[] accessFactories = multiFunctionAggPlan.getStateFactoryForges();
        boolean hasAccessAgg = accessorPairsForge.length > 0;
        boolean hasMethodAgg = methodAggFactories.length > 0;
        AggregationUseFlags useFlags = new AggregationUseFlags(isUnidirectional, isFireAndForget, isOnSelect);
        ArrayList<StmtClassForgeableFactory> additionalForgeables = new ArrayList<StmtClassForgeableFactory>(2);
        AggregationLocalGroupByPlanForge localGroupByPlan = null;
        if (aggregationGroupByLocalGroupDesc != null) {
            AggregationLocalGroupByPlanDesc plan = AggregationGroupByLocalGroupByAnalyzer.analyze(methodAggForges, methodAggFactories, accessFactories, aggregationGroupByLocalGroupDesc, groupByNodes, groupByMultiKey, accessorPairsForge, raw, serdeResolver);
            localGroupByPlan = plan.getForge();
            additionalForgeables.addAll(plan.getAdditionalForgeables());
            try {
                AggregationLocalLevelHook hook = (AggregationLocalLevelHook)ClasspathImportUtil.getAnnotationHook(annotations, HookType.INTERNAL_AGGLOCALLEVEL, AggregationLocalLevelHook.class, classpathImportService);
                if (hook != null) {
                    hook.planned(aggregationGroupByLocalGroupDesc, localGroupByPlan);
                }
            }
            catch (ExprValidationException e) {
                throw new EPException("Failed to obtain hook for " + (Object)((Object)HookType.INTERNAL_AGGLOCALLEVEL));
            }
        }
        AggregationRowStateForgeDesc rowStateDesc = new AggregationRowStateForgeDesc((AggregationForgeFactory[])(hasMethodAgg ? methodAggFactories : null), hasMethodAgg ? methodAggForges : (ExprForge[][])null, (AggregationStateFactoryForge[])(hasAccessAgg ? accessFactories : null), (AggregationAccessorSlotPairForge[])(hasAccessAgg ? accessorPairsForge : null), useFlags);
        if (!hasGroupByClause) {
            serviceForge = localGroupByPlan != null ? new AggSvcLocalGroupByForge(false, localGroupByPlan, useFlags) : new AggregationServiceGroupAllForge(rowStateDesc);
        } else {
            AggGroupByDesc groupDesc = new AggGroupByDesc(rowStateDesc, isUnidirectional, isFireAndForget, isOnSelect, groupByNodes, groupByMultiKey);
            boolean hasNoReclaim = HintEnum.DISABLE_RECLAIM_GROUP.getHint(annotations) != null;
            Hint reclaimGroupAged = HintEnum.RECLAIM_GROUP_AGED.getHint(annotations);
            Hint reclaimGroupFrequency = HintEnum.RECLAIM_GROUP_AGED.getHint(annotations);
            if (localGroupByPlan != null) {
                serviceForge = new AggSvcLocalGroupByForge(true, localGroupByPlan, useFlags);
            } else if (!isDisallowNoReclaim && hasNoReclaim) {
                if (groupByRollupDesc != null) {
                    throw AggregationServiceFactoryFactory.getRollupReclaimEx();
                }
                serviceForge = new AggregationServiceGroupByForge(groupDesc, classpathImportService.getTimeAbacus());
            } else if (!isDisallowNoReclaim && reclaimGroupAged != null) {
                if (groupByRollupDesc != null) {
                    throw AggregationServiceFactoryFactory.getRollupReclaimEx();
                }
                AggregationServiceFactoryFactory.compileReclaim(groupDesc, reclaimGroupAged, reclaimGroupFrequency, variableCompileTimeResolver, optionalContextName);
                serviceForge = new AggregationServiceGroupByForge(groupDesc, classpathImportService.getTimeAbacus());
            } else if (groupByRollupDesc != null) {
                serviceForge = new AggSvcGroupByRollupForge(rowStateDesc, groupByRollupDesc, groupByNodes);
            } else {
                groupDesc.setRefcounted(true);
                serviceForge = new AggregationServiceGroupByForge(groupDesc, classpathImportService.getTimeAbacus());
            }
        }
        return new AggregationServiceForgeDesc(serviceForge, aggregations, groupKeyExpressions, additionalForgeables);
    }

    private static void addEquivalent(ExprAggregateNode aggNodeToAdd, List<AggregationServiceAggExpressionDesc> equivalencyList, boolean intoTableNonRollup) {
        boolean foundEquivalent = false;
        for (AggregationServiceAggExpressionDesc existing : equivalencyList) {
            ExprAggregateNode aggNode = existing.getAggregationNode();
            if (!aggNode.equalsNode(aggNodeToAdd, false) || !ExprNodeUtilityCompare.deepEquals(aggNode.getPositionalParams(), aggNodeToAdd.getPositionalParams(), false) || !ExprNodeUtilityCompare.deepEqualsNullChecked(aggNode.getOptionalFilter(), aggNodeToAdd.getOptionalFilter(), false) || (aggNode.getOptionalLocalGroupBy() != null || aggNodeToAdd.getOptionalLocalGroupBy() != null) && (aggNode.getOptionalLocalGroupBy() == null && aggNodeToAdd.getOptionalLocalGroupBy() != null || aggNode.getOptionalLocalGroupBy() != null && aggNodeToAdd.getOptionalLocalGroupBy() == null || !ExprNodeUtilityCompare.deepEqualsIgnoreDupAndOrder(aggNode.getOptionalLocalGroupBy().getPartitionExpressions(), aggNodeToAdd.getOptionalLocalGroupBy().getPartitionExpressions()))) continue;
            existing.addEquivalent(aggNodeToAdd);
            foundEquivalent = true;
            break;
        }
        if (!foundEquivalent || intoTableNonRollup) {
            equivalencyList.add(new AggregationServiceAggExpressionDesc(aggNodeToAdd, aggNodeToAdd.getFactory()));
        }
    }

    private static void compileReclaim(AggGroupByDesc groupDesc, Hint reclaimGroupAged, Hint reclaimGroupFrequency, VariableCompileTimeResolver variableCompileTimeResolver, String optionalContextName) throws ExprValidationException {
        String hintValueMaxAge = HintEnum.RECLAIM_GROUP_AGED.getHintAssignedValue(reclaimGroupAged);
        if (hintValueMaxAge == null) {
            throw new ExprValidationException("Required hint value for hint '" + (Object)((Object)HintEnum.RECLAIM_GROUP_AGED) + "' has not been provided");
        }
        AggSvcGroupByReclaimAgedEvalFuncFactoryForge evaluationFunctionMaxAge = AggregationServiceFactoryFactory.getEvaluationFunction(variableCompileTimeResolver, hintValueMaxAge, optionalContextName);
        groupDesc.setReclaimAged(true);
        groupDesc.setReclaimEvaluationFunctionMaxAge(evaluationFunctionMaxAge);
        String hintValueFrequency = HintEnum.RECLAIM_GROUP_FREQ.getHintAssignedValue(reclaimGroupAged);
        AggSvcGroupByReclaimAgedEvalFuncFactoryForge evaluationFunctionFrequency = reclaimGroupFrequency == null || hintValueFrequency == null ? evaluationFunctionMaxAge : AggregationServiceFactoryFactory.getEvaluationFunction(variableCompileTimeResolver, hintValueFrequency, optionalContextName);
        groupDesc.setReclaimEvaluationFunctionFrequency(evaluationFunctionFrequency);
    }

    private static AggregationGroupByLocalGroupDesc analyzeLocalGroupBy(List<AggregationServiceAggExpressionDesc> aggregations, ExprNode[] groupByNodes, AggregationGroupByRollupDescForge groupByRollupDesc, IntoTableSpec intoTableSpec) throws ExprValidationException {
        boolean hasOver = false;
        for (AggregationServiceAggExpressionDesc desc : aggregations) {
            if (desc.getAggregationNode().getOptionalLocalGroupBy() == null) continue;
            hasOver = true;
            break;
        }
        if (!hasOver) {
            return null;
        }
        if (groupByRollupDesc != null) {
            throw new ExprValidationException("Roll-up and group-by parameters cannot be combined");
        }
        if (intoTableSpec != null) {
            throw new ExprValidationException("Into-table and group-by parameters cannot be combined");
        }
        ArrayList<AggregationGroupByLocalGroupLevel> partitions = new ArrayList<AggregationGroupByLocalGroupLevel>();
        for (AggregationServiceAggExpressionDesc desc : aggregations) {
            ExprAggregateLocalGroupByDesc localGroupBy = desc.getAggregationNode().getOptionalLocalGroupBy();
            ExprNode[] partitionExpressions = localGroupBy == null ? groupByNodes : localGroupBy.getPartitionExpressions();
            List<AggregationServiceAggExpressionDesc> found = AggregationServiceFactoryFactory.findPartition(partitions, partitionExpressions);
            if (found == null) {
                found = new ArrayList<AggregationServiceAggExpressionDesc>();
                AggregationGroupByLocalGroupLevel level = new AggregationGroupByLocalGroupLevel(partitionExpressions, found);
                partitions.add(level);
            }
            found.add(desc);
        }
        if (partitions.size() == 1 && ExprNodeUtilityCompare.deepEqualsIgnoreDupAndOrder(((AggregationGroupByLocalGroupLevel)partitions.get(0)).getPartitionExpr(), groupByNodes)) {
            return null;
        }
        return new AggregationGroupByLocalGroupDesc(aggregations.size(), partitions.toArray(new AggregationGroupByLocalGroupLevel[partitions.size()]));
    }

    private static List<AggregationServiceAggExpressionDesc> findPartition(List<AggregationGroupByLocalGroupLevel> partitions, ExprNode[] partitionExpressions) {
        for (AggregationGroupByLocalGroupLevel level : partitions) {
            if (!ExprNodeUtilityCompare.deepEqualsIgnoreDupAndOrder(level.getPartitionExpr(), partitionExpressions)) continue;
            return level.getExpressions();
        }
        return null;
    }

    private static BindingMatchResult matchBindingsAssignColumnNumbers(IntoTableSpec bindings, TableMetaData metadata, List<AggregationServiceAggExpressionDesc> aggregations, Map<ExprNode, String> selectClauseNamedNodes, List<ExprForge[]> methodAggForgesList, List<ExprDeclaredNode> declaredExpressions, ClasspathImportService classpathImportService, String statementName) throws ExprValidationException {
        LinkedHashMap<AggregationServiceAggExpressionDesc, TableMetadataColumnAggregation> methodAggs = new LinkedHashMap<AggregationServiceAggExpressionDesc, TableMetadataColumnAggregation>();
        LinkedHashMap<AggregationServiceAggExpressionDesc, TableMetadataColumnAggregation> accessAggs = new LinkedHashMap<AggregationServiceAggExpressionDesc, TableMetadataColumnAggregation>();
        for (AggregationServiceAggExpressionDesc aggDesc : aggregations) {
            String columnName = AggregationServiceFactoryFactory.findColumnNameForAggregation(selectClauseNamedNodes, declaredExpressions, aggDesc.getAggregationNode());
            if (columnName == null) {
                throw new ExprValidationException("Failed to find an expression among the select-clause expressions for expression '" + ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(aggDesc.getAggregationNode()) + "'");
            }
            TableMetadataColumnAggregation tableMetadataColumnAggregation = (TableMetadataColumnAggregation)metadata.getColumns().get(columnName);
            if (tableMetadataColumnAggregation == null) {
                throw new ExprValidationException("Failed to find name '" + (String)columnName + "' among the columns for table '" + bindings.getName() + "'");
            }
            AggregationServiceFactoryFactory.validateIntoTableCompatible(bindings.getName(), columnName, tableMetadataColumnAggregation, aggDesc);
            if (tableMetadataColumnAggregation.isMethodAgg()) {
                methodAggs.put(aggDesc, tableMetadataColumnAggregation);
                continue;
            }
            accessAggs.put(aggDesc, tableMetadataColumnAggregation);
        }
        TableColumnMethodPairForge[] methodPairs = new TableColumnMethodPairForge[methodAggForgesList.size()];
        int methodIndex = -1;
        for (Map.Entry entry : methodAggs.entrySet()) {
            int column = ((TableMetadataColumnAggregation)entry.getValue()).getColumn();
            ExprForge[] forges = methodAggForgesList.get(++methodIndex);
            methodPairs[methodIndex] = new TableColumnMethodPairForge(forges, column, ((AggregationServiceAggExpressionDesc)entry.getKey()).getAggregationNode());
            ((AggregationServiceAggExpressionDesc)entry.getKey()).setColumnNum(column);
        }
        LinkedHashMap<Integer, ExprAggregateNode> accessSlots = new LinkedHashMap<Integer, ExprAggregateNode>();
        ArrayList<AggregationAccessorSlotPairForge> arrayList = new ArrayList<AggregationAccessorSlotPairForge>();
        int accessIndex = -1;
        ArrayList<AggregationAgentForge> agents = new ArrayList<AggregationAgentForge>();
        for (Map.Entry accessEntry : accessAggs.entrySet()) {
            ++accessIndex;
            int column = ((TableMetadataColumnAggregation)accessEntry.getValue()).getColumn();
            AggregationForgeFactory aggregationMethodFactory = ((AggregationServiceAggExpressionDesc)accessEntry.getKey()).getFactory();
            AggregationAccessorForge accessorForge = aggregationMethodFactory.getAccessorForge();
            accessSlots.put(column, ((AggregationServiceAggExpressionDesc)accessEntry.getKey()).getAggregationNode());
            arrayList.add(new AggregationAccessorSlotPairForge(column, accessorForge));
            ((AggregationServiceAggExpressionDesc)accessEntry.getKey()).setColumnNum(column);
            agents.add(aggregationMethodFactory.getAggregationStateAgent(classpathImportService, statementName));
        }
        AggregationAgentForge[] agentArr = agents.toArray(new AggregationAgentForge[agents.size()]);
        AggregationAccessorSlotPairForge[] accessReads = arrayList.toArray(new AggregationAccessorSlotPairForge[arrayList.size()]);
        int[] targetStates = new int[accessSlots.size()];
        ExprNode[] accessStateExpr = new ExprNode[accessSlots.size()];
        int count = 0;
        for (Map.Entry entry : accessSlots.entrySet()) {
            targetStates[count] = (Integer)entry.getKey();
            accessStateExpr[count] = (ExprNode)entry.getValue();
            ++count;
        }
        return new BindingMatchResult(methodPairs, accessReads, targetStates, accessStateExpr, agentArr);
    }

    private static String findColumnNameForAggregation(Map<ExprNode, String> selectClauseNamedNodes, List<ExprDeclaredNode> declaredExpressions, ExprAggregateNode aggregationNode) {
        if (selectClauseNamedNodes.containsKey(aggregationNode)) {
            return selectClauseNamedNodes.get(aggregationNode);
        }
        for (ExprDeclaredNode node : declaredExpressions) {
            if (node.getBody() != aggregationNode) continue;
            return node.getPrototype().getName();
        }
        return null;
    }

    private static void validateIntoTableCompatible(String tableName, String columnName, TableMetadataColumnAggregation columnMetadata, AggregationServiceAggExpressionDesc aggDesc) throws ExprValidationException {
        AggregationPortableValidation factoryProvided = aggDesc.getFactory().getAggregationPortableValidation();
        AggregationPortableValidation factoryRequired = columnMetadata.getAggregationPortableValidation();
        try {
            factoryRequired.validateIntoTableCompatible(columnMetadata.getAggregationExpression(), factoryProvided, ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(aggDesc.getAggregationNode()), aggDesc.getFactory());
        }
        catch (ExprValidationException ex) {
            String text = AggregationServiceFactoryFactory.getMessage(tableName, columnName, columnMetadata.getAggregationExpression(), aggDesc.getFactory().getAggregationExpression());
            throw new ExprValidationException(text + ": " + ex.getMessage(), ex);
        }
    }

    private static String getMessage(String tableName, String columnName, String aggregationRequired, ExprAggregateNodeBase aggregationProvided) {
        return "Incompatible aggregation function for table '" + tableName + "' column '" + columnName + "', expecting '" + aggregationRequired + "' and received '" + ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(aggregationProvided) + "'";
    }

    private static AggSvcGroupByReclaimAgedEvalFuncFactoryForge getEvaluationFunction(VariableCompileTimeResolver variableCompileTimeResolver, String hintValue, String optionalContextName) throws ExprValidationException {
        Double valueDouble;
        VariableMetaData variableMetaData = variableCompileTimeResolver.resolve(hintValue);
        if (variableMetaData != null) {
            if (!JavaClassHelper.isNumeric(variableMetaData.getType())) {
                throw new ExprValidationException("Variable type of variable '" + variableMetaData.getVariableName() + "' is not numeric");
            }
            String message = VariableUtil.checkVariableContextName(optionalContextName, variableMetaData);
            if (message != null) {
                throw new ExprValidationException(message);
            }
            return new AggSvcGroupByReclaimAgedEvalFuncFactoryVariableForge(variableMetaData);
        }
        try {
            valueDouble = Double.parseDouble(hintValue);
        }
        catch (RuntimeException ex) {
            throw new ExprValidationException("Failed to parse hint parameter value '" + hintValue + "' as a double-typed seconds value or variable name");
        }
        if (valueDouble <= 0.0) {
            throw new ExprValidationException("Hint parameter value '" + hintValue + "' is an invalid value, expecting a double-typed seconds value or variable name");
        }
        return new AggSvcGroupByReclaimAgedEvalFuncFactoryConstForge(valueDouble);
    }

    public static ExprValidationException getRollupReclaimEx() {
        return new ExprValidationException("Reclaim hints are not available with rollup");
    }

    private static class BindingMatchResult {
        private final TableColumnMethodPairForge[] methodPairs;
        private final AggregationAccessorSlotPairForge[] accessors;
        private final int[] targetStates;
        private final ExprNode[] accessStateExpr;
        private final AggregationAgentForge[] agents;

        private BindingMatchResult(TableColumnMethodPairForge[] methodPairs, AggregationAccessorSlotPairForge[] accessors, int[] targetStates, ExprNode[] accessStateExpr, AggregationAgentForge[] agents) {
            this.methodPairs = methodPairs;
            this.accessors = accessors;
            this.targetStates = targetStates;
            this.accessStateExpr = accessStateExpr;
            this.agents = agents;
        }

        public TableColumnMethodPairForge[] getMethodPairs() {
            return this.methodPairs;
        }

        public AggregationAccessorSlotPairForge[] getAccessors() {
            return this.accessors;
        }

        public int[] getTargetStates() {
            return this.targetStates;
        }

        public AggregationAgentForge[] getAgents() {
            return this.agents;
        }

        public ExprNode[] getAccessStateExpr() {
            return this.accessStateExpr;
        }
    }
}

