/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.agg.groupby;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenCtor;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenNamedMethods;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenNamedParam;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenTypedParam;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRelational;
import com.espertech.esper.common.internal.epl.agg.core.AggSvcGroupByReclaimAgedEvalFunc;
import com.espertech.esper.common.internal.epl.agg.core.AggregationClassNames;
import com.espertech.esper.common.internal.epl.agg.core.AggregationRowRemovedCallback;
import com.espertech.esper.common.internal.epl.agg.groupby.AggregationServiceGroupByForge;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenNames;
import com.espertech.esper.common.internal.epl.expression.time.abacus.TimeAbacus;
import com.espertech.esper.common.internal.epl.expression.time.abacus.TimeAbacusField;
import com.espertech.esper.common.internal.epl.resultset.codegen.ResultSetProcessorCodegenNames;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class AggSvcGroupByReclaimAgedImpl {
    private static final CodegenExpressionRef REF_NEXTSWEEPTIME = CodegenExpressionBuilder.ref("nextSweepTime");
    private static final CodegenExpressionRef REF_REMOVEDCALLBACK = CodegenExpressionBuilder.ref("removedCallback");
    private static final CodegenExpressionRef REF_CURRENTMAXAGE = CodegenExpressionBuilder.ref("currentMaxAge");
    private static final CodegenExpressionRef REF_CURRENTRECLAIMFREQUENCY = CodegenExpressionBuilder.ref("currentReclaimFrequency");
    private static final CodegenExpressionRef REF_EVALUATORFUNCTIONMAXAGE = CodegenExpressionBuilder.ref("evaluationFunctionMaxAge");
    private static final CodegenExpressionRef REF_EVALUATIONFUNCTIONFREQUENCY = CodegenExpressionBuilder.ref("evaluationFunctionFrequency");
    public static final long DEFAULT_MAX_AGE_MSEC = 60000L;

    public static void rowCtorCodegen(CodegenNamedMethods namedMethods, CodegenClassScope classScope, List<CodegenTypedParam> rowMembers) {
        rowMembers.add(new CodegenTypedParam(Long.TYPE, "lastUpdateTime"));
        namedMethods.addMethod(Void.TYPE, "setLastUpdateTime", CodegenNamedParam.from(Long.TYPE, "time"), AggSvcGroupByReclaimAgedImpl.class, classScope, method -> method.getBlock().assignRef("lastUpdateTime", (CodegenExpression)CodegenExpressionBuilder.ref("time")));
        namedMethods.addMethod(Long.TYPE, "getLastUpdateTime", Collections.emptyList(), AggSvcGroupByReclaimAgedImpl.class, classScope, method -> method.getBlock().methodReturn(CodegenExpressionBuilder.ref("lastUpdateTime")));
    }

    public static void ctorCodegenReclaim(CodegenCtor ctor, List<CodegenTypedParam> explicitMembers, CodegenClassScope classScope, CodegenExpression maxAgeFactory, CodegenExpression frequencyFactory) {
        explicitMembers.add(new CodegenTypedParam(Long.class, REF_NEXTSWEEPTIME.getRef()));
        explicitMembers.add(new CodegenTypedParam(AggregationRowRemovedCallback.class, REF_REMOVEDCALLBACK.getRef()));
        explicitMembers.add(new CodegenTypedParam(Long.TYPE, REF_CURRENTMAXAGE.getRef()));
        explicitMembers.add(new CodegenTypedParam(Long.TYPE, REF_CURRENTRECLAIMFREQUENCY.getRef()));
        explicitMembers.add(new CodegenTypedParam(AggSvcGroupByReclaimAgedEvalFunc.class, REF_EVALUATORFUNCTIONMAXAGE.getRef()));
        explicitMembers.add(new CodegenTypedParam(AggSvcGroupByReclaimAgedEvalFunc.class, REF_EVALUATIONFUNCTIONFREQUENCY.getRef()));
        ctor.getBlock().assignRef(REF_CURRENTMAXAGE, CodegenExpressionBuilder.constant(60000L)).assignRef(REF_CURRENTRECLAIMFREQUENCY, CodegenExpressionBuilder.constant(60000L)).assignRef(REF_EVALUATORFUNCTIONMAXAGE, CodegenExpressionBuilder.exprDotMethod(maxAgeFactory, "make", ResultSetProcessorCodegenNames.MEMBER_AGENTINSTANCECONTEXT)).assignRef(REF_EVALUATIONFUNCTIONFREQUENCY, CodegenExpressionBuilder.exprDotMethod(frequencyFactory, "make", ResultSetProcessorCodegenNames.MEMBER_AGENTINSTANCECONTEXT));
    }

    public static void applyEnterCodegenSweep(CodegenMethod method, CodegenClassScope classScope, AggregationClassNames classNames) {
        CodegenExpressionField timeAbacus = classScope.addOrGetFieldSharable(TimeAbacusField.INSTANCE);
        method.getBlock().declareVar(Long.TYPE, "currentTime", (CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain(ExprForgeCodegenNames.REF_EXPREVALCONTEXT).add("getTimeProvider", new CodegenExpression[0]).add("getTime", new CodegenExpression[0])).ifCondition(CodegenExpressionBuilder.or(CodegenExpressionBuilder.equalsNull(REF_NEXTSWEEPTIME), CodegenExpressionBuilder.relational(REF_NEXTSWEEPTIME, CodegenExpressionRelational.CodegenRelational.LE, CodegenExpressionBuilder.ref("currentTime")), new CodegenExpression[0])).assignRef(REF_CURRENTMAXAGE, CodegenExpressionBuilder.staticMethod(AggSvcGroupByReclaimAgedImpl.class, "computeTimeReclaimAgeFreq", REF_CURRENTMAXAGE, REF_EVALUATORFUNCTIONMAXAGE, timeAbacus)).assignRef(REF_CURRENTRECLAIMFREQUENCY, CodegenExpressionBuilder.staticMethod(AggSvcGroupByReclaimAgedImpl.class, "computeTimeReclaimAgeFreq", REF_CURRENTRECLAIMFREQUENCY, REF_EVALUATIONFUNCTIONFREQUENCY, timeAbacus)).assignRef(REF_NEXTSWEEPTIME, CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("currentTime"), "+", REF_CURRENTRECLAIMFREQUENCY)).localMethod(AggSvcGroupByReclaimAgedImpl.sweepCodegen(method, classScope, classNames), CodegenExpressionBuilder.ref("currentTime"), REF_CURRENTMAXAGE);
    }

    public static long computeTimeReclaimAgeFreq(long current, AggSvcGroupByReclaimAgedEvalFunc func, TimeAbacus timeAbacus) {
        Double maxAge = func.getLongValue();
        if (maxAge == null || maxAge <= 0.0) {
            return current;
        }
        return timeAbacus.deltaForSecondsDouble(maxAge);
    }

    private static CodegenMethod sweepCodegen(CodegenMethodScope parent, CodegenClassScope classScope, AggregationClassNames classNames) {
        CodegenMethod method = parent.makeChild(Void.TYPE, AggSvcGroupByReclaimAgedImpl.class, (CodegenScope)classScope).addParam(Long.TYPE, "currentTime").addParam(Long.TYPE, REF_CURRENTMAXAGE.getRef());
        method.getBlock().declareVar(ArrayDeque.class, "removed", CodegenExpressionBuilder.newInstance(ArrayDeque.class, new CodegenExpression[0])).forEach(Map.Entry.class, "entry", CodegenExpressionBuilder.exprDotMethod(AggregationServiceGroupByForge.MEMBER_AGGREGATORSPERGROUP, "entrySet", new CodegenExpression[0])).declareVar(Long.TYPE, "age", CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("currentTime"), "-", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.cast(classNames.getRowTop(), CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("entry"), "getValue", new CodegenExpression[0])), "getLastUpdateTime", new CodegenExpression[0]))).ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("age"), CodegenExpressionRelational.CodegenRelational.GT, REF_CURRENTMAXAGE)).exprDotMethod(CodegenExpressionBuilder.ref("removed"), "add", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("entry"), "getKey", new CodegenExpression[0])).blockEnd().blockEnd().forEach(Object.class, "key", CodegenExpressionBuilder.ref("removed")).exprDotMethod(AggregationServiceGroupByForge.MEMBER_AGGREGATORSPERGROUP, "remove", CodegenExpressionBuilder.ref("key")).exprDotMethod(REF_REMOVEDCALLBACK, "removedAggregationGroupKey", CodegenExpressionBuilder.ref("key"));
        return method;
    }
}

