/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.agg.method.avedev;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMemberCol;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenCtor;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionMember;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.collection.RefCountedSet;
import com.espertech.esper.common.internal.epl.agg.core.AggregationForgeFactory;
import com.espertech.esper.common.internal.epl.agg.method.core.AggregatorCodegenUtil;
import com.espertech.esper.common.internal.epl.agg.method.core.AggregatorMethodWDistinctWFilterWValueBase;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.util.SimpleNumberCoercerFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class AggregatorAvedev
extends AggregatorMethodWDistinctWFilterWValueBase {
    private CodegenExpressionMember valueSet;
    private CodegenExpressionMember sum;

    public AggregatorAvedev(AggregationForgeFactory factory, int col, CodegenCtor rowCtor, CodegenMemberCol membersColumnized, CodegenClassScope classScope, Class optionalDistinctValueType, DataInputOutputSerdeForge optionalDistinctSerde, boolean hasFilter, ExprNode optionalFilter) {
        super(factory, col, rowCtor, membersColumnized, classScope, optionalDistinctValueType, optionalDistinctSerde, hasFilter, optionalFilter);
        this.valueSet = membersColumnized.addMember(col, RefCountedSet.class, "valueSet");
        this.sum = membersColumnized.addMember(col, Double.TYPE, "sum");
        rowCtor.getBlock().assignRef(this.valueSet, CodegenExpressionBuilder.newInstance(RefCountedSet.class, new CodegenExpression[0]));
    }

    @Override
    protected void applyEvalEnterNonNull(CodegenExpressionRef value, Class valueType, CodegenMethod method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        this.applyCodegen(true, value, valueType, method);
    }

    @Override
    protected void applyEvalLeaveNonNull(CodegenExpressionRef value, Class valueType, CodegenMethod method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        this.applyCodegen(false, value, valueType, method);
    }

    @Override
    protected void applyTableEnterNonNull(CodegenExpressionRef value, Class[] evaluationTypes, CodegenMethod method, CodegenClassScope classScope) {
        this.applyTableCodegen(true, value, method);
    }

    @Override
    protected void applyTableLeaveNonNull(CodegenExpressionRef value, Class[] evaluationTypes, CodegenMethod method, CodegenClassScope classScope) {
        this.applyTableCodegen(false, value, method);
    }

    @Override
    protected void clearWODistinct(CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().assignRef(this.sum, CodegenExpressionBuilder.constant(0)).exprDotMethod(this.valueSet, "clear", new CodegenExpression[0]);
    }

    @Override
    public void getValueCodegen(CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().methodReturn(CodegenExpressionBuilder.staticMethod(AggregatorAvedev.class, "computeAvedev", this.valueSet, this.sum));
    }

    @Override
    protected void writeWODistinct(CodegenExpressionRef row, int col, CodegenExpressionRef output, CodegenExpressionRef unitKey, CodegenExpressionRef writer, CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().apply(AggregatorCodegenUtil.writeDouble(output, row, this.sum)).staticMethod(this.getClass(), "writePoints", output, AggregatorCodegenUtil.rowDotMember(row, this.valueSet));
    }

    @Override
    protected void readWODistinct(CodegenExpressionRef row, int col, CodegenExpressionRef input, CodegenExpressionRef unitKey, CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().apply(AggregatorCodegenUtil.readDouble(row, this.sum, input)).assignRef(AggregatorCodegenUtil.rowDotMember(row, this.valueSet), CodegenExpressionBuilder.staticMethod(this.getClass(), "readPoints", input));
    }

    public static void writePoints(DataOutput output, RefCountedSet<Double> valueSet) throws IOException {
        Map<Double, Integer> refSet = valueSet.getRefSet();
        output.writeInt(refSet.size());
        output.writeInt(valueSet.getNumValues());
        for (Map.Entry<Double, Integer> entry : valueSet.getRefSet().entrySet()) {
            output.writeDouble(entry.getKey());
            output.writeInt(entry.getValue());
        }
    }

    public static RefCountedSet<Double> readPoints(DataInput input) throws IOException {
        RefCountedSet<Double> valueSet = new RefCountedSet<Double>();
        Map<Double, Integer> und = valueSet.getRefSet();
        int size = input.readInt();
        valueSet.setNumValues(input.readInt());
        for (int i = 0; i < size; ++i) {
            Double key = input.readDouble();
            Integer val = input.readInt();
            und.put(key, val);
        }
        return valueSet;
    }

    public static Object computeAvedev(RefCountedSet<Double> valueSet, double sum) {
        int datapoints = valueSet.size();
        if (datapoints == 0) {
            return null;
        }
        double total = 0.0;
        double avg = sum / (double)datapoints;
        Iterator<Map.Entry<Double, Integer>> it = valueSet.entryIterator();
        while (it.hasNext()) {
            Map.Entry<Double, Integer> entry = it.next();
            total += (double)entry.getValue().intValue() * Math.abs(entry.getKey() - avg);
        }
        return total / (double)datapoints;
    }

    private void applyCodegen(boolean enter, CodegenExpression value, Class valueType, CodegenMethod method) {
        method.getBlock().declareVar(Double.TYPE, "d", SimpleNumberCoercerFactory.SimpleNumberCoercerDouble.codegenDouble(value, valueType)).exprDotMethod(this.valueSet, enter ? "add" : "remove", CodegenExpressionBuilder.ref("d")).assignCompound(this.sum, enter ? "+" : "-", (CodegenExpression)CodegenExpressionBuilder.ref("d"));
    }

    private void applyTableCodegen(boolean enter, CodegenExpression value, CodegenMethod method) {
        method.getBlock().declareVar(Double.TYPE, "d", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.cast(Number.class, value), "doubleValue", new CodegenExpression[0])).exprDotMethod(this.valueSet, enter ? "add" : "remove", CodegenExpressionBuilder.ref("d")).assignCompound(this.sum, enter ? "+" : "-", (CodegenExpression)CodegenExpressionBuilder.ref("d"));
    }
}

