/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.agg.method.avg;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMemberCol;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenCtor;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionMember;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRelational;
import com.espertech.esper.common.internal.epl.agg.method.avg.AggregationForgeFactoryAvg;
import com.espertech.esper.common.internal.epl.agg.method.core.AggregatorCodegenUtil;
import com.espertech.esper.common.internal.epl.agg.method.core.AggregatorMethodWDistinctWFilterWValueBase;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBigDecimalBigIntegerUtil;
import com.espertech.esper.common.internal.type.MathContextCodegenField;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregatorAvgBig
extends AggregatorMethodWDistinctWFilterWValueBase {
    private static final Logger log = LoggerFactory.getLogger(AggregatorAvgBig.class);
    private final AggregationForgeFactoryAvg factory;
    private final CodegenExpressionMember sum;
    private final CodegenExpressionMember cnt;

    public AggregatorAvgBig(AggregationForgeFactoryAvg factory, int col, CodegenCtor rowCtor, CodegenMemberCol membersColumnized, CodegenClassScope classScope, Class optionalDistinctValueType, DataInputOutputSerdeForge optionalDistinctSerde, boolean hasFilter, ExprNode optionalFilter) {
        super(factory, col, rowCtor, membersColumnized, classScope, optionalDistinctValueType, optionalDistinctSerde, hasFilter, optionalFilter);
        this.factory = factory;
        this.sum = membersColumnized.addMember(col, BigDecimal.class, "sum");
        this.cnt = membersColumnized.addMember(col, Long.TYPE, "cnt");
        rowCtor.getBlock().assignRef(this.sum, CodegenExpressionBuilder.newInstance(BigDecimal.class, CodegenExpressionBuilder.constant(0.0)));
    }

    @Override
    protected void applyEvalEnterNonNull(CodegenExpressionRef value, Class valueType, CodegenMethod method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        if (valueType == BigInteger.class) {
            method.getBlock().assignRef(this.sum, CodegenExpressionBuilder.exprDotMethod(this.sum, "add", CodegenExpressionBuilder.newInstance(BigDecimal.class, value)));
        } else {
            method.getBlock().assignRef(this.sum, CodegenExpressionBuilder.exprDotMethod(this.sum, "add", valueType == BigDecimal.class ? value : CodegenExpressionBuilder.cast(BigDecimal.class, (CodegenExpression)value)));
        }
        method.getBlock().increment(this.cnt);
    }

    @Override
    protected void applyEvalLeaveNonNull(CodegenExpressionRef value, Class valueType, CodegenMethod method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        method.getBlock().ifCondition(CodegenExpressionBuilder.relational(this.cnt, CodegenExpressionRelational.CodegenRelational.LE, CodegenExpressionBuilder.constant(1))).apply(this.clearCode()).ifElse().decrement(this.cnt).apply(block -> {
            if (valueType == BigInteger.class) {
                block.assignRef(this.sum, CodegenExpressionBuilder.exprDotMethod(this.sum, "subtract", CodegenExpressionBuilder.newInstance(BigDecimal.class, value)));
            } else {
                block.assignRef(this.sum, CodegenExpressionBuilder.exprDotMethod(this.sum, "subtract", valueType == BigDecimal.class ? value : CodegenExpressionBuilder.cast(BigDecimal.class, (CodegenExpression)value)));
            }
        });
    }

    @Override
    protected void applyTableEnterNonNull(CodegenExpressionRef value, Class[] evaluationTypes, CodegenMethod method, CodegenClassScope classScope) {
        if (evaluationTypes[0] == BigInteger.class) {
            method.getBlock().assignRef(this.sum, CodegenExpressionBuilder.exprDotMethod(this.sum, "add", CodegenExpressionBuilder.newInstance(BigDecimal.class, CodegenExpressionBuilder.cast(BigInteger.class, (CodegenExpression)value))));
        } else {
            method.getBlock().assignRef(this.sum, CodegenExpressionBuilder.exprDotMethod(this.sum, "add", CodegenExpressionBuilder.cast(BigDecimal.class, (CodegenExpression)value)));
        }
        method.getBlock().increment(this.cnt);
    }

    @Override
    protected void applyTableLeaveNonNull(CodegenExpressionRef value, Class[] evaluationTypes, CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().ifCondition(CodegenExpressionBuilder.relational(this.cnt, CodegenExpressionRelational.CodegenRelational.LE, CodegenExpressionBuilder.constant(1))).apply(this.clearCode()).ifElse().decrement(this.cnt).apply(block -> {
            if (evaluationTypes[0] == BigInteger.class) {
                block.assignRef(this.sum, CodegenExpressionBuilder.exprDotMethod(this.sum, "subtract", CodegenExpressionBuilder.newInstance(BigDecimal.class, CodegenExpressionBuilder.cast(BigInteger.class, (CodegenExpression)value))));
            } else {
                block.assignRef(this.sum, CodegenExpressionBuilder.exprDotMethod(this.sum, "subtract", CodegenExpressionBuilder.cast(BigDecimal.class, (CodegenExpression)value)));
            }
        });
    }

    @Override
    protected void clearWODistinct(CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().apply(this.clearCode());
    }

    @Override
    public void getValueCodegen(CodegenMethod method, CodegenClassScope classScope) {
        CodegenExpression math = this.factory.optionalMathContext == null ? CodegenExpressionBuilder.constantNull() : classScope.addOrGetFieldSharable(new MathContextCodegenField(this.factory.optionalMathContext));
        method.getBlock().methodReturn(CodegenExpressionBuilder.staticMethod(this.getClass(), "getValueBigDecimalDivide", this.cnt, math, this.sum));
    }

    @Override
    protected void writeWODistinct(CodegenExpressionRef row, int col, CodegenExpressionRef output, CodegenExpressionRef unitKey, CodegenExpressionRef writer, CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().apply(AggregatorCodegenUtil.writeLong(output, row, this.cnt)).staticMethod(DIOBigDecimalBigIntegerUtil.class, "writeBigDec", AggregatorCodegenUtil.rowDotMember(row, this.sum), output);
    }

    @Override
    protected void readWODistinct(CodegenExpressionRef row, int col, CodegenExpressionRef input, CodegenExpressionRef unitKey, CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().apply(AggregatorCodegenUtil.readLong(row, this.cnt, input)).assignRef(AggregatorCodegenUtil.rowDotMember(row, this.sum), CodegenExpressionBuilder.staticMethod(DIOBigDecimalBigIntegerUtil.class, "readBigDec", input));
    }

    public static BigDecimal getValueBigDecimalDivide(long cnt, MathContext optionalMathContext, BigDecimal sum) {
        if (cnt == 0L) {
            return null;
        }
        try {
            if (optionalMathContext == null) {
                return sum.divide(new BigDecimal(cnt));
            }
            return sum.divide(new BigDecimal(cnt), optionalMathContext);
        }
        catch (ArithmeticException ex) {
            log.error("Error computing avg aggregation result: " + ex.getMessage(), (Throwable)ex);
            return new BigDecimal(0);
        }
    }

    private Consumer<CodegenBlock> clearCode() {
        return block -> block.assignRef(this.sum, CodegenExpressionBuilder.newInstance(BigDecimal.class, CodegenExpressionBuilder.constant(0.0))).assignRef(this.cnt, CodegenExpressionBuilder.constant(0));
    }
}

