/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.agg.method.count;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMemberCol;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenCtor;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionMember;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRelational;
import com.espertech.esper.common.internal.epl.agg.core.AggregationForgeFactory;
import com.espertech.esper.common.internal.epl.agg.method.core.AggregatorCodegenUtil;
import com.espertech.esper.common.internal.epl.agg.method.core.AggregatorMethodWDistinctWFilterBase;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import java.util.function.Consumer;

public class AggregatorCount
extends AggregatorMethodWDistinctWFilterBase {
    private final CodegenExpressionMember cnt;
    private final boolean isEver;

    public AggregatorCount(AggregationForgeFactory factory, int col, CodegenCtor rowCtor, CodegenMemberCol membersColumnized, CodegenClassScope classScope, Class optionalDistinctValueType, DataInputOutputSerdeForge optionalDistinctSerde, boolean hasFilter, ExprNode optionalFilter, boolean isEver) {
        super(factory, col, rowCtor, membersColumnized, classScope, optionalDistinctValueType, optionalDistinctSerde, hasFilter, optionalFilter);
        this.isEver = isEver;
        this.cnt = membersColumnized.addMember(col, Long.TYPE, "cnt");
    }

    @Override
    protected void applyEvalEnterFiltered(CodegenMethod method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        Consumer<CodegenBlock> increment = block -> block.increment(this.cnt);
        if (forges.length == 0 || this.optionalFilter != null && forges.length == 1) {
            method.getBlock().apply(increment);
            return;
        }
        Class evalType = forges[0].getEvaluationType();
        method.getBlock().declareVar(evalType, "value", forges[0].evaluateCodegen(evalType, method, symbols, classScope));
        if (!evalType.isPrimitive()) {
            method.getBlock().ifRefNull("value").blockReturnNoValue();
        }
        if (this.distinct != null) {
            method.getBlock().ifCondition(CodegenExpressionBuilder.not(CodegenExpressionBuilder.exprDotMethod(this.distinct, "add", this.toDistinctValueKey(CodegenExpressionBuilder.ref("value"))))).blockReturnNoValue();
        }
        method.getBlock().apply(increment);
    }

    @Override
    protected void applyTableEnterFiltered(CodegenExpressionRef value, Class[] evaluationTypes, CodegenMethod method, CodegenClassScope classScope) {
        if (this.distinct != null) {
            method.getBlock().ifCondition(CodegenExpressionBuilder.not(CodegenExpressionBuilder.exprDotMethod(this.distinct, "add", this.toDistinctValueKey(CodegenExpressionBuilder.ref("value"))))).blockReturnNoValue();
        }
        method.getBlock().increment(this.cnt);
    }

    @Override
    public void applyEvalLeaveCodegen(CodegenMethod method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        if (!this.isEver) {
            super.applyEvalLeaveCodegen(method, symbols, forges, classScope);
        }
    }

    @Override
    public void applyEvalLeaveFiltered(CodegenMethod method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        Consumer<CodegenBlock> decrement = block -> block.ifCondition(CodegenExpressionBuilder.relational(this.cnt, CodegenExpressionRelational.CodegenRelational.GT, CodegenExpressionBuilder.constant(0))).decrement(this.cnt);
        if (forges.length == 0 || this.optionalFilter != null && forges.length == 1) {
            method.getBlock().apply(decrement);
            return;
        }
        Class evalType = forges[0].getEvaluationType();
        method.getBlock().declareVar(evalType, "value", forges[0].evaluateCodegen(evalType, method, symbols, classScope));
        if (!evalType.isPrimitive()) {
            method.getBlock().ifRefNull("value").blockReturnNoValue();
        }
        if (this.distinct != null) {
            method.getBlock().ifCondition(CodegenExpressionBuilder.not(CodegenExpressionBuilder.exprDotMethod(this.distinct, "remove", this.toDistinctValueKey(CodegenExpressionBuilder.ref("value"))))).blockReturnNoValue();
        }
        method.getBlock().apply(decrement);
    }

    @Override
    protected void applyTableLeaveFiltered(CodegenExpressionRef value, Class[] evaluationTypes, CodegenMethod method, CodegenClassScope classScope) {
        if (this.distinct != null) {
            method.getBlock().ifCondition(CodegenExpressionBuilder.not(CodegenExpressionBuilder.exprDotMethod(this.distinct, "remove", this.toDistinctValueKey(CodegenExpressionBuilder.ref("value"))))).blockReturnNoValue();
        }
        method.getBlock().decrement(this.cnt);
    }

    @Override
    protected void clearWODistinct(CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().assignRef(this.cnt, CodegenExpressionBuilder.constant(0));
    }

    @Override
    public void getValueCodegen(CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().methodReturn(this.cnt);
    }

    @Override
    protected void writeWODistinct(CodegenExpressionRef row, int col, CodegenExpressionRef output, CodegenExpressionRef unitKey, CodegenExpressionRef writer, CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().apply(AggregatorCodegenUtil.writeLong(output, row, this.cnt));
    }

    @Override
    protected void readWODistinct(CodegenExpressionRef row, int col, CodegenExpressionRef input, CodegenExpressionRef unitKey, CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().apply(AggregatorCodegenUtil.readLong(row, this.cnt, input));
    }
}

