/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.agg.method.sum;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMemberCol;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenCtor;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.epl.agg.core.AggregationForgeFactory;
import com.espertech.esper.common.internal.epl.agg.method.core.AggregatorCodegenUtil;
import com.espertech.esper.common.internal.epl.agg.method.sum.AggregationForgeFactorySum;
import com.espertech.esper.common.internal.epl.agg.method.sum.AggregatorSumBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.util.SimpleNumberCoercer;
import java.util.Arrays;

public class AggregatorSumNonBig
extends AggregatorSumBase {
    public AggregatorSumNonBig(AggregationForgeFactory factory, int col, CodegenCtor rowCtor, CodegenMemberCol membersColumnized, CodegenClassScope classScope, Class optionalDistinctValueType, DataInputOutputSerdeForge optionalDistinctSerde, boolean hasFilter, ExprNode optionalFilter, Class sumType) {
        super(factory, col, rowCtor, membersColumnized, classScope, optionalDistinctValueType, optionalDistinctSerde, hasFilter, optionalFilter, sumType);
        if (!Arrays.asList(Double.class, Long.class, Integer.class, Float.class).contains(sumType)) {
            throw new IllegalArgumentException("Invalid sum type " + sumType);
        }
    }

    @Override
    protected CodegenExpression initOfSum() {
        return CodegenExpressionBuilder.constant(0);
    }

    @Override
    protected void applyAggEnterSum(CodegenExpressionRef value, Class valueType, CodegenMethod method) {
        this.applyAgg(true, value, valueType, method);
    }

    @Override
    protected void applyTableEnterSum(CodegenExpressionRef value, Class[] evaluationTypes, CodegenMethod method, CodegenClassScope classScope) {
        this.applyTable(true, value, method, classScope);
    }

    @Override
    protected void applyAggLeaveSum(CodegenExpressionRef value, Class valueType, CodegenMethod method) {
        this.applyAgg(false, value, valueType, method);
    }

    @Override
    protected void applyTableLeaveSum(CodegenExpressionRef value, Class[] evaluationTypes, CodegenMethod method, CodegenClassScope classScope) {
        this.applyTable(false, value, method, classScope);
    }

    @Override
    protected void writeSum(CodegenExpressionRef row, CodegenExpressionRef output, CodegenMethod method, CodegenClassScope classScope) {
        if (this.sumType == Double.class) {
            method.getBlock().apply(AggregatorCodegenUtil.writeDouble(output, row, this.sum));
        } else if (this.sumType == Long.class) {
            method.getBlock().apply(AggregatorCodegenUtil.writeLong(output, row, this.sum));
        } else if (this.sumType == Integer.class) {
            method.getBlock().apply(AggregatorCodegenUtil.writeInt(output, row, this.sum));
        } else if (this.sumType == Float.class) {
            method.getBlock().apply(AggregatorCodegenUtil.writeFloat(output, row, this.sum));
        } else {
            throw new IllegalStateException("Unrecognized sum type " + this.sumType);
        }
    }

    @Override
    protected void readSum(CodegenExpressionRef row, CodegenExpressionRef input, CodegenMethod method, CodegenClassScope classScope) {
        if (this.sumType == Double.class) {
            method.getBlock().apply(AggregatorCodegenUtil.readDouble(row, this.sum, input));
        } else if (this.sumType == Long.class) {
            method.getBlock().apply(AggregatorCodegenUtil.readLong(row, this.sum, input));
        } else if (this.sumType == Integer.class) {
            method.getBlock().apply(AggregatorCodegenUtil.readInt(row, this.sum, input));
        } else if (this.sumType == Float.class) {
            method.getBlock().apply(AggregatorCodegenUtil.readFloat(row, this.sum, input));
        } else {
            throw new IllegalStateException("Unrecognized sum type " + this.sumType);
        }
    }

    private void applyAgg(boolean enter, CodegenExpressionRef value, Class valueType, CodegenMethod method) {
        SimpleNumberCoercer coercer = AggregationForgeFactorySum.getCoercerNonBigIntDec(valueType);
        method.getBlock().assignRef(this.sum, CodegenExpressionBuilder.op(this.sum, enter ? "+" : "-", coercer.coerceCodegen(value, valueType)));
    }

    private void applyTable(boolean enter, CodegenExpressionRef value, CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().assignRef(this.sum, CodegenExpressionBuilder.op(this.sum, enter ? "+" : "-", CodegenExpressionBuilder.cast(this.sumType, (CodegenExpression)value)));
    }
}

