/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;

public class EPLAnnotationInvocationHandler
implements InvocationHandler {
    private final Class annotationClass;
    private String toStringResult;
    private final Map<String, Object> attributes;
    private volatile Integer hashCode;

    public EPLAnnotationInvocationHandler(Class annotationClass, Map<String, Object> attributes) {
        this.annotationClass = annotationClass;
        this.attributes = attributes;
    }

    public Class getAnnotationClass() {
        return this.annotationClass;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("equals") && args.length != 0) {
            return this.handleEquals(args[0]);
        }
        if (method.getName().equals("hashCode")) {
            return this.handleHashCode();
        }
        if (method.getName().equals("toString")) {
            if (this.toStringResult == null) {
                StringBuilder buf = new StringBuilder();
                buf.append("@");
                buf.append(this.annotationClass.getSimpleName());
                if (!this.attributes.isEmpty()) {
                    String delimiter = "";
                    buf.append("(");
                    if (this.attributes.size() == 1 && this.attributes.containsKey("value")) {
                        if (this.attributes.get("value") instanceof String) {
                            buf.append("\"");
                            buf.append(this.attributes.get("value"));
                            buf.append("\"");
                        } else {
                            buf.append(this.attributes.get("value"));
                        }
                    } else {
                        for (Map.Entry<String, Object> attribute : this.attributes.entrySet()) {
                            buf.append(delimiter);
                            buf.append(attribute.getKey());
                            buf.append("=");
                            if (attribute.getValue() instanceof String) {
                                buf.append("\"");
                                buf.append(attribute.getValue());
                                buf.append("\"");
                            } else {
                                buf.append(attribute.getValue());
                            }
                            delimiter = ", ";
                        }
                    }
                    buf.append(")");
                }
                this.toStringResult = buf.toString();
            }
            return this.toStringResult;
        }
        if (method.getName().equals("annotationType")) {
            return this.annotationClass;
        }
        if (this.attributes.containsKey(method.getName())) {
            return this.attributes.get(method.getName());
        }
        return null;
    }

    private Object handleEquals(Object arg) {
        if (this == arg) {
            return true;
        }
        if (!(arg instanceof Annotation)) {
            return false;
        }
        Annotation other = (Annotation)arg;
        if (other.annotationType() != this.annotationClass) {
            return false;
        }
        if (!Proxy.isProxyClass(arg.getClass())) {
            return false;
        }
        InvocationHandler handler = Proxy.getInvocationHandler(arg);
        if (!(handler instanceof EPLAnnotationInvocationHandler)) {
            return false;
        }
        EPLAnnotationInvocationHandler that = (EPLAnnotationInvocationHandler)handler;
        if (this.annotationClass != null ? !this.annotationClass.equals(that.annotationClass) : that.annotationClass != null) {
            return false;
        }
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            if (!that.attributes.containsKey(entry.getKey())) {
                return false;
            }
            Object thisValue = entry.getValue();
            Object thatValue = that.attributes.get(entry.getKey());
            if (!(thisValue != null ? !thisValue.equals(thatValue) : thatValue != null)) continue;
            return false;
        }
        return true;
    }

    private Object handleHashCode() {
        if (this.hashCode != null) {
            return this.hashCode;
        }
        int result = this.annotationClass.hashCode();
        for (String key : this.attributes.keySet()) {
            result = 31 * result + key.hashCode();
        }
        this.hashCode = result;
        return this.hashCode;
    }
}

