/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.approx.countminsketch;

import com.espertech.esper.common.internal.epl.approx.countminsketch.CountMinSketchSpecHashes;
import com.espertech.esper.common.internal.util.MurmurHash;
import java.util.Random;

public class CountMinSketchStateHashes {
    private int depth;
    private int width;
    private long[][] table;
    private long[] hash;
    private long total;

    public static CountMinSketchStateHashes makeState(CountMinSketchSpecHashes spec) {
        int width = (int)Math.ceil(2.0 / spec.getEpsOfTotalCount());
        int depth = (int)Math.ceil(-Math.log(1.0 - spec.getConfidence()) / Math.log(2.0));
        long[][] table = new long[depth][width];
        long[] hash = new long[depth];
        Random r = new Random(spec.getSeed());
        for (int i = 0; i < depth; ++i) {
            hash[i] = r.nextInt(Integer.MAX_VALUE);
        }
        return new CountMinSketchStateHashes(depth, width, table, hash, 0L);
    }

    public CountMinSketchStateHashes(int depth, int width, long[][] table, long[] hash, long total) {
        this.depth = depth;
        this.width = width;
        this.table = table;
        this.hash = hash;
        this.total = total;
    }

    public long[][] getTable() {
        return this.table;
    }

    public long[] getHash() {
        return this.hash;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getWidth() {
        return this.width;
    }

    public void incTotal(long count) {
        this.total += count;
    }

    public long getTotal() {
        return this.total;
    }

    public long estimateCount(byte[] item) {
        long res = Long.MAX_VALUE;
        int[] buckets = this.getHashBuckets(item, this.depth, this.width);
        for (int i = 0; i < this.depth; ++i) {
            res = Math.min(res, this.table[i][buckets[i]]);
        }
        return res;
    }

    public void add(byte[] item, long count) {
        if (count < 0L) {
            throw new IllegalArgumentException("Negative increments not implemented");
        }
        int[] buckets = this.getHashBuckets(item, this.depth, this.width);
        for (int i = 0; i < this.depth; ++i) {
            long[] lArray = this.table[i];
            int n = buckets[i];
            lArray[n] = lArray[n] + count;
        }
        this.total += count;
    }

    private int[] getHashBuckets(byte[] b, int hashCount, int max) {
        int[] result = new int[hashCount];
        int hash1 = MurmurHash.hash(b, 0, b.length, 0);
        int hash2 = MurmurHash.hash(b, 0, b.length, hash1);
        for (int i = 0; i < hashCount; ++i) {
            result[i] = Math.abs((hash1 + i * hash2) % max);
        }
        return result;
    }
}

