/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.classprovided.compiletime;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.hook.aggfunc.ExtensionAggregationFunction;
import com.espertech.esper.common.client.hook.aggmultifunc.ExtensionAggregationMultiFunction;
import com.espertech.esper.common.client.hook.singlerowfunc.ExtensionSingleRowFunction;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.collection.PathException;
import com.espertech.esper.common.internal.collection.PathRegistry;
import com.espertech.esper.common.internal.collection.PathRegistryObjectType;
import com.espertech.esper.common.internal.context.module.ModuleDependenciesCompileTime;
import com.espertech.esper.common.internal.epl.classprovided.compiletime.ClassProvidedCompileTimeRegistry;
import com.espertech.esper.common.internal.epl.classprovided.compiletime.ClassProvidedCompileTimeResolver;
import com.espertech.esper.common.internal.epl.classprovided.core.ClassProvided;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.util.CompileTimeResolver;
import com.espertech.esper.common.internal.settings.ClasspathImportSingleRowDesc;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

public class ClassProvidedCompileTimeResolverImpl
implements ClassProvidedCompileTimeResolver {
    private final String moduleName;
    private final Set<String> moduleUses;
    private final ClassProvidedCompileTimeRegistry locals;
    private final PathRegistry<String, ClassProvided> path;
    private final ModuleDependenciesCompileTime moduleDependencies;
    private final boolean isFireAndForget;

    public ClassProvidedCompileTimeResolverImpl(String moduleName, Set<String> moduleUses, ClassProvidedCompileTimeRegistry locals, PathRegistry<String, ClassProvided> path, ModuleDependenciesCompileTime moduleDependencies, boolean isFireAndForget) {
        this.moduleName = moduleName;
        this.moduleUses = moduleUses;
        this.locals = locals;
        this.path = path;
        this.moduleDependencies = moduleDependencies;
        this.isFireAndForget = isFireAndForget;
    }

    @Override
    public ClassProvided resolveClass(String name) {
        ClassProvided localExpr = this.locals.getClasses().get(name);
        if (localExpr != null) {
            return localExpr;
        }
        try {
            Pair<ClassProvided, String> expression = this.path.getAnyModuleExpectSingle(name, this.moduleUses);
            if (expression != null) {
                if (!this.isFireAndForget && !NameAccessModifier.visible(expression.getFirst().getVisibility(), expression.getFirst().getModuleName(), this.moduleName)) {
                    return null;
                }
                this.moduleDependencies.addPathClass(name, expression.getSecond());
                return expression.getFirst();
            }
        }
        catch (PathException e) {
            throw CompileTimeResolver.makePathAmbiguous(PathRegistryObjectType.CLASSPROVIDED, name, e);
        }
        return null;
    }

    @Override
    public Pair<Class, ClasspathImportSingleRowDesc> resolveSingleRow(String name) {
        Pair<Class, ExtensionSingleRowFunction> pair = ClassProvidedCompileTimeResolverImpl.resolveFromLocalAndPath(name, this.locals, this.path, ExtensionSingleRowFunction.class, "single-row function", this.moduleUses, this.moduleDependencies, anno -> Collections.singleton(anno.name()));
        return pair == null ? null : new Pair<Class, ClasspathImportSingleRowDesc>(pair.getFirst(), new ClasspathImportSingleRowDesc(pair.getFirst(), pair.getSecond()));
    }

    @Override
    public Class resolveAggregationFunction(String name) {
        Pair<Class, ExtensionAggregationFunction> pair = ClassProvidedCompileTimeResolverImpl.resolveFromLocalAndPath(name, this.locals, this.path, ExtensionAggregationFunction.class, "aggregation function", this.moduleUses, this.moduleDependencies, anno -> Collections.singleton(anno.name()));
        return pair == null ? null : pair.getFirst();
    }

    @Override
    public Pair<Class, String[]> resolveAggregationMultiFunction(String name) {
        Function<ExtensionAggregationMultiFunction, Set> nameProvision = anno -> {
            String[] split;
            HashSet<String> names = new HashSet<String>(2);
            for (String nameprovided : split = anno.names().split(",")) {
                names.add(nameprovided.trim());
            }
            return names;
        };
        Pair<Class, ExtensionAggregationMultiFunction> pair = ClassProvidedCompileTimeResolverImpl.resolveFromLocalAndPath(name, this.locals, this.path, ExtensionAggregationMultiFunction.class, "aggregation multi-function", this.moduleUses, this.moduleDependencies, nameProvision);
        return pair == null ? null : new Pair<Class, String[]>(pair.getFirst(), pair.getSecond().names().split(","));
    }

    @Override
    public boolean isEmpty() {
        return this.path.isEmpty() && this.locals.getClasses().isEmpty();
    }

    @Override
    public void addTo(Map<String, byte[]> additionalClasses) {
        this.path.traverse(cp -> additionalClasses.putAll(cp.getBytes()));
    }

    @Override
    public void removeFrom(Map<String, byte[]> moduleBytes) {
        Consumer<ClassProvided> classProvidedByteCodeRemover = item -> {
            for (Map.Entry<String, byte[]> entry : item.getBytes().entrySet()) {
                moduleBytes.remove(entry.getKey());
            }
        };
        this.path.traverse(classProvidedByteCodeRemover);
    }

    private static <T> Pair<Class, T> resolveFromLocalAndPath(String soughtName, ClassProvidedCompileTimeRegistry locals, PathRegistry<String, ClassProvided> path, Class<T> annotationType, String objectName, Set<String> moduleUses, ModuleDependenciesCompileTime moduleDependencies, Function<T, Set<String>> namesProvider) {
        if (locals.getClasses().isEmpty() && path.isEmpty()) {
            return null;
        }
        try {
            Pair<Class, T> localPair = ClassProvidedCompileTimeResolverImpl.resolveFromLocal(soughtName, locals, annotationType, objectName, namesProvider);
            if (localPair != null) {
                return localPair;
            }
            return ClassProvidedCompileTimeResolverImpl.resolveFromPath(soughtName, path, annotationType, objectName, moduleUses, moduleDependencies, namesProvider);
        }
        catch (ExprValidationException ex) {
            throw new EPException(ex.getMessage(), ex);
        }
    }

    private static <T> Pair<Class, T> resolveFromLocal(String soughtName, ClassProvidedCompileTimeRegistry locals, Class annotationType, String objectName, Function<T, Set<String>> namesProvider) throws ExprValidationException {
        ArrayList foundLocal = new ArrayList(2);
        for (Map.Entry<String, ClassProvided> entry : locals.getClasses().entrySet()) {
            JavaClassHelper.traverseAnnotations(entry.getValue().getClassesMayNull(), annotationType, (clazz, annotation) -> {
                Object t = annotation;
                Set names = (Set)namesProvider.apply(t);
                for (String name : names) {
                    if (!soughtName.equals(name)) continue;
                    foundLocal.add(new Pair<Class, Object>((Class)clazz, t));
                }
            });
        }
        if (foundLocal.size() > 1) {
            throw ClassProvidedCompileTimeResolverImpl.getDuplicateSingleRow(soughtName, objectName);
        }
        if (foundLocal.size() == 1) {
            return (Pair)foundLocal.get(0);
        }
        return null;
    }

    private static <T> Pair<Class, T> resolveFromPath(String soughtName, PathRegistry<String, ClassProvided> path, Class annotationType, String objectName, Set<String> moduleUses, ModuleDependenciesCompileTime moduleDependencies, Function<T, Set<String>> namesProvider) throws ExprValidationException {
        PathFunc foundPathFunc;
        ArrayList foundPath = new ArrayList(2);
        path.traverseWithModule((moduleName, classProvided) -> JavaClassHelper.traverseAnnotations(classProvided.getClassesMayNull(), annotationType, (clazz, annotation) -> {
            Object t = annotation;
            Set names = (Set)namesProvider.apply(t);
            for (String name : names) {
                if (!soughtName.equals(name)) continue;
                foundPath.add(new PathFunc<Object>((String)moduleName, (Class)clazz, t));
            }
        }));
        if (foundPath.isEmpty()) {
            return null;
        }
        if (foundPath.size() == 1) {
            foundPathFunc = (PathFunc)foundPath.get(0);
        } else {
            if (moduleUses == null || moduleUses.isEmpty()) {
                throw ClassProvidedCompileTimeResolverImpl.getDuplicateSingleRow(soughtName, objectName);
            }
            ArrayList<PathFunc> matchesUses = new ArrayList<PathFunc>(2);
            for (PathFunc func : foundPath) {
                if (!moduleUses.contains(func.optionalModuleName)) continue;
                matchesUses.add(func);
            }
            if (matchesUses.size() > 1) {
                throw ClassProvidedCompileTimeResolverImpl.getDuplicateSingleRow(soughtName, objectName);
            }
            if (matchesUses.isEmpty()) {
                return null;
            }
            foundPathFunc = (PathFunc)matchesUses.get(0);
        }
        moduleDependencies.addPathClass(foundPathFunc.getClazz().getName(), foundPathFunc.getOptionalModuleName());
        return new Pair<Class, Object>(foundPathFunc.getClazz(), foundPathFunc.annotation);
    }

    private static ExprValidationException getDuplicateSingleRow(String name, String objectName) {
        return new ExprValidationException("The plug-in " + objectName + " '" + name + "' occurs multiple times");
    }

    private static class PathFunc<T> {
        private final String optionalModuleName;
        private final Class clazz;
        private final T annotation;

        public PathFunc(String optionalModuleName, Class clazz, T annotation) {
            this.optionalModuleName = optionalModuleName;
            this.clazz = clazz;
            this.annotation = annotation;
        }

        public String getOptionalModuleName() {
            return this.optionalModuleName;
        }

        public Class getClazz() {
            return this.clazz;
        }

        public T getAnnotation() {
            return this.annotation;
        }
    }
}

