/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.classprovided.compiletime;

import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationIDGenerator;
import com.espertech.esper.common.internal.compile.stage1.CompilerServicesCompileException;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.context.util.ByteArrayProvidingClassLoader;
import com.espertech.esper.common.internal.epl.classprovided.compiletime.ClassProvidedPrecompileResult;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClassProvidedPrecompileUtil {
    public static ClassProvidedPrecompileResult compileClassProvided(List<String> classTexts, StatementCompileTimeServices compileTimeServices, ClassProvidedPrecompileResult optionalPrior) throws ExprValidationException {
        if (classTexts == null || classTexts.isEmpty()) {
            return ClassProvidedPrecompileResult.EMPTY;
        }
        if (!compileTimeServices.getConfiguration().getCompiler().getByteCode().isAllowInlinedClass()) {
            throw new ExprValidationException("Inlined-class compilation has been disabled by configuration");
        }
        int index = -1;
        HashMap<String, byte[]> allBytes = new HashMap<String, byte[]>();
        ArrayList<Class> allClasses = new ArrayList<Class>();
        if (optionalPrior != null) {
            allBytes.putAll(optionalPrior.getBytes());
        }
        ByteArrayProvidingClassLoader cl = new ByteArrayProvidingClassLoader(allBytes, (ClassLoader)compileTimeServices.getServices().getParentClassLoader());
        for (String classText : classTexts) {
            if (classText.trim().isEmpty()) continue;
            String className = "provided_" + ++index + "_" + CodeGenerationIDGenerator.generateClassNameUUID();
            HashMap<String, byte[]> output = new HashMap<String, byte[]>();
            try {
                compileTimeServices.getCompilerServices().compileClass(classText, className, allBytes, output, compileTimeServices.getServices());
            }
            catch (CompilerServicesCompileException ex) {
                throw ClassProvidedPrecompileUtil.handleException(ex, "Failed to compile class", classText);
            }
            for (Map.Entry entry : output.entrySet()) {
                if (!allBytes.containsKey(entry.getKey())) continue;
                throw new ExprValidationException("Duplicate class by name '" + (String)entry.getKey() + "'");
            }
            allBytes.putAll(output);
            ArrayList classes = new ArrayList(2);
            for (Map.Entry entry : output.entrySet()) {
                try {
                    Class<?> clazz = Class.forName((String)entry.getKey(), false, cl);
                    classes.add(clazz);
                }
                catch (ClassNotFoundException | RuntimeException e) {
                    throw ClassProvidedPrecompileUtil.handleException(e, "Failed to load class '" + (String)entry.getKey() + "'", classText);
                }
            }
            allClasses.addAll(classes);
        }
        return new ClassProvidedPrecompileResult(allBytes, allClasses);
    }

    private static ExprValidationException handleException(Exception ex, String action, String classText) {
        return new ExprValidationException(action + ": " + ex.getMessage() + " for class [\"\"\"" + classText + "\"\"\"]", ex);
    }
}

