/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.classprovided.core;

import com.espertech.esper.common.internal.collection.PathDeploymentEntry;
import com.espertech.esper.common.internal.collection.PathRegistry;
import com.espertech.esper.common.internal.context.util.ByteArrayProvidingClassLoader;
import com.espertech.esper.common.internal.epl.classprovided.core.ClassProvided;
import com.espertech.esper.common.internal.type.NameAndModule;
import java.util.Map;

public class ClassProvidedImportClassLoader
extends ByteArrayProvidingClassLoader {
    private final PathRegistry<String, ClassProvided> pathRegistry;
    private NameAndModule[] imported;

    public ClassProvidedImportClassLoader(Map<String, byte[]> classes, ClassLoader parent, PathRegistry<String, ClassProvided> pathRegistry) {
        super(classes, parent);
        this.pathRegistry = pathRegistry;
    }

    public void setImported(NameAndModule[] imported) {
        this.imported = imported;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        assert (name != null);
        if (this.imported == null || this.imported.length == 0) {
            return super.findClass(name);
        }
        for (NameAndModule nameAndModule : this.imported) {
            PathDeploymentEntry<ClassProvided> entry = this.pathRegistry.getEntryWithModule(nameAndModule.getName(), nameAndModule.getModuleName());
            for (Class clazz : entry.getEntity().getClassesMayNull()) {
                if (!clazz.getName().equals(name)) continue;
                return clazz;
            }
        }
        return super.findClass(name);
    }
}

