/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.contained;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.contained.ContainedEventEval;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityEvaluate;
import java.util.ArrayDeque;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyEvaluatorAccumulative {
    private static final Logger log = LoggerFactory.getLogger(PropertyEvaluatorAccumulative.class);
    private ContainedEventEval[] containedEventEvals;
    private boolean[] fragmentEventTypeIsIndexed;
    private ExprEvaluator[] whereClauses;
    private String[] propertyNames;

    public void setPropertyNames(String[] propertyNames) {
        this.propertyNames = propertyNames;
    }

    public void setContainedEventEvals(ContainedEventEval[] containedEventEvals) {
        this.containedEventEvals = containedEventEvals;
    }

    public void setFragmentEventTypeIsIndexed(boolean[] fragmentEventTypeIsIndexed) {
        this.fragmentEventTypeIsIndexed = fragmentEventTypeIsIndexed;
    }

    public void setWhereClauses(ExprEvaluator[] whereClauses) {
        this.whereClauses = whereClauses;
    }

    public ArrayDeque<EventBean[]> getAccumulative(EventBean theEvent, ExprEvaluatorContext exprEvaluatorContext) {
        ArrayDeque<EventBean[]> resultEvents = new ArrayDeque<EventBean[]>();
        EventBean[] eventsPerStream = new EventBean[this.fragmentEventTypeIsIndexed.length + 1];
        eventsPerStream[0] = theEvent;
        this.populateEvents(eventsPerStream, theEvent, 0, resultEvents, exprEvaluatorContext);
        if (resultEvents.isEmpty()) {
            return null;
        }
        return resultEvents;
    }

    private void populateEvents(EventBean[] eventsPerStream, EventBean branch, int level, Collection<EventBean[]> events, ExprEvaluatorContext exprEvaluatorContext) {
        try {
            Object result = this.containedEventEvals[level].getFragment(branch, eventsPerStream, exprEvaluatorContext);
            int lastLevel = this.fragmentEventTypeIsIndexed.length - 1;
            int levels = this.fragmentEventTypeIsIndexed.length + 1;
            if (this.fragmentEventTypeIsIndexed[level]) {
                EventBean[] fragments = (EventBean[])result;
                if (level == lastLevel) {
                    if (this.whereClauses[level] != null) {
                        EventBean[] eventBeanArray = fragments;
                        int n = eventBeanArray.length;
                        for (int i = 0; i < n; ++i) {
                            EventBean theEvent;
                            eventsPerStream[level + 1] = theEvent = eventBeanArray[i];
                            if (!ExprNodeUtilityEvaluate.applyFilterExpression(this.whereClauses[level], eventsPerStream, exprEvaluatorContext)) continue;
                            EventBean[] eventsPerRow = new EventBean[levels];
                            System.arraycopy(eventsPerStream, 0, eventsPerRow, 0, levels);
                            events.add(eventsPerRow);
                        }
                    } else {
                        EventBean[] eventBeanArray = fragments;
                        int n = eventBeanArray.length;
                        for (int i = 0; i < n; ++i) {
                            EventBean theEvent;
                            eventsPerStream[level + 1] = theEvent = eventBeanArray[i];
                            EventBean[] eventsPerRow = new EventBean[levels];
                            System.arraycopy(eventsPerStream, 0, eventsPerRow, 0, levels);
                            events.add(eventsPerRow);
                        }
                    }
                } else if (this.whereClauses[level] != null) {
                    EventBean[] eventBeanArray = fragments;
                    int n = eventBeanArray.length;
                    for (int i = 0; i < n; ++i) {
                        EventBean next;
                        eventsPerStream[level + 1] = next = eventBeanArray[i];
                        if (!ExprNodeUtilityEvaluate.applyFilterExpression(this.whereClauses[level], eventsPerStream, exprEvaluatorContext)) continue;
                        this.populateEvents(eventsPerStream, next, level + 1, events, exprEvaluatorContext);
                    }
                } else {
                    EventBean[] eventBeanArray = fragments;
                    int n = eventBeanArray.length;
                    for (int i = 0; i < n; ++i) {
                        EventBean next;
                        eventsPerStream[level + 1] = next = eventBeanArray[i];
                        this.populateEvents(eventsPerStream, next, level + 1, events, exprEvaluatorContext);
                    }
                }
            } else {
                EventBean fragment = (EventBean)result;
                if (level == lastLevel) {
                    if (this.whereClauses[level] != null) {
                        eventsPerStream[level + 1] = fragment;
                        if (ExprNodeUtilityEvaluate.applyFilterExpression(this.whereClauses[level], eventsPerStream, exprEvaluatorContext)) {
                            EventBean[] eventsPerRow = new EventBean[levels];
                            System.arraycopy(eventsPerStream, 0, eventsPerRow, 0, levels);
                            events.add(eventsPerRow);
                        }
                    } else {
                        eventsPerStream[level + 1] = fragment;
                        EventBean[] eventsPerRow = new EventBean[levels];
                        System.arraycopy(eventsPerStream, 0, eventsPerRow, 0, levels);
                        events.add(eventsPerRow);
                    }
                } else if (this.whereClauses[level] != null) {
                    eventsPerStream[level + 1] = fragment;
                    if (ExprNodeUtilityEvaluate.applyFilterExpression(this.whereClauses[level], eventsPerStream, exprEvaluatorContext)) {
                        this.populateEvents(eventsPerStream, fragment, level + 1, events, exprEvaluatorContext);
                    }
                } else {
                    eventsPerStream[level + 1] = fragment;
                    this.populateEvents(eventsPerStream, fragment, level + 1, events, exprEvaluatorContext);
                }
            }
        }
        catch (RuntimeException ex) {
            String message = "Unexpected error evaluating property expression for event of type '" + branch.getEventType().getName() + "' and property '" + this.propertyNames[level + 1] + "': " + ex.getMessage();
            throw new EPException(message, ex);
        }
    }
}

