/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.dataflow.runnables;

import com.espertech.esper.common.client.dataflow.core.EPDataFlowExceptionContext;
import com.espertech.esper.common.client.dataflow.core.EPDataFlowExceptionHandler;
import com.espertech.esper.common.client.dataflow.util.EPDataFlowSignal;
import com.espertech.esper.common.client.dataflow.util.EPDataFlowSignalFinalMarker;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowSourceOperator;
import com.espertech.esper.common.internal.epl.dataflow.runnables.BaseRunnable;
import com.espertech.esper.common.internal.epl.dataflow.runnables.CompletionListener;
import com.espertech.esper.common.internal.epl.dataflow.util.DataFlowSignalListener;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphSourceRunnable
implements BaseRunnable,
DataFlowSignalListener {
    private static final Logger log = LoggerFactory.getLogger(GraphSourceRunnable.class);
    private final AgentInstanceContext agentInstanceContext;
    private final DataFlowSourceOperator graphSource;
    private final String dataFlowName;
    private final String instanceId;
    private final String operatorName;
    private final int operatorNumber;
    private final String operatorPrettyPrint;
    private final EPDataFlowExceptionHandler optionalExceptionHandler;
    private final boolean audit;
    private boolean shutdown;
    private List<CompletionListener> completionListeners;

    public GraphSourceRunnable(AgentInstanceContext agentInstanceContext, DataFlowSourceOperator graphSource, String dataFlowName, String instanceId, String operatorName, int operatorNumber, String operatorPrettyPrint, EPDataFlowExceptionHandler optionalExceptionHandler, boolean audit) {
        this.agentInstanceContext = agentInstanceContext;
        this.graphSource = graphSource;
        this.dataFlowName = dataFlowName;
        this.instanceId = instanceId;
        this.operatorName = operatorName;
        this.operatorNumber = operatorNumber;
        this.operatorPrettyPrint = operatorPrettyPrint;
        this.optionalExceptionHandler = optionalExceptionHandler;
        this.audit = audit;
    }

    @Override
    public void processSignal(EPDataFlowSignal signal) {
        if (signal instanceof EPDataFlowSignalFinalMarker) {
            this.shutdown = true;
        }
    }

    @Override
    public void run() {
        try {
            this.runLoop();
        }
        catch (InterruptedException ex) {
            log.debug("Interruped runnable: " + ex.getMessage(), (Throwable)ex);
        }
        catch (RuntimeException ex) {
            log.error("Exception encountered: " + ex.getMessage(), (Throwable)ex);
            this.handleException(ex);
        }
        this.invokeCompletionListeners();
    }

    public void runSync() throws InterruptedException {
        try {
            this.runLoop();
        }
        catch (InterruptedException ex) {
            log.debug("Interruped runnable: " + ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            log.error("Exception encountered: " + ex.getMessage(), (Throwable)ex);
            this.handleException(ex);
            throw ex;
        }
    }

    private void handleException(RuntimeException ex) {
        if (this.optionalExceptionHandler == null) {
            return;
        }
        this.optionalExceptionHandler.handle(new EPDataFlowExceptionContext(this.dataFlowName, this.operatorName, this.operatorNumber, this.operatorPrettyPrint, ex));
    }

    private void runLoop() throws InterruptedException {
        do {
            this.agentInstanceContext.getAuditProvider().dataflowSource(this.dataFlowName, this.instanceId, this.operatorName, this.operatorNumber, this.agentInstanceContext);
            this.graphSource.next();
        } while (!this.shutdown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeCompletionListeners() {
        GraphSourceRunnable graphSourceRunnable = this;
        synchronized (graphSourceRunnable) {
            if (this.completionListeners != null) {
                for (CompletionListener listener : this.completionListeners) {
                    listener.completed();
                }
            }
        }
    }

    public synchronized void addCompletionListener(CompletionListener completionListener) {
        if (this.completionListeners == null) {
            this.completionListeners = new ArrayList<CompletionListener>();
        }
        this.completionListeners.add(completionListener);
    }

    public void next() throws InterruptedException {
        this.agentInstanceContext.getAuditProvider().dataflowSource(this.dataFlowName, this.instanceId, this.operatorName, this.operatorNumber, this.agentInstanceContext);
        this.graphSource.next();
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }
}

