/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.dataflow.util;

import com.espertech.esper.common.client.dataflow.annotations.DataFlowContext;
import com.espertech.esper.common.client.dataflow.util.EPDataFlowSignalFinalMarker;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOpCloseContext;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOpOpenContext;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowSourceOperator;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.EPDataFlowEmitter;
import java.util.concurrent.CountDownLatch;

public class DefaultSupportSourceOp
implements DataFlowSourceOperator {
    public Object[] instructions;
    @DataFlowContext
    private EPDataFlowEmitter graphContext;
    private int currentCount = -1;

    public DefaultSupportSourceOp() {
        this.instructions = new Object[0];
    }

    public DefaultSupportSourceOp(Object[] instructions) {
        this.instructions = instructions;
    }

    public int getCurrentCount() {
        return this.currentCount;
    }

    @Override
    public void next() throws InterruptedException {
        ++this.currentCount;
        if (this.instructions.length <= this.currentCount) {
            this.graphContext.submitSignal(new EPDataFlowSignalFinalMarker(){});
            return;
        }
        Object next = this.instructions[this.currentCount];
        if (next instanceof CountDownLatch) {
            CountDownLatch latch = (CountDownLatch)next;
            latch.await();
        } else if (next instanceof Long) {
            long sleepTime = (Long)next;
            Thread.sleep(sleepTime);
        } else {
            if (next instanceof RuntimeException) {
                RuntimeException ex = (RuntimeException)next;
                throw new RuntimeException("Support-graph-source generated exception: " + ex.getMessage(), ex);
            }
            this.graphContext.submit(next);
        }
    }

    @Override
    public void open(DataFlowOpOpenContext openContext) {
    }

    @Override
    public void close(DataFlowOpCloseContext openContext) {
    }
}

