/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.datetime.reformatop;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.epl.datetime.eval.DatetimeLongCoercer;
import com.espertech.esper.common.internal.epl.datetime.eval.DatetimeLongCoercerFactory;
import com.espertech.esper.common.internal.epl.datetime.eval.DatetimeMethodDesc;
import com.espertech.esper.common.internal.epl.datetime.eval.FilterExprAnalyzerDTBetweenAffector;
import com.espertech.esper.common.internal.epl.datetime.reformatop.ReformatBetweenNonConstantParamsForgeOp;
import com.espertech.esper.common.internal.epl.datetime.reformatop.ReformatForge;
import com.espertech.esper.common.internal.epl.datetime.reformatop.ReformatOp;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeFilterAnalyzerInput;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeFilterAnalyzerInputProp;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeFilterAnalyzerInputStream;
import com.espertech.esper.common.internal.epl.join.analyze.FilterExprAnalyzerAffector;
import java.util.List;

public class ReformatBetweenNonConstantParamsForge
implements ReformatForge {
    protected final ExprNode start;
    protected final DatetimeLongCoercer startCoercer;
    protected final ExprNode end;
    protected final DatetimeLongCoercer secondCoercer;
    protected boolean includeBoth;
    protected Boolean includeLow;
    protected Boolean includeHigh;
    protected ExprForge forgeIncludeLow;
    protected ExprForge forgeIncludeHigh;

    public ReformatBetweenNonConstantParamsForge(List<ExprNode> parameters) throws ExprValidationException {
        this.start = parameters.get(0);
        this.startCoercer = DatetimeLongCoercerFactory.getCoercer(this.start.getForge().getEvaluationType());
        this.end = parameters.get(1);
        this.secondCoercer = DatetimeLongCoercerFactory.getCoercer(this.end.getForge().getEvaluationType());
        if (parameters.size() == 2) {
            this.includeBoth = true;
            this.includeLow = true;
            this.includeHigh = true;
        } else {
            if (parameters.get(2).getForge().getForgeConstantType().isCompileTimeConstant()) {
                this.includeLow = this.getBooleanValue(parameters.get(2));
            } else {
                this.forgeIncludeLow = parameters.get(2).getForge();
            }
            if (parameters.get(3).getForge().getForgeConstantType().isCompileTimeConstant()) {
                this.includeHigh = this.getBooleanValue(parameters.get(3));
            } else {
                this.forgeIncludeHigh = parameters.get(3).getForge();
            }
            if (this.includeLow != null && this.includeHigh != null && this.includeLow.booleanValue() && this.includeHigh.booleanValue()) {
                this.includeBoth = true;
            }
        }
    }

    @Override
    public ReformatOp getOp() {
        return new ReformatBetweenNonConstantParamsForgeOp(this, this.start.getForge().getExprEvaluator(), this.end.getForge().getExprEvaluator(), this.forgeIncludeLow == null ? null : this.forgeIncludeLow.getExprEvaluator(), this.forgeIncludeHigh == null ? null : this.forgeIncludeHigh.getExprEvaluator());
    }

    @Override
    public CodegenExpression codegenLong(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return ReformatBetweenNonConstantParamsForgeOp.codegenLong(this, inner, codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public CodegenExpression codegenDate(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return ReformatBetweenNonConstantParamsForgeOp.codegenDate(this, inner, codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public CodegenExpression codegenCal(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return ReformatBetweenNonConstantParamsForgeOp.codegenCal(this, inner, codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public CodegenExpression codegenLDT(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return ReformatBetweenNonConstantParamsForgeOp.codegenLDT(this, inner, codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public CodegenExpression codegenZDT(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return ReformatBetweenNonConstantParamsForgeOp.codegenZDT(this, inner, codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public Class getReturnType() {
        return Boolean.class;
    }

    @Override
    public FilterExprAnalyzerAffector getFilterDesc(EventType[] typesPerStream, DatetimeMethodDesc currentMethod, List<ExprNode> currentParameters, ExprDotNodeFilterAnalyzerInput inputDesc) {
        String targetProperty;
        int targetStreamNum;
        if (this.includeLow == null || this.includeHigh == null) {
            return null;
        }
        if (inputDesc instanceof ExprDotNodeFilterAnalyzerInputStream) {
            ExprDotNodeFilterAnalyzerInputStream targetStream = (ExprDotNodeFilterAnalyzerInputStream)inputDesc;
            targetStreamNum = targetStream.getStreamNum();
            EventType targetType = typesPerStream[targetStreamNum];
            targetProperty = targetType.getStartTimestampPropertyName();
        } else if (inputDesc instanceof ExprDotNodeFilterAnalyzerInputProp) {
            ExprDotNodeFilterAnalyzerInputProp targetStream = (ExprDotNodeFilterAnalyzerInputProp)inputDesc;
            targetStreamNum = targetStream.getStreamNum();
            targetProperty = targetStream.getPropertyName();
        } else {
            return null;
        }
        return new FilterExprAnalyzerDTBetweenAffector(typesPerStream, targetStreamNum, targetProperty, this.start, this.end, this.includeLow, this.includeHigh);
    }

    private boolean getBooleanValue(ExprNode exprNode) throws ExprValidationException {
        Object value = exprNode.getForge().getExprEvaluator().evaluate(null, true, null);
        if (value == null) {
            throw new ExprValidationException("Date-time method 'between' requires non-null parameter values");
        }
        return (Boolean)value;
    }
}

