/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.datetime.reformatop;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.epl.datetime.calop.CalendarFieldEnum;
import com.espertech.esper.common.internal.epl.datetime.eval.DatetimeMethodDesc;
import com.espertech.esper.common.internal.epl.datetime.reformatop.ReformatForge;
import com.espertech.esper.common.internal.epl.datetime.reformatop.ReformatOp;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeFilterAnalyzerInput;
import com.espertech.esper.common.internal.epl.expression.time.abacus.TimeAbacus;
import com.espertech.esper.common.internal.epl.join.analyze.FilterExprAnalyzerAffector;
import com.espertech.esper.common.internal.settings.RuntimeSettingsTimeZoneField;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class ReformatGetFieldForge
implements ReformatForge,
ReformatOp {
    private final CalendarFieldEnum fieldNum;
    private final TimeAbacus timeAbacus;

    public ReformatGetFieldForge(CalendarFieldEnum fieldNum, TimeAbacus timeAbacus) {
        this.fieldNum = fieldNum;
        this.timeAbacus = timeAbacus;
    }

    @Override
    public ReformatOp getOp() {
        return this;
    }

    @Override
    public Object evaluate(Long ts, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        Calendar cal = Calendar.getInstance();
        this.timeAbacus.calendarSet(ts, cal);
        return this.action(cal);
    }

    @Override
    public CodegenExpression codegenLong(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethod methodNode = codegenMethodScope.makeChild(Integer.TYPE, ReformatGetFieldForge.class, (CodegenScope)codegenClassScope).addParam(Long.TYPE, "ts");
        CodegenExpressionField timeZoneField = codegenClassScope.addOrGetFieldSharable(RuntimeSettingsTimeZoneField.INSTANCE);
        methodNode.getBlock().declareVar(Calendar.class, "cal", CodegenExpressionBuilder.staticMethod(Calendar.class, "getInstance", timeZoneField)).expression(this.timeAbacus.calendarSetCodegen(CodegenExpressionBuilder.ref("ts"), CodegenExpressionBuilder.ref("cal"), methodNode, codegenClassScope)).methodReturn(this.actionCodegen(CodegenExpressionBuilder.ref("cal")));
        return CodegenExpressionBuilder.localMethod(methodNode, inner);
    }

    @Override
    public Object evaluate(Date d, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(d.getTime());
        return this.action(cal);
    }

    @Override
    public CodegenExpression codegenDate(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenExpressionField timeZoneField = codegenClassScope.addOrGetFieldSharable(RuntimeSettingsTimeZoneField.INSTANCE);
        CodegenMethod methodNode = codegenMethodScope.makeChild(Integer.TYPE, ReformatGetFieldForge.class, (CodegenScope)codegenClassScope).addParam(Date.class, "d");
        methodNode.getBlock().declareVar(Calendar.class, "cal", CodegenExpressionBuilder.staticMethod(Calendar.class, "getInstance", timeZoneField)).exprDotMethod(CodegenExpressionBuilder.ref("cal"), "setTimeInMillis", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("d"), "getTime", new CodegenExpression[0])).methodReturn(this.actionCodegen(CodegenExpressionBuilder.ref("cal")));
        return CodegenExpressionBuilder.localMethod(methodNode, inner);
    }

    @Override
    public Object evaluate(Calendar cal, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.action(cal);
    }

    @Override
    public CodegenExpression codegenCal(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return this.actionCodegen(inner);
    }

    @Override
    public Object evaluate(LocalDateTime ldt, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        return ldt.get(this.fieldNum.getChronoField());
    }

    @Override
    public CodegenExpression codegenLDT(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return this.codegenJava8Get(inner);
    }

    @Override
    public Object evaluate(ZonedDateTime zdt, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        return zdt.get(this.fieldNum.getChronoField());
    }

    @Override
    public CodegenExpression codegenZDT(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return this.codegenJava8Get(inner);
    }

    @Override
    public Class getReturnType() {
        return Integer.class;
    }

    @Override
    public FilterExprAnalyzerAffector getFilterDesc(EventType[] typesPerStream, DatetimeMethodDesc currentMethod, List<ExprNode> currentParameters, ExprDotNodeFilterAnalyzerInput inputDesc) {
        return null;
    }

    private int action(Calendar cal) {
        return cal.get(this.fieldNum.getCalendarField());
    }

    private CodegenExpression actionCodegen(CodegenExpression cal) {
        return CodegenExpressionBuilder.exprDotMethod(cal, "get", CodegenExpressionBuilder.constant(this.fieldNum.getCalendarField()));
    }

    private CodegenExpression codegenJava8Get(CodegenExpression inner) {
        return CodegenExpressionBuilder.exprDotMethod(inner, "get", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.enumValue(CalendarFieldEnum.class, this.fieldNum.toString()), "getChronoField", new CodegenExpression[0]));
    }
}

